/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.debug;

import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.reflect.ReflectUtils;
import com.mchange.v2.sql.filter.FilterConnection;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLWarning;

public class AfterCloseLoggingConnectionWrapper
extends FilterConnection {
    static final MLogger logger = MLog.getLogger(AfterCloseLoggingConnectionWrapper.class);

    public static Connection wrap(Connection connection) {
        try {
            Constructor constructor = ReflectUtils.findProxyConstructor(AfterCloseLoggingConnectionWrapper.class.getClassLoader(), Connection.class);
            return (Connection)constructor.newInstance(new AfterCloseLoggingInvocationHandler(connection));
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.SEVERE)) {
                logger.log(MLevel.SEVERE, "An unexpected Exception occured while trying to instantiate a dynamic proxy.", exception);
            }
            throw new RuntimeException(exception);
        }
    }

    private static class AfterCloseLoggingInvocationHandler
    implements InvocationHandler {
        final Connection inner;
        volatile SQLWarning closeStackTrace = null;

        AfterCloseLoggingInvocationHandler(Connection connection) {
            this.inner = connection;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if ("close".equals(method.getName()) && this.closeStackTrace == null) {
                this.closeStackTrace = new SQLWarning("DEBUG STACK TRACE -- " + this.inner + ".close() first-call stack trace.");
            } else if (this.closeStackTrace != null) {
                if (logger.isLoggable(MLevel.INFO)) {
                    logger.log(MLevel.INFO, String.format("Method '%s' called after call to Connection close().", method));
                }
                if (logger.isLoggable(MLevel.FINE)) {
                    logger.log(MLevel.FINE, "After-close() method call stack trace:", new SQLWarning("DEBUG STACK TRACE -- ILLEGAL use of " + this.inner + " after call to close()."));
                    logger.log(MLevel.FINE, "Original close() call stack trace:", this.closeStackTrace);
                }
            }
            return method.invoke((Object)this.inner, objectArray);
        }
    }
}

