/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.reactor.engine;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.reactive.streams.ReactiveStreamsCamelSubscriber;
import org.apache.camel.component.reactive.streams.ReactiveStreamsConsumer;
import org.apache.camel.component.reactive.streams.ReactiveStreamsHelper;
import org.apache.camel.component.reactive.streams.ReactiveStreamsProducer;
import org.apache.camel.component.reactive.streams.api.CamelReactiveStreamsService;
import org.apache.camel.component.reactive.streams.util.BodyConverter;
import org.apache.camel.component.reactive.streams.util.ConvertingPublisher;
import org.apache.camel.component.reactive.streams.util.ConvertingSubscriber;
import org.apache.camel.component.reactive.streams.util.UnwrapStreamProcessor;
import org.apache.camel.component.reactor.engine.ReactorCamelProcessor;
import org.apache.camel.component.reactor.engine.ReactorStreamsConstants;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.function.Suppliers;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

final class ReactorStreamsService
extends ServiceSupport
implements CamelReactiveStreamsService {
    private final CamelContext context;
    private final Supplier<UnwrapStreamProcessor> unwrapStreamProcessorSupplier;
    private final ConcurrentMap<String, ReactorCamelProcessor> publishers;
    private final ConcurrentMap<String, ReactiveStreamsCamelSubscriber> subscribers;
    private final ConcurrentMap<String, String> publishedUriToStream;
    private final ConcurrentMap<String, String> requestedUriToStream;

    ReactorStreamsService(CamelContext context) {
        this.context = context;
        this.publishers = new ConcurrentHashMap<String, ReactorCamelProcessor>();
        this.subscribers = new ConcurrentHashMap<String, ReactiveStreamsCamelSubscriber>();
        this.publishedUriToStream = new ConcurrentHashMap<String, String>();
        this.requestedUriToStream = new ConcurrentHashMap<String, String>();
        this.unwrapStreamProcessorSupplier = Suppliers.memorize(UnwrapStreamProcessor::new);
    }

    @Override
    public String getId() {
        return "reactor";
    }

    @Override
    public CamelContext getCamelContext() {
        return this.context;
    }

    @Override
    public void doStart() throws Exception {
    }

    @Override
    public void doStop() throws Exception {
        for (ReactorCamelProcessor processor : this.publishers.values()) {
            processor.close();
        }
        for (ReactiveStreamsCamelSubscriber subscriber : this.subscribers.values()) {
            subscriber.close();
        }
    }

    @Override
    public Publisher<Exchange> fromStream(String name) {
        return this.getCamelProcessor(name).getPublisher();
    }

    @Override
    public <T> Publisher<T> fromStream(String name, Class<T> type) {
        Publisher<Exchange> publisher = this.fromStream(name);
        if (Exchange.class.isAssignableFrom(type)) {
            return (Publisher)Publisher.class.cast(publisher);
        }
        return Flux.from(publisher).map(BodyConverter.forType(type));
    }

    public ReactiveStreamsCamelSubscriber streamSubscriber(String name) {
        return this.subscribers.computeIfAbsent(name, n -> new ReactiveStreamsCamelSubscriber(name));
    }

    @Override
    public <T> Subscriber<T> streamSubscriber(String name, Class<T> type) {
        ReactiveStreamsCamelSubscriber subscriber = this.streamSubscriber(name);
        if (Exchange.class.equals(type)) {
            return (Subscriber)Subscriber.class.cast(subscriber);
        }
        return new ConvertingSubscriber<T>(subscriber, this.context, type);
    }

    @Override
    public Publisher<Exchange> toStream(String name, Object data) {
        return this.doRequest(name, ReactiveStreamsHelper.convertToExchange(this.context, data));
    }

    @Override
    public Function<?, ? extends Publisher<Exchange>> toStream(String name) {
        return data -> this.toStream(name, data);
    }

    @Override
    public <T> Publisher<T> toStream(String name, Object data, Class<T> type) {
        return new ConvertingPublisher<T>(this.toStream(name, data), type);
    }

    @Override
    public <T> Function<Object, Publisher<T>> toStream(String name, Class<T> type) {
        return data -> this.toStream(name, data, type);
    }

    @Override
    public Publisher<Exchange> from(String uri) {
        String name = this.publishedUriToStream.computeIfAbsent(uri, camelUri -> {
            try {
                String uuid = this.context.getUuidGenerator().generateUuid();
                RouteBuilder.addRoutes(this.context, rb -> rb.from((String)camelUri).to("reactive-streams:" + uuid));
                return uuid;
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to create source reactive stream from direct URI: " + uri, e);
            }
        });
        return this.fromStream(name);
    }

    @Override
    public <T> Publisher<T> from(String name, Class<T> type) {
        Publisher<Exchange> publisher = this.from(name);
        if (Exchange.class.isAssignableFrom(type)) {
            return (Publisher)Publisher.class.cast(publisher);
        }
        return Flux.from(publisher).map(BodyConverter.forType(type));
    }

    @Override
    public Subscriber<Exchange> subscriber(final String uri) {
        try {
            final String uuid = this.context.getUuidGenerator().generateUuid();
            this.context.addRoutes(new RouteBuilder(){

                @Override
                public void configure() throws Exception {
                    this.from("reactive-streams:" + uuid).to(uri);
                }
            });
            return this.streamSubscriber(uuid);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to create source reactive stream towards direct URI: " + uri, e);
        }
    }

    @Override
    public <T> Subscriber<T> subscriber(String uri, Class<T> type) {
        return new ConvertingSubscriber<T>(this.subscriber(uri), this.context, type);
    }

    @Override
    public Publisher<Exchange> to(String uri, Object data) {
        String streamName = this.requestedUriToStream.computeIfAbsent(uri, camelUri -> {
            try {
                final String uuid = this.context.getUuidGenerator().generateUuid();
                this.context.addRoutes(new RouteBuilder((String)camelUri){
                    final /* synthetic */ String val$camelUri;
                    {
                        this.val$camelUri = string2;
                    }

                    @Override
                    public void configure() throws Exception {
                        this.from("reactive-streams:" + uuid).to(this.val$camelUri);
                    }
                });
                return uuid;
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to create requested reactive stream from direct URI: " + uri, e);
            }
        });
        return this.toStream(streamName, data);
    }

    @Override
    public Function<Object, Publisher<Exchange>> to(String uri) {
        return data -> this.to(uri, data);
    }

    @Override
    public <T> Publisher<T> to(String uri, Object data, Class<T> type) {
        Publisher<Exchange> publisher = this.to(uri, data);
        return Flux.from(publisher).map(BodyConverter.forType(type));
    }

    @Override
    public <T> Function<Object, Publisher<T>> to(String uri, Class<T> type) {
        return data -> this.to(uri, data, type);
    }

    @Override
    public void process(final String uri, final Function<? super Publisher<Exchange>, ?> processor) {
        try {
            this.context.addRoutes(new RouteBuilder(){

                @Override
                public void configure() throws Exception {
                    ((RouteDefinition)this.from(uri).process(exchange -> {
                        Exchange copy = exchange.copy();
                        Object result = processor.apply(Mono.just(copy));
                        exchange.getIn().setBody(result);
                    })).process(ReactorStreamsService.this.unwrapStreamProcessorSupplier.get());
                }
            });
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to add reactive stream processor to the direct URI: " + uri, e);
        }
    }

    @Override
    public <T> void process(String uri, Class<T> type, Function<? super Publisher<T>, ?> processor) {
        this.process(uri, publisher -> processor.apply(Flux.from(publisher).map(BodyConverter.forType(type))));
    }

    @Override
    public void attachCamelProducer(String name, ReactiveStreamsProducer producer) {
        this.getCamelProcessor(name).attach(producer);
    }

    @Override
    public void detachCamelProducer(String name) {
        this.getCamelProcessor(name).detach();
    }

    @Override
    public void sendCamelExchange(String name, Exchange exchange) {
        this.getCamelProcessor(name).send(exchange);
    }

    private ReactorCamelProcessor getCamelProcessor(String name) {
        return this.publishers.computeIfAbsent(name, key -> new ReactorCamelProcessor(this, (String)key));
    }

    @Override
    public ReactiveStreamsCamelSubscriber attachCamelConsumer(String name, ReactiveStreamsConsumer consumer) {
        ReactiveStreamsCamelSubscriber subscriber = this.streamSubscriber(name);
        subscriber.attachConsumer(consumer);
        return subscriber;
    }

    @Override
    public void detachCamelConsumer(String name) {
        ReactiveStreamsCamelSubscriber subscriber = this.streamSubscriber(name);
        subscriber.detachConsumer();
    }

    protected Publisher<Exchange> doRequest(String name, Exchange data) {
        ReactiveStreamsConsumer consumer = this.streamSubscriber(name).getConsumer();
        if (consumer == null) {
            throw new IllegalStateException("No consumers attached to the stream " + name);
        }
        return Mono.create(sink -> data.getExchangeExtension().addOnCompletion(new Synchronization(){
            final /* synthetic */ MonoSink val$sink;
            {
                this.val$sink = monoSink;
            }

            @Override
            public void onComplete(Exchange exchange) {
                this.val$sink.success(exchange);
            }

            @Override
            public void onFailure(Exchange exchange) {
                Exception throwable = exchange.getException();
                if (throwable == null) {
                    throwable = new IllegalStateException("Unknown Exception");
                }
                this.val$sink.error(throwable);
            }
        })).doOnSubscribe(subs -> consumer.process(data, ReactorStreamsConstants.EMPTY_ASYNC_CALLBACK));
    }
}

