/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.concurrent.Rejectable;
import org.apache.camel.util.concurrent.ThreadPoolRejectedPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadsProcessor
extends AsyncProcessorSupport
implements IdAware,
RouteIdAware {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadsProcessor.class);
    private String id;
    private String routeId;
    private final CamelContext camelContext;
    private final ExecutorService executorService;
    private final ThreadPoolRejectedPolicy rejectedPolicy;
    private final boolean shutdownExecutorService;
    private final AtomicBoolean shutdown = new AtomicBoolean(true);

    public ThreadsProcessor(CamelContext camelContext, ExecutorService executorService, boolean shutdownExecutorService, ThreadPoolRejectedPolicy rejectedPolicy) {
        ObjectHelper.notNull(camelContext, "camelContext");
        ObjectHelper.notNull(executorService, "executorService");
        ObjectHelper.notNull(rejectedPolicy, "rejectedPolicy");
        this.camelContext = camelContext;
        this.executorService = executorService;
        this.shutdownExecutorService = shutdownExecutorService;
        this.rejectedPolicy = rejectedPolicy;
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (this.shutdown.get()) {
            throw new IllegalStateException("ThreadsProcessor is not running.");
        }
        if (exchange.isTransacted()) {
            LOG.trace("Transacted Exchange must be routed synchronously for exchangeId: {} -> {}", (Object)exchange.getExchangeId(), (Object)exchange);
            callback.done(true);
            return true;
        }
        try {
            ProcessCall call = new ProcessCall(exchange, callback, false);
            LOG.trace("Submitting task {}", (Object)call);
            this.executorService.submit(call);
            return false;
        }
        catch (Exception e) {
            ExecutorService executorService = this.executorService;
            if (executorService instanceof ThreadPoolExecutor) {
                ThreadPoolExecutor tpe = (ThreadPoolExecutor)executorService;
                ProcessCall call = new ProcessCall(exchange, callback, true);
                this.rejectedPolicy.asRejectedExecutionHandler().rejectedExecution(call, tpe);
                return true;
            }
            exchange.setException(e);
            callback.done(true);
            return true;
        }
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public String toString() {
        return this.id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public ThreadPoolRejectedPolicy getRejectedPolicy() {
        return this.rejectedPolicy;
    }

    @Override
    protected void doStart() throws Exception {
        this.shutdown.set(false);
    }

    @Override
    protected void doStop() throws Exception {
        this.shutdown.set(true);
    }

    @Override
    protected void doShutdown() throws Exception {
        if (this.shutdownExecutorService) {
            this.camelContext.getExecutorServiceManager().shutdownNow(this.executorService);
        }
        super.doShutdown();
    }

    private final class ProcessCall
    implements Runnable,
    Rejectable {
        private final Exchange exchange;
        private final AsyncCallback callback;
        private final boolean done;

        ProcessCall(Exchange exchange, AsyncCallback callback, boolean done) {
            this.exchange = exchange;
            this.callback = callback;
            this.done = done;
        }

        @Override
        public void run() {
            LOG.trace("Continue routing exchange {}", (Object)this.exchange);
            if (ThreadsProcessor.this.shutdown.get()) {
                this.exchange.setException(new RejectedExecutionException("ThreadsProcessor is not running."));
            }
            this.callback.done(this.done);
        }

        @Override
        public void reject() {
            this.exchange.setException(new RejectedExecutionException());
            LOG.trace("Rejected routing exchange {}", (Object)this.exchange);
            if (ThreadsProcessor.this.shutdown.get()) {
                this.exchange.setException(new RejectedExecutionException("ThreadsProcessor is not running."));
            }
            this.callback.done(this.done);
        }

        public String toString() {
            return "ProcessCall[" + this.exchange + "]";
        }
    }
}

