/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;

public class DefaultClassResolver
implements ClassResolver,
CamelContextAware {
    private Set<ClassLoader> classLoaders;
    private CamelContext camelContext;

    public DefaultClassResolver() {
    }

    public DefaultClassResolver(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void addClassLoader(ClassLoader classLoader) {
        if (this.classLoaders == null) {
            this.classLoaders = new LinkedHashSet<ClassLoader>();
        }
        this.classLoaders.add(classLoader);
    }

    @Override
    public Set<ClassLoader> getClassLoaders() {
        if (this.classLoaders == null) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableSet(this.classLoaders);
    }

    @Override
    public ClassLoader getClassLoader(String name) {
        if (this.classLoaders != null) {
            for (ClassLoader cl : this.classLoaders) {
                if (!name.equals(cl.getName())) continue;
                return cl;
            }
        }
        return null;
    }

    @Override
    public Class<?> resolveClass(String name) {
        Class<?> answer;
        if (this.classLoaders != null) {
            for (ClassLoader loader : this.classLoaders) {
                answer = this.loadClass(name, loader);
                if (answer == null) continue;
                return answer;
            }
        }
        if ((answer = this.loadClass(name, DefaultClassResolver.class.getClassLoader())) == null && this.getApplicationContextClassLoader() != null) {
            answer = this.loadClass(name, this.getApplicationContextClassLoader());
        }
        return answer;
    }

    @Override
    public <T> Class<T> resolveClass(String name, Class<T> type) {
        return CastUtils.cast(this.resolveClass(name), type);
    }

    @Override
    public Class<?> resolveClass(String name, ClassLoader loader) {
        return this.loadClass(name, loader);
    }

    @Override
    public <T> Class<T> resolveClass(String name, Class<T> type, ClassLoader loader) {
        return CastUtils.cast(this.loadClass(name, loader));
    }

    @Override
    public Class<?> resolveMandatoryClass(String name) throws ClassNotFoundException {
        Class<?> answer = this.resolveClass(name);
        if (answer == null) {
            throw new ClassNotFoundException(name);
        }
        return answer;
    }

    @Override
    public <T> Class<T> resolveMandatoryClass(String name, Class<T> type) throws ClassNotFoundException {
        Class<T> answer = this.resolveClass(name, type);
        if (answer == null) {
            throw new ClassNotFoundException(name);
        }
        return answer;
    }

    @Override
    public Class<?> resolveMandatoryClass(String name, ClassLoader loader) throws ClassNotFoundException {
        Class<?> answer = this.resolveClass(name, loader);
        if (answer == null) {
            throw new ClassNotFoundException(name);
        }
        return answer;
    }

    @Override
    public <T> Class<T> resolveMandatoryClass(String name, Class<T> type, ClassLoader loader) throws ClassNotFoundException {
        Class<T> answer = this.resolveClass(name, type, loader);
        if (answer == null) {
            throw new ClassNotFoundException(name);
        }
        return answer;
    }

    @Override
    public InputStream loadResourceAsStream(String uri) {
        return ObjectHelper.loadResourceAsStream(uri, this.getApplicationContextClassLoader());
    }

    @Override
    public URL loadResourceAsURL(String uri) {
        return ObjectHelper.loadResourceAsURL(uri, this.getApplicationContextClassLoader());
    }

    @Override
    public Enumeration<URL> loadResourcesAsURL(String uri) {
        return this.loadAllResourcesAsURL(uri);
    }

    @Override
    public Enumeration<URL> loadAllResourcesAsURL(String uri) {
        return ObjectHelper.loadResourcesAsURL(uri);
    }

    protected Class<?> loadClass(String name, ClassLoader loader) {
        return ObjectHelper.loadClass(name, loader);
    }

    protected ClassLoader getApplicationContextClassLoader() {
        return this.camelContext != null ? this.camelContext.getApplicationContextClassLoader() : null;
    }
}

