/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.WrapProcessor;
import org.apache.camel.reifier.AbstractPolicyReifier;
import org.apache.camel.spi.Policy;
import org.apache.camel.util.ObjectHelper;

public class PolicyReifier
extends AbstractPolicyReifier<PolicyDefinition> {
    public PolicyReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (PolicyDefinition)definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        Policy policy = this.resolvePolicy();
        ObjectHelper.notNull(policy, "policy", this.definition);
        policy.beforeWrap(this.route, this.definition);
        Processor childProcessor = this.createChildProcessor(true);
        Processor target = policy.wrap(this.route, childProcessor);
        if (!(target instanceof Service)) {
            target = new WrapProcessor(target, childProcessor);
        }
        return target;
    }

    protected Policy resolvePolicy() {
        return this.resolvePolicy(((PolicyDefinition)this.definition).getPolicy(), ((PolicyDefinition)this.definition).getRef(), ((PolicyDefinition)this.definition).getType());
    }
}

