/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.Collections;
import org.redisson.RedissonExpirable;
import org.redisson.api.ObjectListener;
import org.redisson.api.RAtomicLong;
import org.redisson.api.RFuture;
import org.redisson.api.listener.IncrByListener;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.client.protocol.convertor.Convertor;
import org.redisson.command.CommandAsyncExecutor;

public class RedissonAtomicLong
extends RedissonExpirable
implements RAtomicLong {
    public RedissonAtomicLong(CommandAsyncExecutor commandExecutor, String name) {
        super(commandExecutor, name);
    }

    @Override
    public long addAndGet(long delta) {
        return this.get(this.addAndGetAsync(delta));
    }

    @Override
    public RFuture<Long> addAndGetAsync(long delta) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.INCRBY, this.getRawName(), delta);
    }

    @Override
    public boolean compareAndSet(long expect, long update) {
        return this.get(this.compareAndSetAsync(expect, update));
    }

    @Override
    public RFuture<Boolean> compareAndSetAsync(long expect, long update) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local currValue = redis.call('get', KEYS[1]); if currValue == ARGV[1] or (tonumber(ARGV[1]) == 0 and currValue == false) then redis.call('set', KEYS[1], ARGV[2]); return 1 else return 0 end", Collections.singletonList(this.getRawName()), expect, update);
    }

    @Override
    public long getAndDelete() {
        return this.get(this.getAndDeleteAsync());
    }

    @Override
    public RFuture<Long> getAndDeleteAsync() {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.EVAL_LONG_SAFE, "local currValue = redis.call('get', KEYS[1]); redis.call('del', KEYS[1]); return currValue; ", Collections.singletonList(this.getRawName()), new Object[0]);
    }

    @Override
    public long decrementAndGet() {
        return this.get(this.decrementAndGetAsync());
    }

    @Override
    public RFuture<Long> decrementAndGetAsync() {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.DECR, this.getRawName());
    }

    @Override
    public long get() {
        return this.get(this.getAsync());
    }

    @Override
    public RFuture<Long> getAsync() {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.GET_LONG, this.getRawName());
    }

    @Override
    public long getAndAdd(long delta) {
        return this.get(this.getAndAddAsync(delta));
    }

    @Override
    public RFuture<Long> getAndAddAsync(final long delta) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, new RedisStrictCommand<Long>("INCRBY", new Convertor<Long>(){

            @Override
            public Long convert(Object obj) {
                return (Long)obj - delta;
            }
        }), this.getRawName(), delta);
    }

    @Override
    public long getAndSet(long newValue) {
        return this.get(this.getAndSetAsync(newValue));
    }

    @Override
    public RFuture<Long> getAndSetAsync(long newValue) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.GETSET_LONG, this.getRawName(), newValue);
    }

    @Override
    public long incrementAndGet() {
        return this.get(this.incrementAndGetAsync());
    }

    @Override
    public RFuture<Long> incrementAndGetAsync() {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.INCR, this.getRawName());
    }

    @Override
    public long getAndIncrement() {
        return this.getAndAdd(1L);
    }

    @Override
    public RFuture<Long> getAndIncrementAsync() {
        return this.getAndAddAsync(1L);
    }

    @Override
    public long getAndDecrement() {
        return this.getAndAdd(-1L);
    }

    @Override
    public RFuture<Long> getAndDecrementAsync() {
        return this.getAndAddAsync(-1L);
    }

    @Override
    public void set(long newValue) {
        this.get(this.setAsync(newValue));
    }

    @Override
    public RFuture<Void> setAsync(long newValue) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.SET, this.getRawName(), newValue);
    }

    public String toString() {
        return Long.toString(this.get());
    }

    @Override
    public int addListener(ObjectListener listener) {
        if (listener instanceof IncrByListener) {
            return this.addListener("__keyevent@*:incrby", (IncrByListener)listener, IncrByListener::onChange);
        }
        return super.addListener(listener);
    }

    @Override
    public RFuture<Integer> addListenerAsync(ObjectListener listener) {
        if (listener instanceof IncrByListener) {
            return this.addListenerAsync("__keyevent@*:incrby", (IncrByListener)listener, IncrByListener::onChange);
        }
        return super.addListenerAsync(listener);
    }

    @Override
    public void removeListener(int listenerId) {
        this.removeListener(listenerId, "__keyevent@*:incrby");
        super.removeListener(listenerId);
    }

    @Override
    public RFuture<Void> removeListenerAsync(int listenerId) {
        return this.removeListenerAsync(listenerId, "__keyevent@*:incrby");
    }
}

