/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.fury.Fury;
import org.apache.fury.ThreadSafeFury;
import org.apache.fury.config.FuryBuilder;
import org.apache.fury.config.Language;
import org.apache.fury.io.FuryStreamReader;
import org.apache.fury.memory.MemoryBuffer;
import org.apache.fury.memory.MemoryUtils;
import org.redisson.client.codec.BaseCodec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;

public class FuryCodec
extends BaseCodec {
    private final ThreadSafeFury fury;
    private final boolean registrationRequired;
    private final Language language;
    private final Decoder<Object> decoder = new Decoder<Object>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object decode(ByteBuf buf, State state) throws IOException {
            if (buf.nioBufferCount() == 1) {
                MemoryBuffer furyBuffer = MemoryUtils.wrap((ByteBuffer)buf.nioBuffer());
                try {
                    Object object = FuryCodec.this.fury.deserialize(furyBuffer);
                    return object;
                }
                finally {
                    buf.readerIndex(buf.readerIndex() + furyBuffer.readerIndex());
                }
            }
            return FuryCodec.this.fury.deserialize(FuryStreamReader.of((InputStream)new ByteBufInputStream(buf)));
        }
    };
    private final Encoder encoder = new Encoder(){

        @Override
        public ByteBuf encode(Object in) throws IOException {
            ByteBuf out = ByteBufAllocator.DEFAULT.buffer();
            MemoryBuffer furyBuffer = null;
            int remainingSize = out.capacity() - out.writerIndex();
            if (out.hasArray()) {
                furyBuffer = MemoryUtils.wrap((byte[])out.array(), (int)(out.arrayOffset() + out.writerIndex()), (int)remainingSize);
            } else if (out.hasMemoryAddress()) {
                furyBuffer = MemoryUtils.buffer((long)(out.memoryAddress() + (long)out.writerIndex()), (int)remainingSize);
            }
            if (furyBuffer != null) {
                int size = furyBuffer.size();
                FuryCodec.this.fury.serialize(furyBuffer, in);
                if (furyBuffer.size() > size) {
                    out.writeBytes(furyBuffer.getHeapMemory(), 0, furyBuffer.size());
                } else {
                    out.writerIndex(out.writerIndex() + furyBuffer.writerIndex());
                }
                return out;
            }
            try {
                ByteBufOutputStream baos = new ByteBufOutputStream(out);
                FuryCodec.this.fury.serialize((OutputStream)baos, in);
                return baos.buffer();
            }
            catch (Exception e) {
                out.release();
                throw e;
            }
        }
    };

    public FuryCodec() {
        this(null, false, Language.JAVA);
    }

    public FuryCodec(boolean registrationRequired) {
        this(null, registrationRequired, Language.JAVA);
    }

    public FuryCodec(Language language) {
        this(null, false, language);
    }

    public FuryCodec(boolean registrationRequired, Language language) {
        this(null, registrationRequired, language);
    }

    public FuryCodec(ClassLoader classLoader, FuryCodec codec) {
        this(classLoader, codec.registrationRequired, codec.language);
    }

    public FuryCodec(ClassLoader classLoader) {
        this(classLoader, false, Language.JAVA);
    }

    public FuryCodec(ClassLoader classLoader, boolean registrationRequired, Language language) {
        this.registrationRequired = registrationRequired;
        this.language = language;
        FuryBuilder builder = Fury.builder();
        if (classLoader != null) {
            builder.withClassLoader(classLoader);
        }
        builder.withLanguage(language);
        builder.requireClassRegistration(registrationRequired);
        this.fury = builder.buildThreadSafeFuryPool(10, 512);
    }

    @Override
    public Decoder<Object> getValueDecoder() {
        return this.decoder;
    }

    @Override
    public Encoder getValueEncoder() {
        return this.encoder;
    }
}

