/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.AbstractMap;
import java.util.Map;
import java.util.function.Consumer;
import org.redisson.RedissonMap;
import org.redisson.ScanResult;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClient;
import org.redisson.reactive.IteratorConsumer;
import reactor.core.publisher.FluxSink;

public class MapReactiveIterator<K, V, M>
implements Consumer<FluxSink<M>> {
    private final RedissonMap<K, V> map;
    private final String pattern;
    private final int count;

    public MapReactiveIterator(RedissonMap<K, V> map, String pattern, int count) {
        this.map = map;
        this.pattern = pattern;
        this.count = count;
    }

    @Override
    public void accept(FluxSink<M> emitter) {
        emitter.onRequest(new IteratorConsumer<M>(emitter){

            @Override
            protected boolean tryAgain() {
                return MapReactiveIterator.this.tryAgain();
            }

            @Override
            protected Object transformValue(Object value) {
                return MapReactiveIterator.this.getValue((Map.Entry)value);
            }

            @Override
            protected RFuture<ScanResult<Object>> scanIterator(RedisClient client, String nextIterPos) {
                return MapReactiveIterator.this.scanIterator(client, nextIterPos);
            }
        });
    }

    protected boolean tryAgain() {
        return false;
    }

    M getValue(final Map.Entry<Object, Object> entry) {
        return (M)new AbstractMap.SimpleEntry<K, V>(entry.getKey(), entry.getValue()){

            @Override
            public V setValue(V value) {
                return MapReactiveIterator.this.map.put(entry.getKey(), value);
            }
        };
    }

    public RFuture<ScanResult<Object>> scanIterator(RedisClient client, String nextIterPos) {
        return this.map.scanIteratorAsync(this.map.getRawName(), client, nextIterPos, this.pattern, this.count);
    }
}

