/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api.options;

import java.time.Duration;
import org.redisson.api.IdGenerator;
import org.redisson.api.options.BaseOptions;
import org.redisson.api.options.ExecutorOptions;
import org.redisson.client.codec.Codec;

public final class ExecutorParams
extends BaseOptions<ExecutorOptions, Codec>
implements ExecutorOptions {
    private final String name;
    private int taskRetryInterval = 300000;
    private IdGenerator idGenerator = IdGenerator.random();

    ExecutorParams(String name) {
        this.name = name;
    }

    @Override
    public ExecutorOptions taskRetryInterval(Duration interval) {
        this.taskRetryInterval = (int)interval.toMillis();
        return this;
    }

    @Override
    public ExecutorOptions idGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public int getTaskRetryInterval() {
        return this.taskRetryInterval;
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }
}

