/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.pubsub;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.redisson.PubSubEntry;
import org.redisson.client.BaseRedisPubSubListener;
import org.redisson.client.ChannelName;
import org.redisson.client.RedisPubSubListener;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.misc.AsyncSemaphore;
import org.redisson.pubsub.PubSubConnectionEntry;
import org.redisson.pubsub.PublishSubscribeService;

abstract class PublishSubscribe<E extends PubSubEntry<E>> {
    private final ConcurrentMap<String, E> entries = new ConcurrentHashMap<String, E>();
    private final PublishSubscribeService service;

    PublishSubscribe(PublishSubscribeService service) {
        this.service = service;
    }

    public void unsubscribe(E entry, String entryName, String channelName) {
        ChannelName cn = new ChannelName(channelName);
        AsyncSemaphore semaphore = this.service.getSemaphore(cn);
        semaphore.acquire().thenAccept(c -> {
            if (entry.release() == 0) {
                this.entries.remove(entryName);
                this.service.unsubscribeLocked(cn).whenComplete((r, e) -> semaphore.release());
            } else {
                semaphore.release();
            }
        });
    }

    public void timeout(CompletableFuture<?> promise) {
        this.service.timeout(promise);
    }

    public void timeout(CompletableFuture<?> promise, long timeout) {
        this.service.timeout(promise, timeout);
    }

    public CompletableFuture<E> subscribe(String entryName, String channelName) {
        AsyncSemaphore semaphore = this.service.getSemaphore(new ChannelName(channelName));
        CompletableFuture newPromise = new CompletableFuture();
        semaphore.acquire().thenAccept(c -> {
            if (newPromise.isDone()) {
                semaphore.release();
                return;
            }
            PubSubEntry entry = (PubSubEntry)this.entries.get(entryName);
            if (entry != null) {
                entry.acquire();
                semaphore.release();
                entry.getPromise().whenComplete((r, e) -> {
                    if (e != null) {
                        newPromise.completeExceptionally((Throwable)e);
                        return;
                    }
                    newPromise.complete(r);
                });
                return;
            }
            E value = this.createEntry(newPromise);
            value.acquire();
            PubSubEntry oldValue = (PubSubEntry)this.entries.putIfAbsent(entryName, value);
            if (oldValue != null) {
                oldValue.acquire();
                semaphore.release();
                oldValue.getPromise().whenComplete((r, e) -> {
                    if (e != null) {
                        newPromise.completeExceptionally((Throwable)e);
                        return;
                    }
                    newPromise.complete(r);
                });
                return;
            }
            RedisPubSubListener<Object> listener = this.createListener(channelName, value);
            CompletableFuture<PubSubConnectionEntry> s = this.service.subscribeNoTimeout((Codec)LongCodec.INSTANCE, channelName, semaphore, listener);
            newPromise.whenComplete((r, e) -> {
                if (e != null) {
                    s.completeExceptionally((Throwable)e);
                }
            });
            s.whenComplete((r, e) -> {
                if (e != null) {
                    this.entries.remove(entryName);
                    value.getPromise().completeExceptionally((Throwable)e);
                    return;
                }
                if (!value.getPromise().complete(value) && value.getPromise().isCompletedExceptionally()) {
                    this.entries.remove(entryName);
                }
            });
        });
        return newPromise;
    }

    protected abstract E createEntry(CompletableFuture<E> var1);

    protected abstract void onMessage(E var1, Long var2);

    private RedisPubSubListener<Object> createListener(final String channelName, E value) {
        BaseRedisPubSubListener listener = new BaseRedisPubSubListener((PubSubEntry)value){
            final /* synthetic */ PubSubEntry val$value;
            {
                this.val$value = pubSubEntry;
            }

            @Override
            public void onMessage(CharSequence channel, Object message) {
                if (!channelName.equals(channel.toString())) {
                    return;
                }
                PublishSubscribe.this.onMessage(this.val$value, (Long)message);
            }
        };
        return listener;
    }
}

