/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.redisson.RedissonExpirable;
import org.redisson.RedissonLockEntry;
import org.redisson.api.RFuture;
import org.redisson.api.RSemaphore;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.pubsub.SemaphorePubSub;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedissonSemaphore
extends RedissonExpirable
implements RSemaphore {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedissonSemaphore.class);
    private final SemaphorePubSub semaphorePubSub = this.getSubscribeService().getSemaphorePubSub();

    public RedissonSemaphore(CommandAsyncExecutor commandExecutor, String name) {
        super(commandExecutor, name);
    }

    String getChannelName() {
        return RedissonSemaphore.getChannelName(this.getRawName());
    }

    public static String getChannelName(String name) {
        return RedissonSemaphore.prefixName("redisson_sc", name);
    }

    @Override
    public void acquire() throws InterruptedException {
        this.acquire(1);
    }

    @Override
    public void acquire(int permits) throws InterruptedException {
        if (this.tryAcquire(permits)) {
            return;
        }
        CompletableFuture<RedissonLockEntry> future = this.subscribe();
        this.semaphorePubSub.timeout((CompletableFuture)future);
        RedissonLockEntry entry = this.commandExecutor.getInterrupted(future);
        try {
            while (true) {
                if (this.tryAcquire(permits)) {
                    return;
                }
                entry.getLatch().acquire();
            }
        }
        finally {
            this.unsubscribe(entry);
        }
    }

    @Override
    public RFuture<Void> acquireAsync() {
        return this.acquireAsync(1);
    }

    @Override
    public RFuture<Void> acquireAsync(int permits) {
        CompletableFuture result = new CompletableFuture();
        RFuture<Boolean> tryAcquireFuture = this.tryAcquireAsync(permits);
        tryAcquireFuture.whenComplete((res, e) -> {
            if (e != null) {
                result.completeExceptionally((Throwable)e);
                return;
            }
            if (res.booleanValue()) {
                if (!result.complete(null)) {
                    this.releaseAsync(permits);
                }
                return;
            }
            CompletableFuture<RedissonLockEntry> subscribeFuture = this.subscribe();
            this.semaphorePubSub.timeout((CompletableFuture)subscribeFuture);
            subscribeFuture.whenComplete((r, e1) -> {
                if (e1 != null) {
                    result.completeExceptionally((Throwable)e1);
                    return;
                }
                this.acquireAsync(permits, (RedissonLockEntry)r, result);
            });
        });
        return new CompletableFutureWrapper<Void>(result);
    }

    private void tryAcquireAsync(final AtomicLong time, final int permits, final RedissonLockEntry entry, final CompletableFuture<Boolean> result) {
        if (result.isDone()) {
            this.unsubscribe(entry);
            return;
        }
        if (time.get() <= 0L) {
            this.unsubscribe(entry);
            result.complete(false);
            return;
        }
        long curr = System.currentTimeMillis();
        RFuture<Boolean> tryAcquireFuture = this.tryAcquireAsync(permits);
        tryAcquireFuture.whenComplete((res, e) -> {
            if (e != null) {
                this.unsubscribe(entry);
                result.completeExceptionally((Throwable)e);
                return;
            }
            if (res.booleanValue()) {
                this.unsubscribe(entry);
                if (!result.complete(true)) {
                    this.releaseAsync(permits);
                }
                return;
            }
            long el = System.currentTimeMillis() - curr;
            time.addAndGet(-el);
            if (time.get() <= 0L) {
                this.unsubscribe(entry);
                result.complete(false);
                return;
            }
            final long current = System.currentTimeMillis();
            if (entry.getLatch().tryAcquire()) {
                this.tryAcquireAsync(time, permits, entry, result);
            } else {
                AtomicBoolean executed = new AtomicBoolean();
                AtomicReference<Timeout> futureRef = new AtomicReference<Timeout>();
                final Runnable listener = () -> {
                    executed.set(true);
                    if (futureRef.get() != null && !((Timeout)futureRef.get()).cancel()) {
                        entry.getLatch().release();
                        return;
                    }
                    long elapsed = System.currentTimeMillis() - current;
                    time.addAndGet(-elapsed);
                    this.tryAcquireAsync(time, permits, entry, result);
                };
                entry.addListener(listener);
                long t = time.get();
                if (!executed.get()) {
                    Timeout scheduledFuture = this.commandExecutor.getServiceManager().newTimeout(new TimerTask(){

                        @Override
                        public void run(Timeout timeout) throws Exception {
                            if (entry.removeListener(listener)) {
                                long elapsed = System.currentTimeMillis() - current;
                                time.addAndGet(-elapsed);
                                RedissonSemaphore.this.tryAcquireAsync(time, permits, entry, result);
                            }
                        }
                    }, t, TimeUnit.MILLISECONDS);
                    futureRef.set(scheduledFuture);
                }
            }
        });
    }

    private void acquireAsync(int permits, RedissonLockEntry entry, CompletableFuture<Void> result) {
        if (result.isDone()) {
            this.unsubscribe(entry);
            return;
        }
        RFuture<Boolean> tryAcquireFuture = this.tryAcquireAsync(permits);
        tryAcquireFuture.whenComplete((res, e) -> {
            if (e != null) {
                this.unsubscribe(entry);
                result.completeExceptionally((Throwable)e);
                return;
            }
            if (res.booleanValue()) {
                this.unsubscribe(entry);
                if (!result.complete(null)) {
                    this.releaseAsync(permits);
                }
                return;
            }
            if (entry.getLatch().tryAcquire()) {
                this.acquireAsync(permits, entry, result);
            } else {
                entry.addListener(() -> this.acquireAsync(permits, entry, result));
            }
        });
    }

    @Override
    public boolean tryAcquire() {
        return this.tryAcquire(1);
    }

    @Override
    public boolean tryAcquire(int permits) {
        return this.get(this.tryAcquireAsync(permits));
    }

    @Override
    public RFuture<Boolean> tryAcquireAsync() {
        return this.tryAcquireAsync(1);
    }

    @Override
    public RFuture<Boolean> tryAcquireAsync(int permits) {
        if (permits < 0) {
            throw new IllegalArgumentException("Permits amount can't be negative");
        }
        if (permits == 0) {
            return new CompletableFutureWrapper<Boolean>(true);
        }
        return this.commandExecutor.getServiceManager().execute(() -> {
            RFuture<Boolean> future = this.tryAcquireAsync0(permits);
            return this.commandExecutor.handleNoSync(future, () -> this.releaseAsync(permits));
        });
    }

    private RFuture<Boolean> tryAcquireAsync0(int permits) {
        return this.commandExecutor.syncedEval(this.getRawName(), LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local value = redis.call('get', KEYS[1]); if (value ~= false and tonumber(value) >= tonumber(ARGV[1])) then local val = redis.call('decrby', KEYS[1], ARGV[1]); return 1; end; return 0;", Collections.singletonList(this.getRawName()), permits);
    }

    @Override
    public RFuture<Boolean> tryAcquireAsync(long waitTime, TimeUnit unit) {
        return this.tryAcquireAsync(1, waitTime, unit);
    }

    @Override
    public boolean tryAcquire(Duration waitTime) throws InterruptedException {
        return this.tryAcquire(1, waitTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryAcquire(int permits, Duration waitTime) throws InterruptedException {
        RedissonLockEntry entry;
        LOGGER.debug("trying to acquire, permits: {}, waitTime: {}, name: {}", new Object[]{permits, waitTime, this.getName()});
        long time = waitTime.toMillis();
        long current = System.currentTimeMillis();
        if (this.tryAcquire(permits)) {
            LOGGER.debug("acquired, permits: {}, waitTime: {}, name: {}", new Object[]{permits, waitTime, this.getName()});
            return true;
        }
        if ((time -= System.currentTimeMillis() - current) <= 0L) {
            LOGGER.debug("unable to acquire, permits: {}, name: {}", (Object)permits, (Object)this.getName());
            return false;
        }
        current = System.currentTimeMillis();
        CompletableFuture<RedissonLockEntry> future = this.subscribe();
        try {
            entry = future.get(time, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
        catch (CancellationException | TimeoutException e) {
            LOGGER.debug("unable to subscribe for permits acquisition, permits: {}, name: {}", (Object)permits, (Object)this.getName());
            return false;
        }
        try {
            if ((time -= System.currentTimeMillis() - current) <= 0L) {
                LOGGER.debug("unable to acquire, permits: {}, name: {}", (Object)permits, (Object)this.getName());
                boolean bl = false;
                return bl;
            }
            do {
                current = System.currentTimeMillis();
                if (this.tryAcquire(permits)) {
                    LOGGER.debug("acquired, permits: {}, wait-time: {}, name: {}", new Object[]{permits, waitTime, this.getName()});
                    boolean bl = true;
                    return bl;
                }
                if ((time -= System.currentTimeMillis() - current) <= 0L) {
                    LOGGER.debug("unable to acquire, permits: {}, name: {}", (Object)permits, (Object)this.getName());
                    boolean bl = false;
                    return bl;
                }
                current = System.currentTimeMillis();
                LOGGER.debug("wait for acquisition, permits: {}, wait-time(ms): {}, name: {}", new Object[]{permits, time, this.getName()});
                entry.getLatch().tryAcquire(time, TimeUnit.MILLISECONDS);
            } while ((time -= System.currentTimeMillis() - current) > 0L);
            LOGGER.debug("unable to acquire, permits: {}, name: {}", (Object)permits, (Object)this.getName());
            boolean bl = false;
            return bl;
        }
        finally {
            this.unsubscribe(entry);
        }
    }

    @Override
    public RFuture<Boolean> tryAcquireAsync(Duration waitTime) {
        return this.tryAcquireAsync(1, waitTime);
    }

    @Override
    public RFuture<Boolean> tryAcquireAsync(int permits, Duration waitTime) {
        CompletableFuture result = new CompletableFuture();
        AtomicLong time = new AtomicLong(waitTime.toMillis());
        long curr = System.currentTimeMillis();
        RFuture<Boolean> tryAcquireFuture = this.tryAcquireAsync(permits);
        tryAcquireFuture.whenComplete((res, e) -> {
            if (e != null) {
                result.completeExceptionally((Throwable)e);
                return;
            }
            if (res.booleanValue()) {
                if (!result.complete(true)) {
                    this.releaseAsync(permits);
                }
                return;
            }
            long elap = System.currentTimeMillis() - curr;
            time.addAndGet(-elap);
            if (time.get() <= 0L) {
                result.complete(false);
                return;
            }
            long current = System.currentTimeMillis();
            CompletableFuture<RedissonLockEntry> subscribeFuture = this.subscribe();
            this.semaphorePubSub.timeout((CompletableFuture)subscribeFuture, time.get());
            subscribeFuture.whenComplete((r, ex) -> {
                if (ex != null) {
                    result.completeExceptionally((Throwable)ex);
                    return;
                }
                long elapsed = System.currentTimeMillis() - current;
                time.addAndGet(-elapsed);
                if (time.get() < 0L) {
                    this.unsubscribe((RedissonLockEntry)r);
                    result.complete(false);
                    return;
                }
                this.tryAcquireAsync(time, permits, (RedissonLockEntry)r, result);
            });
        });
        return new CompletableFutureWrapper<Boolean>(result);
    }

    @Override
    public boolean tryAcquire(int permits, long waitTime, TimeUnit unit) throws InterruptedException {
        return this.tryAcquire(permits, Duration.ofMillis(unit.toMillis(waitTime)));
    }

    @Override
    public RFuture<Boolean> tryAcquireAsync(int permits, long waitTime, TimeUnit unit) {
        return this.tryAcquireAsync(permits, Duration.ofMillis(unit.toMillis(waitTime)));
    }

    private CompletableFuture<RedissonLockEntry> subscribe() {
        return this.semaphorePubSub.subscribe(this.getRawName(), this.getChannelName());
    }

    private void unsubscribe(RedissonLockEntry entry) {
        this.semaphorePubSub.unsubscribe(entry, this.getRawName(), this.getChannelName());
    }

    @Override
    public boolean tryAcquire(long time, TimeUnit unit) throws InterruptedException {
        return this.tryAcquire(1, time, unit);
    }

    @Override
    public void release() {
        this.release(1);
    }

    @Override
    public void release(int permits) {
        this.get(this.releaseAsync(permits));
    }

    @Override
    public RFuture<Void> releaseAsync() {
        return this.releaseAsync(1);
    }

    @Override
    public RFuture<Void> releaseAsync(int permits) {
        if (permits < 0) {
            throw new IllegalArgumentException("Permits amount can't be negative");
        }
        if (permits == 0) {
            return new CompletableFutureWrapper<Void>((Void)null);
        }
        RFuture<Void> future = this.commandExecutor.syncedEval(this.getRawName(), StringCodec.INSTANCE, RedisCommands.EVAL_VOID, "local value = redis.call('incrby', KEYS[1], ARGV[1]); redis.call(ARGV[2], KEYS[2], value); ", Arrays.asList(this.getRawName(), this.getChannelName()), permits, this.getSubscribeService().getPublishCommand());
        if (LOGGER.isDebugEnabled()) {
            future.thenAccept(o -> LOGGER.debug("released, permits: {}, name: {}", (Object)permits, (Object)this.getName()));
        }
        return future;
    }

    @Override
    public int drainPermits() {
        return this.get(this.drainPermitsAsync());
    }

    @Override
    public RFuture<Integer> drainPermitsAsync() {
        return this.commandExecutor.syncedEvalWithRetry(this.getRawName(), LongCodec.INSTANCE, RedisCommands.EVAL_INTEGER, "local value = redis.call('get', KEYS[1]); if (value == false) then return 0; end; redis.call('set', KEYS[1], 0); return value;", Collections.singletonList(this.getRawName()), new Object[0]);
    }

    @Override
    public int availablePermits() {
        return this.get(this.availablePermitsAsync());
    }

    @Override
    public RFuture<Integer> availablePermitsAsync() {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.GET_INTEGER, this.getRawName());
    }

    @Override
    public boolean trySetPermits(int permits) {
        return this.get(this.trySetPermitsAsync(permits));
    }

    @Override
    public RFuture<Boolean> trySetPermitsAsync(int permits) {
        RFuture<Boolean> future = this.commandExecutor.syncedEvalWithRetry(this.getRawName(), LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local value = redis.call('get', KEYS[1]); if (value == false) then redis.call('set', KEYS[1], ARGV[1]); redis.call(ARGV[2], KEYS[2], ARGV[1]); return 1;end;return 0;", Arrays.asList(this.getRawName(), this.getChannelName()), permits, this.getSubscribeService().getPublishCommand());
        if (LOGGER.isDebugEnabled()) {
            future.thenAccept(r -> {
                if (r.booleanValue()) {
                    LOGGER.debug("permits set, permits: {}, name: {}", (Object)permits, (Object)this.getName());
                } else {
                    LOGGER.debug("unable to set permits, permits: {}, name: {}", (Object)permits, (Object)this.getName());
                }
            });
        }
        return future;
    }

    @Override
    public boolean trySetPermits(int permits, Duration timeToLive) {
        return this.get(this.trySetPermitsAsync(permits, timeToLive));
    }

    @Override
    public RFuture<Boolean> trySetPermitsAsync(int permits, Duration timeToLive) {
        RFuture<Boolean> future = this.commandExecutor.syncedEvalWithRetry(this.getRawName(), LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local value = redis.call('get', KEYS[1]); if (value == false) then redis.call('set', KEYS[1], ARGV[1], 'px', ARGV[3]); redis.call(ARGV[2], KEYS[2], ARGV[1]); return 1;end;return 0;", Arrays.asList(this.getRawName(), this.getChannelName()), permits, this.getSubscribeService().getPublishCommand(), timeToLive.toMillis());
        if (LOGGER.isDebugEnabled()) {
            future.thenAccept(r -> {
                if (r.booleanValue()) {
                    LOGGER.debug("permits set, permits: {}, name: {}", (Object)permits, (Object)this.getName());
                } else {
                    LOGGER.debug("unable to set permits, permits: {}, name: {}", (Object)permits, (Object)this.getName());
                }
            });
        }
        return future;
    }

    @Override
    public void addPermits(int permits) {
        this.get(this.addPermitsAsync(permits));
    }

    @Override
    public RFuture<Void> addPermitsAsync(int permits) {
        return this.commandExecutor.syncedEvalWithRetry(this.getRawName(), LongCodec.INSTANCE, RedisCommands.EVAL_VOID, "local value = redis.call('get', KEYS[1]); if (value == false) then value = 0;end;redis.call('set', KEYS[1], value + ARGV[1]); redis.call(ARGV[2], KEYS[2], value + ARGV[1]); ", Arrays.asList(this.getRawName(), this.getChannelName()), permits, this.getSubscribeService().getPublishCommand());
    }
}

