/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.codec;

import java.util.Arrays;
import java.util.List;
import org.redisson.cache.LocalCachedMessageCodec;
import org.redisson.client.codec.BitSetCodec;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.IntegerCodec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;
import org.redisson.jcache.JCacheEventCodec;

public abstract class BaseCodec
implements Codec {
    public static final List<Class<?>> SKIPPED_CODECS = Arrays.asList(StringCodec.class, ByteArrayCodec.class, LocalCachedMessageCodec.class, BitSetCodec.class, JCacheEventCodec.class, LongCodec.class, IntegerCodec.class);

    public static <T> T copy(ClassLoader classLoader, T codec) throws ReflectiveOperationException {
        if (codec == null) {
            return codec;
        }
        for (Class<?> clazz : SKIPPED_CODECS) {
            if (!clazz.isAssignableFrom(codec.getClass())) continue;
            return codec;
        }
        return (T)codec.getClass().getConstructor(ClassLoader.class, codec.getClass()).newInstance(classLoader, codec);
    }

    @Override
    public Decoder<Object> getMapValueDecoder() {
        return this.getValueDecoder();
    }

    @Override
    public Encoder getMapValueEncoder() {
        return this.getValueEncoder();
    }

    @Override
    public Decoder<Object> getMapKeyDecoder() {
        return this.getValueDecoder();
    }

    @Override
    public Encoder getMapKeyEncoder() {
        return this.getValueEncoder();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    public String toString() {
        return this.getClass().getName();
    }
}

