/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ref;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.DelegateEndpoint;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="1.2.0", scheme="ref", title="Ref", syntax="ref:name", remote=false, category={Category.CORE})
public class RefEndpoint
extends DefaultEndpoint
implements DelegateEndpoint {
    private volatile Endpoint endpoint;
    @UriPath
    @Metadata(required=true)
    private String name;

    public RefEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Producer createProducer() throws Exception {
        return this.endpoint.createProducer();
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        return this.endpoint.createConsumer(processor);
    }

    @Override
    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    protected void doInit() throws Exception {
        if (this.endpoint == null) {
            this.endpoint = CamelContextHelper.mandatoryLookup(this.getCamelContext(), this.name, Endpoint.class);
            if (this.getCamelContext().getEndpoint(this.getEndpoint().getEndpointUri()) == null || this.getCamelContext().getEndpoint(this.getEndpoint().getEndpointUri()) != this.endpoint) {
                this.getCamelContext().addEndpoint(this.getEndpoint().getEndpointUri(), this.endpoint);
            }
        }
        super.doInit();
    }
}

