/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlTransient;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.camel.CamelContext;
import org.apache.camel.RouteTemplateContext;
import org.apache.camel.spi.BeanRepository;
import org.apache.camel.support.LocalBeanRegistry;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;

@XmlTransient
public final class DefaultRouteTemplateContext
implements RouteTemplateContext {
    private final CamelContext camelContext;
    private final LocalBeanRegistry registry;
    private final Map<String, Object> parameters;
    private Consumer<RouteTemplateContext> configurer;

    public DefaultRouteTemplateContext(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.registry = new LocalBeanRegistry();
        this.parameters = new HashMap<String, Object>();
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void bind(String id, Object bean) {
        if (bean instanceof RouteTemplateContext.BeanSupplier) {
            RouteTemplateContext.BeanSupplier bs = (RouteTemplateContext.BeanSupplier)bean;
            this.registry.bind(id, () -> bs.get(this));
        } else {
            this.registry.bind(id, bean);
        }
    }

    @Override
    public void bind(String id, Class<?> type, Object bean) {
        if (bean instanceof RouteTemplateContext.BeanSupplier) {
            RouteTemplateContext.BeanSupplier bs = (RouteTemplateContext.BeanSupplier)bean;
            this.registry.bind(id, type, () -> bs.get(this));
        } else {
            this.registry.bind(id, type, bean);
        }
    }

    @Override
    public void bind(String id, Class<?> type, Supplier<Object> bean) {
        this.registry.bind(id, type, bean);
    }

    @Override
    public void bindAsPrototype(String id, Class<?> type, Supplier<Object> bean) {
        this.registry.bindAsPrototype(id, type, bean);
    }

    @Override
    public void registerDestroyMethod(String id, String method) {
        this.registry.registerDestroyMethod(id, method);
    }

    @Override
    public Object getProperty(String name) {
        return this.parameters.get(name);
    }

    @Override
    public <T> T getProperty(String name, Class<?> type) {
        Object value = this.parameters.get(name);
        return (T)this.camelContext.getTypeConverter().tryConvertTo(type, value);
    }

    @Override
    public void setParameter(String name, Object value) {
        this.parameters.put(name, value);
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    public boolean hasParameter(String name) {
        if (this.parameters.containsKey(name)) {
            return true;
        }
        if (this.parameters.containsKey(name = StringHelper.dashToCamelCase(name))) {
            return true;
        }
        return this.parameters.containsKey(name = StringHelper.camelCaseToDash(name));
    }

    @Override
    public boolean hasEnvironmentVariable(String name) {
        String normalizedKey = IOHelper.normalizeEnvironmentVariable(name);
        if (this.parameters.containsKey(normalizedKey)) {
            return true;
        }
        normalizedKey = IOHelper.normalizeEnvironmentVariable(StringHelper.camelCaseToDash(name));
        return this.parameters.containsKey(normalizedKey);
    }

    @Override
    public Object getEnvironmentVariable(String name) {
        String normalizedKey = IOHelper.normalizeEnvironmentVariable(name);
        if (this.parameters.containsKey(normalizedKey)) {
            return this.parameters.get(normalizedKey);
        }
        normalizedKey = IOHelper.normalizeEnvironmentVariable(StringHelper.camelCaseToDash(name));
        if (this.parameters.containsKey(normalizedKey)) {
            return this.parameters.get(normalizedKey);
        }
        return null;
    }

    @Override
    public BeanRepository getLocalBeanRepository() {
        return this.registry;
    }

    @Override
    public Consumer<RouteTemplateContext> getConfigurer() {
        return this.configurer;
    }

    @Override
    public void setConfigurer(Consumer<RouteTemplateContext> configurer) {
        this.configurer = configurer;
    }
}

