/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker;

import io.github.resilience4j.core.IntervalFunction;
import io.github.resilience4j.core.functions.Either;
import io.github.resilience4j.core.lang.Nullable;
import io.github.resilience4j.core.predicate.PredicateCreator;
import java.io.Serializable;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;

public class CircuitBreakerConfig
implements Serializable {
    private static final long serialVersionUID = -5429814941777001669L;
    public static final int DEFAULT_FAILURE_RATE_THRESHOLD = 50;
    public static final int DEFAULT_SLOW_CALL_RATE_THRESHOLD = 100;
    public static final int DEFAULT_WAIT_DURATION_IN_OPEN_STATE = 60;
    public static final int DEFAULT_PERMITTED_CALLS_IN_HALF_OPEN_STATE = 10;
    public static final int DEFAULT_MINIMUM_NUMBER_OF_CALLS = 100;
    public static final int DEFAULT_SLIDING_WINDOW_SIZE = 100;
    public static final int DEFAULT_SLOW_CALL_DURATION_THRESHOLD = 60;
    public static final int DEFAULT_WAIT_DURATION_IN_HALF_OPEN_STATE = 0;
    public static final SlidingWindowType DEFAULT_SLIDING_WINDOW_TYPE = SlidingWindowType.COUNT_BASED;
    public static final boolean DEFAULT_WRITABLE_STACK_TRACE_ENABLED = true;
    private static final Predicate<Throwable> DEFAULT_RECORD_EXCEPTION_PREDICATE = throwable -> true;
    private static final Predicate<Throwable> DEFAULT_IGNORE_EXCEPTION_PREDICATE = throwable -> false;
    private static final Function<Clock, Long> DEFAULT_TIMESTAMP_FUNCTION = clock -> System.nanoTime();
    private static final TimeUnit DEFAULT_TIMESTAMP_UNIT = TimeUnit.NANOSECONDS;
    private static final Predicate<Object> DEFAULT_RECORD_RESULT_PREDICATE = object -> false;
    private static final Function<Either<Object, Throwable>, TransitionCheckResult> DEFAULT_TRANSITION_ON_RESULT = any -> TransitionCheckResult.noTransition();
    private transient Predicate<Throwable> recordExceptionPredicate = DEFAULT_RECORD_EXCEPTION_PREDICATE;
    private transient Predicate<Throwable> ignoreExceptionPredicate = DEFAULT_IGNORE_EXCEPTION_PREDICATE;
    private transient Function<Clock, Long> currentTimestampFunction = DEFAULT_TIMESTAMP_FUNCTION;
    private TimeUnit timestampUnit = DEFAULT_TIMESTAMP_UNIT;
    private transient Predicate<Object> recordResultPredicate = DEFAULT_RECORD_RESULT_PREDICATE;
    private Class<? extends Throwable>[] recordExceptions = new Class[0];
    private Class<? extends Throwable>[] ignoreExceptions = new Class[0];
    private float failureRateThreshold = 50.0f;
    private int permittedNumberOfCallsInHalfOpenState = 10;
    private int slidingWindowSize = 100;
    private SlidingWindowType slidingWindowType = DEFAULT_SLIDING_WINDOW_TYPE;
    private int minimumNumberOfCalls = 100;
    private boolean writableStackTraceEnabled = true;
    private boolean automaticTransitionFromOpenToHalfOpenEnabled = false;
    private transient IntervalFunction waitIntervalFunctionInOpenState = IntervalFunction.of(Duration.ofSeconds(60L));
    private transient Function<Either<Object, Throwable>, TransitionCheckResult> transitionOnResult = DEFAULT_TRANSITION_ON_RESULT;
    private float slowCallRateThreshold = 100.0f;
    private Duration slowCallDurationThreshold = Duration.ofSeconds(60L);
    private Duration maxWaitDurationInHalfOpenState = Duration.ofSeconds(0L);

    private CircuitBreakerConfig() {
    }

    public static Builder custom() {
        return new Builder();
    }

    public static Builder from(CircuitBreakerConfig baseConfig) {
        return new Builder(baseConfig);
    }

    public static CircuitBreakerConfig ofDefaults() {
        return new Builder().build();
    }

    public float getFailureRateThreshold() {
        return this.failureRateThreshold;
    }

    public IntervalFunction getWaitIntervalFunctionInOpenState() {
        return this.waitIntervalFunctionInOpenState;
    }

    public Function<Either<Object, Throwable>, TransitionCheckResult> getTransitionOnResult() {
        return this.transitionOnResult;
    }

    public int getSlidingWindowSize() {
        return this.slidingWindowSize;
    }

    public Predicate<Throwable> getRecordExceptionPredicate() {
        return this.recordExceptionPredicate;
    }

    public Predicate<Object> getRecordResultPredicate() {
        return this.recordResultPredicate;
    }

    public Predicate<Throwable> getIgnoreExceptionPredicate() {
        return this.ignoreExceptionPredicate;
    }

    public Function<Clock, Long> getCurrentTimestampFunction() {
        return this.currentTimestampFunction;
    }

    public TimeUnit getTimestampUnit() {
        return this.timestampUnit;
    }

    public boolean isAutomaticTransitionFromOpenToHalfOpenEnabled() {
        return this.automaticTransitionFromOpenToHalfOpenEnabled;
    }

    public int getMinimumNumberOfCalls() {
        return this.minimumNumberOfCalls;
    }

    public boolean isWritableStackTraceEnabled() {
        return this.writableStackTraceEnabled;
    }

    public int getPermittedNumberOfCallsInHalfOpenState() {
        return this.permittedNumberOfCallsInHalfOpenState;
    }

    public SlidingWindowType getSlidingWindowType() {
        return this.slidingWindowType;
    }

    public float getSlowCallRateThreshold() {
        return this.slowCallRateThreshold;
    }

    public Duration getSlowCallDurationThreshold() {
        return this.slowCallDurationThreshold;
    }

    public Duration getMaxWaitDurationInHalfOpenState() {
        return this.maxWaitDurationInHalfOpenState;
    }

    public String toString() {
        StringBuilder circuitBreakerConfig = new StringBuilder("CircuitBreakerConfig {");
        circuitBreakerConfig.append("recordExceptionPredicate=");
        circuitBreakerConfig.append(this.recordExceptionPredicate);
        circuitBreakerConfig.append(", ignoreExceptionPredicate=");
        circuitBreakerConfig.append(this.ignoreExceptionPredicate);
        circuitBreakerConfig.append(", recordExceptions=");
        circuitBreakerConfig.append(Arrays.toString(this.recordExceptions));
        circuitBreakerConfig.append(", ignoreExceptions=");
        circuitBreakerConfig.append(Arrays.toString(this.ignoreExceptions));
        circuitBreakerConfig.append(", failureRateThreshold=");
        circuitBreakerConfig.append(this.failureRateThreshold);
        circuitBreakerConfig.append(", permittedNumberOfCallsInHalfOpenState=");
        circuitBreakerConfig.append(this.permittedNumberOfCallsInHalfOpenState);
        circuitBreakerConfig.append(", slidingWindowSize=");
        circuitBreakerConfig.append(this.slidingWindowSize);
        circuitBreakerConfig.append(", slidingWindowType=");
        circuitBreakerConfig.append((Object)this.slidingWindowType);
        circuitBreakerConfig.append(", minimumNumberOfCalls=");
        circuitBreakerConfig.append(this.minimumNumberOfCalls);
        circuitBreakerConfig.append(", writableStackTraceEnabled=");
        circuitBreakerConfig.append(this.writableStackTraceEnabled);
        circuitBreakerConfig.append(", automaticTransitionFromOpenToHalfOpenEnabled=");
        circuitBreakerConfig.append(this.automaticTransitionFromOpenToHalfOpenEnabled);
        circuitBreakerConfig.append(", waitIntervalFunctionInOpenState=");
        circuitBreakerConfig.append(this.waitIntervalFunctionInOpenState);
        circuitBreakerConfig.append(", slowCallRateThreshold=");
        circuitBreakerConfig.append(this.slowCallRateThreshold);
        circuitBreakerConfig.append(", slowCallDurationThreshold=");
        circuitBreakerConfig.append(this.slowCallDurationThreshold);
        circuitBreakerConfig.append("}");
        return circuitBreakerConfig.toString();
    }

    public static enum SlidingWindowType {
        TIME_BASED,
        COUNT_BASED;

    }

    public static class Builder {
        @Nullable
        private Predicate<Throwable> recordExceptionPredicate;
        @Nullable
        private Predicate<Throwable> ignoreExceptionPredicate;
        private Function<Clock, Long> currentTimestampFunction = DEFAULT_TIMESTAMP_FUNCTION;
        private TimeUnit timestampUnit = DEFAULT_TIMESTAMP_UNIT;
        private Class<? extends Throwable>[] recordExceptions = new Class[0];
        private Class<? extends Throwable>[] ignoreExceptions = new Class[0];
        private float failureRateThreshold = 50.0f;
        private int minimumNumberOfCalls = 100;
        private boolean writableStackTraceEnabled = true;
        private int permittedNumberOfCallsInHalfOpenState = 10;
        private int slidingWindowSize = 100;
        private Predicate<Object> recordResultPredicate = DEFAULT_RECORD_RESULT_PREDICATE;
        private IntervalFunction waitIntervalFunctionInOpenState = IntervalFunction.of(Duration.ofSeconds(60L));
        private Function<Either<Object, Throwable>, TransitionCheckResult> transitionOnResult = DEFAULT_TRANSITION_ON_RESULT;
        private boolean automaticTransitionFromOpenToHalfOpenEnabled = false;
        private SlidingWindowType slidingWindowType = DEFAULT_SLIDING_WINDOW_TYPE;
        private float slowCallRateThreshold = 100.0f;
        private Duration slowCallDurationThreshold = Duration.ofSeconds(60L);
        private Duration maxWaitDurationInHalfOpenState = Duration.ofSeconds(0L);
        private byte createWaitIntervalFunctionCounter = 0;

        public Builder(CircuitBreakerConfig baseConfig) {
            this.waitIntervalFunctionInOpenState = baseConfig.waitIntervalFunctionInOpenState;
            this.transitionOnResult = baseConfig.transitionOnResult;
            this.permittedNumberOfCallsInHalfOpenState = baseConfig.permittedNumberOfCallsInHalfOpenState;
            this.slidingWindowSize = baseConfig.slidingWindowSize;
            this.slidingWindowType = baseConfig.slidingWindowType;
            this.minimumNumberOfCalls = baseConfig.minimumNumberOfCalls;
            this.failureRateThreshold = baseConfig.failureRateThreshold;
            this.ignoreExceptions = baseConfig.ignoreExceptions;
            this.recordExceptions = baseConfig.recordExceptions;
            this.recordExceptionPredicate = baseConfig.recordExceptionPredicate;
            this.ignoreExceptionPredicate = baseConfig.ignoreExceptionPredicate;
            this.currentTimestampFunction = baseConfig.currentTimestampFunction;
            this.timestampUnit = baseConfig.timestampUnit;
            this.automaticTransitionFromOpenToHalfOpenEnabled = baseConfig.automaticTransitionFromOpenToHalfOpenEnabled;
            this.slowCallRateThreshold = baseConfig.slowCallRateThreshold;
            this.slowCallDurationThreshold = baseConfig.slowCallDurationThreshold;
            this.maxWaitDurationInHalfOpenState = baseConfig.maxWaitDurationInHalfOpenState;
            this.writableStackTraceEnabled = baseConfig.writableStackTraceEnabled;
            this.recordResultPredicate = baseConfig.recordResultPredicate;
        }

        public Builder() {
        }

        public Builder failureRateThreshold(float failureRateThreshold) {
            if (failureRateThreshold <= 0.0f || failureRateThreshold > 100.0f) {
                throw new IllegalArgumentException("failureRateThreshold must be between 1 and 100");
            }
            this.failureRateThreshold = failureRateThreshold;
            return this;
        }

        public Builder slowCallRateThreshold(float slowCallRateThreshold) {
            if (slowCallRateThreshold <= 0.0f || slowCallRateThreshold > 100.0f) {
                throw new IllegalArgumentException("slowCallRateThreshold must be between 1 and 100");
            }
            this.slowCallRateThreshold = slowCallRateThreshold;
            return this;
        }

        public Builder writableStackTraceEnabled(boolean writableStackTraceEnabled) {
            this.writableStackTraceEnabled = writableStackTraceEnabled;
            return this;
        }

        public Builder waitDurationInOpenState(Duration waitDurationInOpenState) {
            long waitDurationInMillis = waitDurationInOpenState.toMillis();
            if (waitDurationInMillis < 1L) {
                throw new IllegalArgumentException("waitDurationInOpenState must be at least 1[ms]");
            }
            this.waitIntervalFunctionInOpenState = IntervalFunction.of(waitDurationInMillis);
            this.createWaitIntervalFunctionCounter = (byte)(this.createWaitIntervalFunctionCounter + 1);
            return this;
        }

        public Builder waitIntervalFunctionInOpenState(IntervalFunction waitIntervalFunctionInOpenState) {
            this.waitIntervalFunctionInOpenState = waitIntervalFunctionInOpenState;
            this.createWaitIntervalFunctionCounter = (byte)(this.createWaitIntervalFunctionCounter + 1);
            return this;
        }

        public Builder transitionOnResult(Function<Either<Object, Throwable>, TransitionCheckResult> transitionOnResult) {
            this.transitionOnResult = transitionOnResult;
            return this;
        }

        public Builder slowCallDurationThreshold(Duration slowCallDurationThreshold) {
            if (slowCallDurationThreshold.toNanos() < 1L) {
                throw new IllegalArgumentException("slowCallDurationThreshold must be at least 1[ns]");
            }
            this.slowCallDurationThreshold = slowCallDurationThreshold;
            return this;
        }

        public Builder maxWaitDurationInHalfOpenState(Duration maxWaitDurationInHalfOpenState) {
            if (maxWaitDurationInHalfOpenState.toMillis() < 0L) {
                throw new IllegalArgumentException("maxWaitDurationInHalfOpenState must be greater than or equal to 0[ms]");
            }
            this.maxWaitDurationInHalfOpenState = maxWaitDurationInHalfOpenState;
            return this;
        }

        public Builder permittedNumberOfCallsInHalfOpenState(int permittedNumberOfCallsInHalfOpenState) {
            if (permittedNumberOfCallsInHalfOpenState < 1) {
                throw new IllegalArgumentException("permittedNumberOfCallsInHalfOpenState must be greater than 0");
            }
            this.permittedNumberOfCallsInHalfOpenState = permittedNumberOfCallsInHalfOpenState;
            return this;
        }

        public Builder slidingWindow(int slidingWindowSize, int minimumNumberOfCalls, SlidingWindowType slidingWindowType) {
            if (slidingWindowSize < 1) {
                throw new IllegalArgumentException("slidingWindowSize must be greater than 0");
            }
            if (minimumNumberOfCalls < 1) {
                throw new IllegalArgumentException("minimumNumberOfCalls must be greater than 0");
            }
            this.minimumNumberOfCalls = slidingWindowType == SlidingWindowType.COUNT_BASED ? Math.min(minimumNumberOfCalls, slidingWindowSize) : minimumNumberOfCalls;
            this.slidingWindowSize = slidingWindowSize;
            this.slidingWindowType = slidingWindowType;
            return this;
        }

        public Builder slidingWindowSize(int slidingWindowSize) {
            if (slidingWindowSize < 1) {
                throw new IllegalArgumentException("slidingWindowSize must be greater than 0");
            }
            this.slidingWindowSize = slidingWindowSize;
            return this;
        }

        public Builder minimumNumberOfCalls(int minimumNumberOfCalls) {
            if (minimumNumberOfCalls < 1) {
                throw new IllegalArgumentException("minimumNumberOfCalls must be greater than 0");
            }
            this.minimumNumberOfCalls = minimumNumberOfCalls;
            return this;
        }

        public Builder slidingWindowType(SlidingWindowType slidingWindowType) {
            this.slidingWindowType = slidingWindowType;
            return this;
        }

        public Builder recordException(Predicate<Throwable> predicate) {
            this.recordExceptionPredicate = predicate;
            return this;
        }

        public Builder currentTimestampFunction(Function<Clock, Long> currentTimestampFunction, TimeUnit timeUnit) {
            this.timestampUnit = timeUnit;
            this.currentTimestampFunction = currentTimestampFunction;
            return this;
        }

        public Builder recordResult(Predicate<Object> predicate) {
            this.recordResultPredicate = predicate;
            return this;
        }

        public Builder ignoreException(Predicate<Throwable> predicate) {
            this.ignoreExceptionPredicate = predicate;
            return this;
        }

        @SafeVarargs
        public final Builder recordExceptions(Class<? extends Throwable> ... errorClasses) {
            this.recordExceptions = errorClasses != null ? errorClasses : new Class[]{};
            return this;
        }

        @SafeVarargs
        public final Builder ignoreExceptions(Class<? extends Throwable> ... errorClasses) {
            this.ignoreExceptions = errorClasses != null ? errorClasses : new Class[]{};
            return this;
        }

        public Builder enableAutomaticTransitionFromOpenToHalfOpen() {
            this.automaticTransitionFromOpenToHalfOpenEnabled = true;
            return this;
        }

        public Builder automaticTransitionFromOpenToHalfOpenEnabled(boolean enableAutomaticTransitionFromOpenToHalfOpen) {
            this.automaticTransitionFromOpenToHalfOpenEnabled = enableAutomaticTransitionFromOpenToHalfOpen;
            return this;
        }

        public CircuitBreakerConfig build() {
            CircuitBreakerConfig config = new CircuitBreakerConfig();
            config.waitIntervalFunctionInOpenState = this.validateWaitIntervalFunctionInOpenState();
            config.transitionOnResult = this.transitionOnResult;
            config.slidingWindowType = this.slidingWindowType;
            config.slowCallDurationThreshold = this.slowCallDurationThreshold;
            config.maxWaitDurationInHalfOpenState = this.maxWaitDurationInHalfOpenState;
            config.slowCallRateThreshold = this.slowCallRateThreshold;
            config.failureRateThreshold = this.failureRateThreshold;
            config.slidingWindowSize = this.slidingWindowSize;
            config.minimumNumberOfCalls = this.minimumNumberOfCalls;
            config.permittedNumberOfCallsInHalfOpenState = this.permittedNumberOfCallsInHalfOpenState;
            config.recordExceptions = this.recordExceptions;
            config.ignoreExceptions = this.ignoreExceptions;
            config.automaticTransitionFromOpenToHalfOpenEnabled = this.automaticTransitionFromOpenToHalfOpenEnabled;
            config.writableStackTraceEnabled = this.writableStackTraceEnabled;
            config.recordExceptionPredicate = this.createRecordExceptionPredicate();
            config.ignoreExceptionPredicate = this.createIgnoreFailurePredicate();
            config.currentTimestampFunction = this.currentTimestampFunction;
            config.timestampUnit = this.timestampUnit;
            config.recordResultPredicate = this.recordResultPredicate;
            return config;
        }

        private Predicate<Throwable> createIgnoreFailurePredicate() {
            return PredicateCreator.createExceptionsPredicate(this.ignoreExceptionPredicate, this.ignoreExceptions).orElse(DEFAULT_IGNORE_EXCEPTION_PREDICATE);
        }

        private Predicate<Throwable> createRecordExceptionPredicate() {
            return PredicateCreator.createExceptionsPredicate(this.recordExceptionPredicate, this.recordExceptions).orElse(DEFAULT_RECORD_EXCEPTION_PREDICATE);
        }

        private IntervalFunction validateWaitIntervalFunctionInOpenState() {
            if (this.createWaitIntervalFunctionCounter > 1) {
                throw new IllegalStateException("The waitIntervalFunction was configured multiple times which could result in an undesired state. Please verify that waitIntervalFunctionInOpenState and waitDurationInOpenState are not used together.");
            }
            return this.waitIntervalFunctionInOpenState;
        }
    }

    public static class TransitionCheckResult {
        private final boolean transitionToOpen;
        @Nullable
        private final Duration waitDuration;
        @Nullable
        private final Instant waitUntil;

        private TransitionCheckResult(boolean transitionToOpen, @Nullable Duration waitDuration, @Nullable Instant waitUntil) {
            this.transitionToOpen = transitionToOpen;
            this.waitDuration = waitDuration;
            this.waitUntil = waitUntil;
        }

        public static TransitionCheckResult noTransition() {
            return new TransitionCheckResult(false, null, null);
        }

        public static TransitionCheckResult transitionToOpen() {
            return new TransitionCheckResult(true, null, null);
        }

        public static TransitionCheckResult transitionToOpenAndWaitFor(Duration waitDuration) {
            return new TransitionCheckResult(true, waitDuration, null);
        }

        public static TransitionCheckResult transitionToOpenAndWaitUntil(Instant waitUntil) {
            return new TransitionCheckResult(true, null, waitUntil);
        }

        public boolean isTransitionToOpen() {
            return this.transitionToOpen;
        }

        @Nullable
        public Duration getWaitDuration() {
            return this.waitDuration;
        }

        @Nullable
        public Instant getWaitUntil() {
            return this.waitUntil;
        }
    }
}

