/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.camel.Component;
import org.apache.camel.catalog.RuntimeCamelCatalog;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.CatalogVerifierCustomizer;
import org.apache.camel.component.extension.verifier.DefaultComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.ResultBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorBuilder;
import org.apache.camel.spi.RestConsumerFactory;
import org.apache.camel.spi.RestProducerFactory;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.tooling.model.ComponentModel;
import org.apache.camel.tooling.model.JsonMapper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.function.Suppliers;

public class RestComponentVerifierExtension
extends DefaultComponentVerifierExtension {
    private static final CatalogVerifierCustomizer CUSTOMIZER = new CatalogVerifierCustomizer().excludeUnknown();

    RestComponentVerifierExtension() {
        super("rest");
    }

    @Override
    protected ComponentVerifierExtension.Result verifyParameters(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope(ComponentVerifierExtension.Result.Status.OK, ComponentVerifierExtension.Scope.PARAMETERS);
        super.verifyParametersAgainstCatalog(builder, parameters, CUSTOMIZER);
        this.verifyUnderlyingComponent(ComponentVerifierExtension.Scope.PARAMETERS, builder, parameters);
        return builder.build();
    }

    @Override
    protected ComponentVerifierExtension.Result verifyConnectivity(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope(ComponentVerifierExtension.Result.Status.OK, ComponentVerifierExtension.Scope.CONNECTIVITY);
        this.verifyUnderlyingComponent(ComponentVerifierExtension.Scope.CONNECTIVITY, builder, parameters);
        return builder.build();
    }

    protected void verifyUnderlyingComponent(ComponentVerifierExtension.Scope scope, ResultBuilder builder, Map<String, Object> map) {
        block7: {
            String componentName = (String)map.get("producerComponentName");
            if (ObjectHelper.isNotEmpty(componentName)) {
                HashMap<String, Object> parameters = new HashMap<String, Object>(map);
                try {
                    Component component = this.getTransportComponent(componentName);
                    Optional<ComponentVerifierExtension> extension = component.getExtension(ComponentVerifierExtension.class);
                    if (extension.isPresent()) {
                        ComponentVerifierExtension verifier = extension.get();
                        RuntimeCamelCatalog catalog = PluginHelper.getRuntimeCamelCatalog(this.getCamelContext());
                        String json = catalog.componentJSonSchema("rest");
                        ComponentModel model = JsonMapper.generateComponentModel(json);
                        model.getEndpointPathOptions().stream().filter(o -> o.getKind().equals("path")).forEach(o -> parameters.remove(o.getName()));
                        HashMap<String, Object> restParameters = new HashMap<String, Object>(parameters);
                        Stream.concat(model.getComponentOptions().stream(), model.getOptions().stream()).forEach(o -> {
                            String name = o.getName();
                            Object val = restParameters.remove(name);
                            if (val != null) {
                                restParameters.put("rest." + name, parameters.get(name));
                            }
                        });
                        if (scope == ComponentVerifierExtension.Scope.CONNECTIVITY) {
                            model.getEndpointPathOptions().forEach(o -> {
                                String name = o.getName();
                                Object val = map.get(name);
                                if (val != null) {
                                    restParameters.put("rest." + name, val);
                                }
                            });
                        }
                        ComponentVerifierExtension.Result result = verifier.verify(scope, restParameters);
                        for (ComponentVerifierExtension.VerificationError error : result.getErrors()) {
                            builder.error(ResultErrorBuilder.fromError(error).detail("component", (Object)componentName).build());
                        }
                        break block7;
                    }
                    builder.error(ResultErrorBuilder.withUnsupportedComponent(componentName).build());
                }
                catch (Exception e) {
                    builder.error(ResultErrorBuilder.withException(e).build());
                }
            } else {
                builder.error(ResultErrorBuilder.withMissingOption("componentName").build());
            }
        }
    }

    private Component getTransportComponent(String componentName) throws Exception {
        return Suppliers.firstMatching(comp -> comp instanceof RestConsumerFactory || comp instanceof RestProducerFactory, () -> this.getCamelContext().getRegistry().lookupByNameAndType(componentName, Component.class), () -> this.getCamelContext().getComponent(componentName, true, false)).orElse(null);
    }
}

