/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest.openapi;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.io.Closeable;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProducer;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.NonManagedService;
import org.apache.camel.Route;
import org.apache.camel.component.platform.http.PlatformHttpComponent;
import org.apache.camel.component.platform.http.spi.PlatformHttpConsumerAware;
import org.apache.camel.component.rest.openapi.RestOpenApiHelper;
import org.apache.camel.component.rest.openapi.RestOpenapiProcessorStrategy;
import org.apache.camel.spi.PackageScanResourceResolver;
import org.apache.camel.spi.ProducerCache;
import org.apache.camel.spi.Resource;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.cache.DefaultProducerCache;
import org.apache.camel.support.processor.RestBindingAdvice;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRestOpenapiProcessorStrategy
extends ServiceSupport
implements RestOpenapiProcessorStrategy,
CamelContextAware,
NonManagedService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRestOpenapiProcessorStrategy.class);
    private static final String BODY_VERBS = "DELETE,PUT,POST,PATCH";
    private static final String GEN_OPID = "GENOPID_";
    private CamelContext camelContext;
    private ProducerCache producerCache;
    private String component = "direct";
    private String missingOperation;
    private String mockIncludePattern;
    private final List<String> uris = new ArrayList<String>();

    @Override
    public void validateOpenApi(OpenAPI openAPI, PlatformHttpConsumerAware platformHttpConsumer) throws Exception {
        PlatformHttpComponent platformHttpComponent;
        ArrayList<CallSite> ids = new ArrayList<CallSite>();
        for (Map.Entry entry : openAPI.getPaths().entrySet()) {
            for (Map.Entry<PathItem.HttpMethod, Operation> o : ((PathItem)entry.getValue()).readOperationsMap().entrySet()) {
                Operation op = o.getValue();
                String id2 = op.getOperationId() != null ? op.getOperationId() : this.generateOperationId((String)entry.getKey(), o.getKey());
                ids.add((CallSite)((Object)(this.component + "://" + id2)));
            }
        }
        ArrayList<String> existing = new ArrayList<String>();
        for (Route route : this.camelContext.getRoutes()) {
            String base = route.getEndpoint().getEndpointBaseUri();
            existing.add(base);
        }
        ids.removeAll(existing);
        if (!ids.isEmpty()) {
            String string = ids.stream().sorted().map(id -> id.replace("://", ":")).collect(Collectors.joining("\n\t"));
            String msg = String.format("OpenAPI specification has %d unmapped operations to corresponding routes: %n\t%s", ids.size(), string);
            if ("fail".equalsIgnoreCase(this.missingOperation)) {
                throw new IllegalArgumentException(msg);
            }
            if ("ignore".equalsIgnoreCase(this.missingOperation)) {
                LOG.warn(msg + "\nThis validation error is ignored.");
            } else if ("mock".equalsIgnoreCase(this.missingOperation)) {
                LOG.debug(msg + "\nThis validation error is ignored (Will return a mocked/empty response).");
            }
        }
        if ((platformHttpComponent = this.camelContext.getComponent("platform-http", PlatformHttpComponent.class)) != null) {
            String path = RestOpenApiHelper.getBasePathFromOpenApi(openAPI);
            if (path == null || path.isEmpty() || path.equals("/")) {
                path = "";
            }
            for (Map.Entry p : openAPI.getPaths().entrySet()) {
                String uri = path + (String)p.getKey();
                String verbs = ((PathItem)p.getValue()).readOperationsMap().keySet().stream().map(Enum::name).sorted().collect(Collectors.joining(","));
                String consumes = null;
                String produces = null;
                for (Operation o : ((PathItem)p.getValue()).readOperations()) {
                    Content c;
                    if (o.getRequestBody() != null && (c = o.getRequestBody().getContent()) != null) {
                        consumes = c.keySet().stream().sorted().collect(Collectors.joining(","));
                    }
                    if (o.getResponses() == null) continue;
                    for (ApiResponse a : o.getResponses().values()) {
                        Content c2 = a.getContent();
                        if (c2 == null) continue;
                        produces = c2.keySet().stream().sorted().collect(Collectors.joining(","));
                    }
                }
                platformHttpComponent.addHttpEndpoint(uri, verbs, consumes, produces, platformHttpConsumer.getPlatformHttpConsumer());
                this.uris.add(uri);
            }
        }
    }

    private String generateOperationId(String path, PathItem.HttpMethod httpMethod) {
        String sanitizedPath = path.replace('/', '.').replaceAll("[{}]", "_");
        String opId = GEN_OPID + httpMethod.name() + sanitizedPath;
        LOG.debug("Generated operationId {} for path {} and method {}", new Object[]{opId, path, httpMethod.name()});
        return opId;
    }

    @Override
    public boolean processApiSpecification(String specificationUri, Exchange exchange, AsyncCallback callback) {
        try {
            Resource res = PluginHelper.getResourceLoader(this.camelContext).resolveResource(specificationUri);
            if (res != null && res.exists()) {
                if (specificationUri.endsWith("json")) {
                    exchange.getMessage().setHeader("Content-Type", "application/json");
                } else if (specificationUri.endsWith("yaml") || specificationUri.endsWith("yml")) {
                    exchange.getMessage().setHeader("Content-Type", "text/yaml");
                }
                InputStream is = res.getInputStream();
                String data = IOHelper.loadText(is);
                exchange.getMessage().setBody(data);
                IOHelper.close((Closeable)is);
            }
        }
        catch (Exception e) {
            exchange.setException(e);
        }
        callback.done(true);
        return true;
    }

    @Override
    public boolean process(OpenAPI openAPI, Operation operation, String verb, String path, RestBindingAdvice binding, Exchange exchange, AsyncCallback callback) {
        Object state;
        Endpoint e;
        if (("mock".equalsIgnoreCase(this.missingOperation) || "ignore".equalsIgnoreCase(this.missingOperation)) && (e = this.camelContext.hasEndpoint(this.component + ":" + operation.getOperationId())) == null) {
            if ("mock".equalsIgnoreCase(this.missingOperation)) {
                this.loadMockData(operation, verb, path, exchange);
            }
            callback.done(true);
            return true;
        }
        try {
            exchange.setProperty("CamelRestOpenAPI", (Object)openAPI);
            state = binding.before(exchange);
        }
        catch (Exception e2) {
            exchange.setException(e2);
            callback.done(true);
            return true;
        }
        Endpoint e3 = this.camelContext.getEndpoint(this.component + ":" + operation.getOperationId());
        AsyncProducer p = this.producerCache.acquireProducer(e3);
        return p.process(exchange, arg_0 -> this.lambda$process$1(e3, p, binding, exchange, (Map)state, callback, arg_0));
    }

    private void loadMockData(Operation operation, String verb, String path, Exchange exchange) {
        PackageScanResourceResolver resolver = PluginHelper.getPackageScanResourceResolver(this.camelContext);
        String[] includes = this.mockIncludePattern != null ? this.mockIncludePattern.split(",") : null;
        boolean json = false;
        boolean xml = false;
        Resource found = null;
        if (includes != null) {
            ArrayList<Resource> accepted = new ArrayList<Resource>();
            for (String include : includes) {
                try {
                    accepted.addAll(resolver.findResources(include));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String ct = ExchangeHelper.getContentType(exchange);
            if (ct != null) {
                json = ct.contains("json");
                xml = ct.contains("xml");
            }
            for (Resource resource : accepted) {
                boolean matchExt;
                String target = FileUtil.stripFirstLeadingSeparator(path);
                String loc = FileUtil.stripExt(FileUtil.compactPath(resource.getLocation(), '/'));
                String[] onlyExt = FileUtil.onlyExt(resource.getLocation());
                boolean match = loc.endsWith(target);
                boolean bl = matchExt = !json && !xml || json && onlyExt.equals("json") || xml && onlyExt.equals("xml");
                if (!match || !matchExt) continue;
                found = resource;
                json = onlyExt.equals("json");
                xml = onlyExt.equals("xml");
                break;
            }
        }
        if (found != null) {
            try {
                if (json) {
                    exchange.getMessage().setHeader("Content-Type", "application/json");
                } else if (xml) {
                    exchange.getMessage().setHeader("Content-Type", "text/xml");
                }
                exchange.getMessage().setHeader("CamelHttpResponseCode", 200);
                exchange.getMessage().setBody(IOHelper.loadText(found.getInputStream()));
            }
            catch (Exception accepted) {}
        } else if (BODY_VERBS.contains(verb)) {
            exchange.getMessage().setHeader("CamelHttpResponseCode", 200);
        } else {
            boolean empty;
            ApiResponse a;
            Content c;
            Object body = "";
            String contentType = ExchangeHelper.getContentType(exchange);
            String accept = exchange.getMessage().getHeader("Accept", String.class);
            if (operation.getResponses() != null && (c = (a = (ApiResponse)operation.getResponses().get("200")).getContent()) != null && !c.isEmpty()) {
                MediaType mt;
                MediaType mediaType = mt = contentType != null ? (MediaType)c.get(contentType) : null;
                if (mt == null && accept != null) {
                    for (String acc : accept.split(",")) {
                        acc = StringHelper.before(acc, ";", acc);
                        mt = (MediaType)c.get(acc = acc.trim());
                        if (mt == null) continue;
                        contentType = acc;
                        break;
                    }
                    if (mt == null && "*/*".equals(accept) && (mt = (MediaType)c.get("application/json")) != null) {
                        contentType = "application/json";
                    }
                    if (mt == null && "*/*".equals(accept) && (mt = (MediaType)c.get("application/xml")) != null) {
                        contentType = "application/xml";
                    }
                }
                if (mt != null) {
                    if (mt.getExample() != null) {
                        body = mt.getExample();
                    } else if (mt.getExamples() != null) {
                        Example ex = mt.getExamples().values().iterator().next();
                        body = ex.getValue();
                    }
                }
            }
            boolean bl = empty = body == null || body.toString().isBlank();
            if (empty) {
                exchange.getMessage().setHeader("CamelHttpResponseCode", 204);
                exchange.getMessage().setBody("");
            } else {
                exchange.getMessage().setHeader("CamelHttpResponseCode", 200);
                exchange.getMessage().setHeader("Content-Type", contentType);
                exchange.getMessage().setBody(body);
            }
        }
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    @Override
    public String getMissingOperation() {
        return this.missingOperation;
    }

    @Override
    public void setMissingOperation(String missingOperation) {
        this.missingOperation = missingOperation;
    }

    @Override
    public String getMockIncludePattern() {
        return this.mockIncludePattern;
    }

    @Override
    public void setMockIncludePattern(String mockIncludePattern) {
        this.mockIncludePattern = mockIncludePattern;
    }

    @Override
    protected void doInit() throws Exception {
        this.producerCache = new DefaultProducerCache(this, this.getCamelContext(), 1000);
        ServiceHelper.initService((Object)this.producerCache);
        if (this.missingOperation == null) {
            boolean dev = "dev".equalsIgnoreCase(this.camelContext.getCamelContextExtension().getProfile());
            this.missingOperation = dev ? "mock" : "fail";
        }
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startService(this.producerCache);
    }

    @Override
    protected void doStop() throws Exception {
        PlatformHttpComponent phc;
        ServiceHelper.stopService(this.producerCache);
        if (this.camelContext != null && (phc = (PlatformHttpComponent)this.camelContext.hasComponent("platform-http")) != null) {
            this.uris.forEach(phc::removeHttpEndpoint);
            this.uris.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$process$1(Endpoint e, AsyncProducer p, RestBindingAdvice binding, Exchange exchange, Map state, AsyncCallback callback, boolean doneSync) {
        try {
            this.producerCache.releaseProducer(e, p);
            binding.after(exchange, state);
        }
        catch (Exception ex) {
            exchange.setException(ex);
        }
        finally {
            callback.done(doneSync);
        }
    }
}

