/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.prometheus;

import io.opentelemetry.api.internal.StringUtils;
import io.opentelemetry.exporter.prometheus.NameSanitizer;
import java.util.regex.Pattern;

final class PrometheusUnitsHelper {
    private static final Pattern INVALID_CHARACTERS_PATTERN = Pattern.compile("[^a-zA-Z0-9]");
    private static final Pattern CHARACTERS_BETWEEN_BRACES_PATTERN = Pattern.compile("\\{(.*?)}");
    private static final Pattern SANITIZE_LEADING_UNDERSCORES = Pattern.compile("^_+");
    private static final Pattern SANITIZE_TRAILING_UNDERSCORES = Pattern.compile("_+$");

    private PrometheusUnitsHelper() {
    }

    static String getEquivalentPrometheusUnit(String rawMetricUnitName) {
        if (StringUtils.isNullOrEmpty(rawMetricUnitName)) {
            return rawMetricUnitName;
        }
        String convertedMetricUnitName = PrometheusUnitsHelper.removeUnitPortionInBraces(rawMetricUnitName);
        convertedMetricUnitName = PrometheusUnitsHelper.convertRateExpressedToPrometheusUnit(convertedMetricUnitName);
        return PrometheusUnitsHelper.cleanUpString(PrometheusUnitsHelper.getPrometheusUnit(convertedMetricUnitName));
    }

    private static String convertRateExpressedToPrometheusUnit(String rateExpressedUnit) {
        if (!rateExpressedUnit.contains("/")) {
            return rateExpressedUnit;
        }
        String[] rateEntities = rateExpressedUnit.split("/", 2);
        if (rateEntities[1].equals("")) {
            return rateExpressedUnit;
        }
        return PrometheusUnitsHelper.getPrometheusUnit(rateEntities[0]) + "_per_" + PrometheusUnitsHelper.getPrometheusPerUnit(rateEntities[1]);
    }

    private static String removeUnitPortionInBraces(String unit) {
        return CHARACTERS_BETWEEN_BRACES_PATTERN.matcher(unit).replaceAll("");
    }

    private static String cleanUpString(String string) {
        return SANITIZE_LEADING_UNDERSCORES.matcher(SANITIZE_TRAILING_UNDERSCORES.matcher(NameSanitizer.SANITIZE_CONSECUTIVE_UNDERSCORES.matcher(INVALID_CHARACTERS_PATTERN.matcher(string).replaceAll("_")).replaceAll("_")).replaceAll("")).replaceAll("");
    }

    private static String getPrometheusUnit(String unitAbbreviation) {
        switch (unitAbbreviation) {
            case "d": {
                return "days";
            }
            case "h": {
                return "hours";
            }
            case "min": {
                return "minutes";
            }
            case "s": {
                return "seconds";
            }
            case "ms": {
                return "milliseconds";
            }
            case "us": {
                return "microseconds";
            }
            case "ns": {
                return "nanoseconds";
            }
            case "By": {
                return "bytes";
            }
            case "KiBy": {
                return "kibibytes";
            }
            case "MiBy": {
                return "mebibytes";
            }
            case "GiBy": {
                return "gibibytes";
            }
            case "TiBy": {
                return "tibibytes";
            }
            case "KBy": {
                return "kilobytes";
            }
            case "MBy": {
                return "megabytes";
            }
            case "GBy": {
                return "gigabytes";
            }
            case "TBy": {
                return "terabytes";
            }
            case "B": {
                return "bytes";
            }
            case "KB": {
                return "kilobytes";
            }
            case "MB": {
                return "megabytes";
            }
            case "GB": {
                return "gigabytes";
            }
            case "TB": {
                return "terabytes";
            }
            case "m": {
                return "meters";
            }
            case "V": {
                return "volts";
            }
            case "A": {
                return "amperes";
            }
            case "J": {
                return "joules";
            }
            case "W": {
                return "watts";
            }
            case "g": {
                return "grams";
            }
            case "Cel": {
                return "celsius";
            }
            case "Hz": {
                return "hertz";
            }
            case "1": {
                return "";
            }
            case "%": {
                return "percent";
            }
            case "$": {
                return "dollars";
            }
        }
        return unitAbbreviation;
    }

    private static String getPrometheusPerUnit(String perUnitAbbreviation) {
        switch (perUnitAbbreviation) {
            case "s": {
                return "second";
            }
            case "m": {
                return "minute";
            }
            case "h": {
                return "hour";
            }
            case "d": {
                return "day";
            }
            case "w": {
                return "week";
            }
            case "mo": {
                return "month";
            }
            case "y": {
                return "year";
            }
        }
        return perUnitAbbreviation;
    }
}

