/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.prometheus.internal;

import io.opentelemetry.exporter.prometheus.PrometheusHttpServer;
import io.opentelemetry.exporter.prometheus.PrometheusHttpServerBuilder;
import io.opentelemetry.sdk.autoconfigure.spi.AutoConfigurationCustomizer;
import io.opentelemetry.sdk.autoconfigure.spi.AutoConfigurationCustomizerProvider;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;

public class PrometheusCustomizerProvider
implements AutoConfigurationCustomizerProvider {
    @Override
    public void customize(AutoConfigurationCustomizer autoConfiguration) {
        autoConfiguration.addMeterProviderCustomizer((builder, config) -> {
            boolean prometheusEnabled = config.getList("otel.metrics.exporter").contains("prometheus");
            if (prometheusEnabled) {
                builder.registerMetricReader(PrometheusCustomizerProvider.configurePrometheusHttpServer(config));
            }
            return builder;
        });
    }

    static PrometheusHttpServer configurePrometheusHttpServer(ConfigProperties config) {
        String host;
        PrometheusHttpServerBuilder prometheusBuilder = PrometheusHttpServer.builder();
        Integer port = config.getInt("otel.exporter.prometheus.port");
        if (port != null) {
            prometheusBuilder.setPort(port);
        }
        if ((host = config.getString("otel.exporter.prometheus.host")) != null) {
            prometheusBuilder.setHost(host);
        }
        return prometheusBuilder.build();
    }
}

