/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.protocol.body;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.rocketmq.remoting.protocol.RemotingSerializable;
import org.apache.rocketmq.remoting.protocol.route.BrokerData;

public class ClusterInfo
extends RemotingSerializable {
    private Map<String, BrokerData> brokerAddrTable;
    private Map<String, Set<String>> clusterAddrTable;

    public Map<String, BrokerData> getBrokerAddrTable() {
        return this.brokerAddrTable;
    }

    public void setBrokerAddrTable(Map<String, BrokerData> brokerAddrTable) {
        this.brokerAddrTable = brokerAddrTable;
    }

    public Map<String, Set<String>> getClusterAddrTable() {
        return this.clusterAddrTable;
    }

    public void setClusterAddrTable(Map<String, Set<String>> clusterAddrTable) {
        this.clusterAddrTable = clusterAddrTable;
    }

    public String[] retrieveAllAddrByCluster(String cluster) {
        ArrayList<String> addrs = new ArrayList<String>();
        if (this.clusterAddrTable.containsKey(cluster)) {
            Set<String> brokerNames = this.clusterAddrTable.get(cluster);
            for (String brokerName : brokerNames) {
                BrokerData brokerData = this.brokerAddrTable.get(brokerName);
                if (null == brokerData) continue;
                addrs.addAll(brokerData.getBrokerAddrs().values());
            }
        }
        return addrs.toArray(new String[0]);
    }

    public String[] retrieveAllClusterNames() {
        return this.clusterAddrTable.keySet().toArray(new String[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterInfo info = (ClusterInfo)o;
        return Objects.equal(this.brokerAddrTable, info.brokerAddrTable) && Objects.equal(this.clusterAddrTable, info.clusterAddrTable);
    }

    public int hashCode() {
        return Objects.hashCode(this.brokerAddrTable, this.clusterAddrTable);
    }
}

