/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.logging.otlp;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.io.SegmentedStringWriter;
import io.opentelemetry.exporter.internal.otlp.logs.ResourceLogsMarshaler;
import io.opentelemetry.exporter.logging.otlp.JsonUtil;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.logs.data.LogRecordData;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class OtlpJsonLoggingLogRecordExporter
implements LogRecordExporter {
    private static final Logger logger = Logger.getLogger(OtlpJsonLoggingLogRecordExporter.class.getName());
    private final AtomicBoolean isShutdown = new AtomicBoolean();

    public static LogRecordExporter create() {
        return new OtlpJsonLoggingLogRecordExporter();
    }

    private OtlpJsonLoggingLogRecordExporter() {
    }

    @Override
    public CompletableResultCode export(Collection<LogRecordData> logs) {
        ResourceLogsMarshaler[] allResourceLogs;
        if (this.isShutdown.get()) {
            return CompletableResultCode.ofFailure();
        }
        for (ResourceLogsMarshaler resourceLogs : allResourceLogs = ResourceLogsMarshaler.create(logs)) {
            SegmentedStringWriter sw = new SegmentedStringWriter(JsonUtil.JSON_FACTORY._getBufferRecycler());
            try (JsonGenerator gen = JsonUtil.create(sw);){
                resourceLogs.writeJsonTo(gen);
            }
            catch (IOException e) {
                continue;
            }
            try {
                logger.log(Level.INFO, sw.getAndClear());
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Unable to read OTLP JSON log records", e);
            }
        }
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        if (!this.isShutdown.compareAndSet(false, true)) {
            logger.log(Level.INFO, "Calling shutdown() multiple times.");
        }
        return CompletableResultCode.ofSuccess();
    }
}

