/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.logging.otlp;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.io.SegmentedStringWriter;
import io.opentelemetry.exporter.internal.otlp.metrics.ResourceMetricsMarshaler;
import io.opentelemetry.exporter.logging.otlp.JsonUtil;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class OtlpJsonLoggingMetricExporter
implements MetricExporter {
    private static final Logger logger = Logger.getLogger(OtlpJsonLoggingMetricExporter.class.getName());
    private final AtomicBoolean isShutdown = new AtomicBoolean();
    private final AggregationTemporality aggregationTemporality;

    public static MetricExporter create() {
        return new OtlpJsonLoggingMetricExporter(AggregationTemporality.CUMULATIVE);
    }

    public static MetricExporter create(AggregationTemporality aggregationTemporality) {
        return new OtlpJsonLoggingMetricExporter(aggregationTemporality);
    }

    private OtlpJsonLoggingMetricExporter(AggregationTemporality aggregationTemporality) {
        this.aggregationTemporality = aggregationTemporality;
    }

    @Deprecated
    public AggregationTemporality getPreferredTemporality() {
        return this.aggregationTemporality;
    }

    @Override
    public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
        return this.aggregationTemporality;
    }

    @Override
    public CompletableResultCode export(Collection<MetricData> metrics) {
        ResourceMetricsMarshaler[] allResourceMetrics;
        if (this.isShutdown.get()) {
            return CompletableResultCode.ofFailure();
        }
        for (ResourceMetricsMarshaler resourceMetrics : allResourceMetrics = ResourceMetricsMarshaler.create(metrics)) {
            SegmentedStringWriter sw = new SegmentedStringWriter(JsonUtil.JSON_FACTORY._getBufferRecycler());
            try (JsonGenerator gen = JsonUtil.create(sw);){
                resourceMetrics.writeJsonTo(gen);
            }
            catch (IOException e) {
                continue;
            }
            try {
                logger.log(Level.INFO, sw.getAndClear());
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Unable to read OTLP JSON metrics", e);
            }
        }
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        if (!this.isShutdown.compareAndSet(false, true)) {
            logger.log(Level.INFO, "Calling shutdown() multiple times.");
        }
        return CompletableResultCode.ofSuccess();
    }
}

