/*
 * Decompiled with CFR 0.152.
 */
package jakarta.activation;

import jakarta.activation.ServiceLoaderUtil;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

class FactoryFinder {
    private static final Logger logger = Logger.getLogger("jakarta.activation");
    private static final ServiceLoaderUtil.ExceptionHandler<RuntimeException> EXCEPTION_HANDLER = new ServiceLoaderUtil.ExceptionHandler<RuntimeException>(){

        @Override
        public RuntimeException createException(Throwable throwable, String message) {
            return new IllegalStateException(message, throwable);
        }
    };

    FactoryFinder() {
    }

    static <T> T find(Class<T> factoryClass) throws RuntimeException {
        for (ClassLoader l : FactoryFinder.getClassLoaders(Thread.class, FactoryFinder.class, System.class)) {
            T f = FactoryFinder.find(factoryClass, l);
            if (f == null) continue;
            return f;
        }
        throw EXCEPTION_HANDLER.createException(null, "Provider for " + factoryClass.getName() + " cannot be found");
    }

    static <T> T find(Class<T> factoryClass, ClassLoader loader) throws RuntimeException {
        T result;
        String className = FactoryFinder.fromSystemProperty(factoryClass.getName());
        if (className != null && (result = FactoryFinder.newInstance(className, factoryClass, loader)) != null) {
            return result;
        }
        T factory2 = ServiceLoaderUtil.firstByServiceLoader(factoryClass, loader, logger, EXCEPTION_HANDLER);
        if (factory2 != null) {
            return factory2;
        }
        T result2 = FactoryFinder.lookupUsingHk2ServiceLoader(factoryClass, loader);
        if (result2 != null) {
            return result2;
        }
        return null;
    }

    private static <T> T newInstance(String className, Class<? extends T> service, ClassLoader loader) throws RuntimeException {
        return ServiceLoaderUtil.newInstance(className, service, loader, EXCEPTION_HANDLER);
    }

    private static String fromSystemProperty(String factoryId) {
        String systemProp = FactoryFinder.getSystemProperty(factoryId);
        return systemProp;
    }

    private static String getSystemProperty(final String property) {
        logger.log(Level.FINE, "Checking system property {0}", property);
        String value = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(property);
            }
        });
        FactoryFinder.logFound(value);
        return value;
    }

    private static void logFound(String value) {
        if (value != null) {
            logger.log(Level.FINE, "  found {0}", value);
        } else {
            logger.log(Level.FINE, "  not found");
        }
    }

    private static Class<?>[] getHk2ServiceLoaderTargets(Class<?> factoryClass) {
        ClassLoader[] loaders = FactoryFinder.getClassLoaders(Thread.class, factoryClass, System.class);
        Class[] classes = new Class[loaders.length];
        int w = 0;
        for (ClassLoader loader : loaders) {
            if (loader == null) continue;
            try {
                classes[w++] = Class.forName("org.glassfish.hk2.osgiresourcelocator.ServiceLoader", false, loader);
            }
            catch (Exception | LinkageError throwable) {
                // empty catch block
            }
        }
        if (classes.length != w) {
            classes = Arrays.copyOf(classes, w);
        }
        return classes;
    }

    private static <T> T lookupUsingHk2ServiceLoader(Class<T> factoryClass, ClassLoader loader) {
        for (Class<?> target : FactoryFinder.getHk2ServiceLoaderTargets(factoryClass)) {
            try {
                Iterator iter;
                Class<?> serviceClass = Class.forName(factoryClass.getName(), false, loader);
                Class[] args2 = new Class[]{serviceClass};
                Method m4 = target.getMethod("lookupProviderInstances", Class.class);
                Iterable iterable = (Iterable)m4.invoke(null, (Object[])args2);
                if (iterable == null || !(iter = iterable.iterator()).hasNext()) continue;
                return factoryClass.cast(iter.next());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static ClassLoader[] getClassLoaders(final Class<?> ... classes) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader[]>(){

            @Override
            public ClassLoader[] run() {
                ClassLoader[] loaders = new ClassLoader[classes.length];
                int w = 0;
                for (Class k : classes) {
                    ClassLoader cl = null;
                    if (k == Thread.class) {
                        try {
                            cl = Thread.currentThread().getContextClassLoader();
                        }
                        catch (SecurityException securityException) {}
                    } else if (k == System.class) {
                        try {
                            cl = ClassLoader.getSystemClassLoader();
                        }
                        catch (SecurityException securityException) {}
                    } else {
                        try {
                            cl = k.getClassLoader();
                        }
                        catch (SecurityException securityException) {
                            // empty catch block
                        }
                    }
                    if (cl == null) continue;
                    loaders[w++] = cl;
                }
                if (loaders.length != w) {
                    loaders = Arrays.copyOf(loaders, w);
                }
                return loaders;
            }
        });
    }
}

