/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.util.IOHelper;

public final class GroupIterator
implements Iterator<Object>,
Closeable {
    private final Iterator<?> it;
    private final int group;
    private boolean closed;

    public GroupIterator(Iterator<?> it, int group) {
        this.it = it;
        this.group = group;
        if (group <= 0) {
            throw new IllegalArgumentException("Group must be a positive number, was: " + group);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            IOHelper.closeIterator(this.it);
        }
        finally {
            this.closed = true;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.closed) {
            return false;
        }
        boolean answer = this.it.hasNext();
        if (!answer) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return answer;
    }

    @Override
    public Object next() {
        try {
            return this.doNext();
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
    }

    private Object doNext() {
        ArrayList list = new ArrayList();
        for (int count = 0; count < this.group && this.it.hasNext(); ++count) {
            Object data = this.it.next();
            list.add(data);
        }
        return list;
    }

    @Override
    public void remove() {
        this.it.remove();
    }
}

