/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.concurrent;

import java.util.PriorityQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;

public class AsyncCompletionService<V> {
    private final Executor executor;
    private final boolean ordered;
    private final PriorityQueue<Task> queue;
    private final AtomicInteger nextId = new AtomicInteger();
    private final AtomicInteger index = new AtomicInteger();
    private final ReentrantLock lock;
    private final Condition available;

    public AsyncCompletionService(Executor executor, boolean ordered) {
        this(executor, ordered, null, 0);
    }

    public AsyncCompletionService(Executor executor, boolean ordered, ReentrantLock lock) {
        this(executor, ordered, lock, 0);
    }

    public AsyncCompletionService(Executor executor, boolean ordered, ReentrantLock lock, int capacity) {
        this.executor = executor;
        this.ordered = ordered;
        this.lock = lock != null ? lock : new ReentrantLock();
        this.available = this.lock.newCondition();
        this.queue = capacity > 0 ? new PriorityQueue(capacity) : new PriorityQueue();
    }

    public ReentrantLock getLock() {
        return this.lock;
    }

    public void submit(Consumer<Consumer<V>> runner) {
        Task f = new Task(this.nextId.getAndIncrement(), runner);
        this.executor.execute(f);
    }

    public void skip() {
        this.index.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V pollUnordered() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Task t2 = this.queue.poll();
            V v = t2 != null ? (V)t2.result : null;
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V poll() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Task t2 = this.queue.peek();
            if (t2 != null && (!this.ordered || this.index.compareAndSet(t2.id, t2.id + 1))) {
                this.queue.poll();
                Object v = t2.result;
                return v;
            }
            V v = null;
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    public V poll(long timeout2, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout2);
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (true) {
                Task t2;
                if ((t2 = this.queue.peek()) != null && (!this.ordered || this.index.compareAndSet(t2.id, t2.id + 1))) {
                    this.queue.poll();
                    Object v = t2.result;
                    return v;
                }
                if (nanos <= 0L) {
                    V v = null;
                    return v;
                }
                nanos = this.available.awaitNanos(nanos);
            }
        }
        finally {
            lock.unlock();
        }
    }

    public V take() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (true) {
                Task t2;
                if ((t2 = this.queue.peek()) != null && (!this.ordered || this.index.compareAndSet(t2.id, t2.id + 1))) {
                    this.queue.poll();
                    Object v = t2.result;
                    return v;
                }
                this.available.await();
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void complete(Task task) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.queue.add(task);
            this.available.signalAll();
        }
        finally {
            lock.unlock();
        }
    }

    private class Task
    implements Runnable,
    Comparable<Task>,
    Consumer<V> {
        private final int id;
        private final Consumer<Consumer<V>> runner;
        private V result;

        Task(int id, Consumer<Consumer<V>> runner) {
            this.id = id;
            this.runner = runner;
        }

        @Override
        public void run() {
            this.runner.accept(this);
        }

        @Override
        public void accept(V result) {
            this.result = result;
            AsyncCompletionService.this.complete(this);
        }

        @Override
        public int compareTo(Task other) {
            return Integer.compare(this.id, other.id);
        }

        public String toString() {
            return "SubmitOrderedTask[" + this.id + "]";
        }
    }
}

