/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.acl.common;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.rocketmq.acl.common.AclException;
import org.apache.rocketmq.acl.common.SigningAlgorithm;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;

public class AclSigner {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    public static final SigningAlgorithm DEFAULT_ALGORITHM = SigningAlgorithm.HmacSHA1;
    private static final Logger log = LoggerFactory.getLogger("RocketmqAuthorize");
    private static final int CAL_SIGNATURE_FAILED = 10015;
    private static final String CAL_SIGNATURE_FAILED_MSG = "[%s:signature-failed] unable to calculate a request signature. error=%s";

    public static String calSignature(String data, String key) throws AclException {
        return AclSigner.calSignature(data, key, DEFAULT_ALGORITHM, DEFAULT_CHARSET);
    }

    public static String calSignature(String data, String key, SigningAlgorithm algorithm, Charset charset) throws AclException {
        return AclSigner.signAndBase64Encode(data, key, algorithm, charset);
    }

    private static String signAndBase64Encode(String data, String key, SigningAlgorithm algorithm, Charset charset) throws AclException {
        try {
            byte[] signature = AclSigner.sign(data.getBytes(charset), key.getBytes(charset), algorithm);
            return new String(Base64.encodeBase64(signature), DEFAULT_CHARSET);
        }
        catch (Exception e) {
            String message = String.format(CAL_SIGNATURE_FAILED_MSG, 10015, e.getMessage());
            log.error(message, e);
            throw new AclException("CAL_SIGNATURE_FAILED", 10015, message, e);
        }
    }

    private static byte[] sign(byte[] data, byte[] key, SigningAlgorithm algorithm) throws AclException {
        try {
            Mac mac = Mac.getInstance(algorithm.toString());
            mac.init(new SecretKeySpec(key, algorithm.toString()));
            return mac.doFinal(data);
        }
        catch (Exception e) {
            String message = String.format(CAL_SIGNATURE_FAILED_MSG, 10015, e.getMessage());
            log.error(message, e);
            throw new AclException("CAL_SIGNATURE_FAILED", 10015, message, e);
        }
    }

    public static String calSignature(byte[] data, String key) throws AclException {
        return AclSigner.calSignature(data, key, DEFAULT_ALGORITHM, DEFAULT_CHARSET);
    }

    public static String calSignature(byte[] data, String key, SigningAlgorithm algorithm, Charset charset) throws AclException {
        return AclSigner.signAndBase64Encode(data, key, algorithm, charset);
    }

    private static String signAndBase64Encode(byte[] data, String key, SigningAlgorithm algorithm, Charset charset) throws AclException {
        try {
            byte[] signature = AclSigner.sign(data, key.getBytes(charset), algorithm);
            return new String(Base64.encodeBase64(signature), DEFAULT_CHARSET);
        }
        catch (Exception e) {
            String message = String.format(CAL_SIGNATURE_FAILED_MSG, 10015, e.getMessage());
            log.error(message, e);
            throw new AclException("CAL_SIGNATURE_FAILED", 10015, message, e);
        }
    }
}

