/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.action;

import com.alibaba.fastjson2.annotation.JSONField;
import org.apache.commons.lang3.StringUtils;

public enum Action {
    UNKNOWN(0, "Unknown"),
    ALL(1, "All"),
    ANY(2, "Any"),
    PUB(3, "Pub"),
    SUB(4, "Sub"),
    CREATE(5, "Create"),
    UPDATE(6, "Update"),
    DELETE(7, "Delete"),
    GET(8, "Get"),
    LIST(9, "List");

    @JSONField(value=true)
    private final byte code;
    private final String name;

    private Action(byte code, String name) {
        this.code = code;
        this.name = name;
    }

    public static Action getByName(String name) {
        for (Action action : Action.values()) {
            if (!StringUtils.equalsIgnoreCase(action.getName(), name)) continue;
            return action;
        }
        return null;
    }

    public byte getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }
}

