/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.attribute;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class AttributeParser {
    public static final String ATTR_ARRAY_SEPARATOR_COMMA = ",";
    public static final String ATTR_KEY_VALUE_EQUAL_SIGN = "=";
    public static final String ATTR_ADD_PLUS_SIGN = "+";
    private static final String ATTR_DELETE_MINUS_SIGN = "-";

    public static Map<String, String> parseToMap(String attributesModification) {
        String[] kvs;
        if (Strings.isNullOrEmpty(attributesModification)) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (String kv : kvs = attributesModification.split(ATTR_ARRAY_SEPARATOR_COMMA)) {
            String old;
            String value;
            String key;
            if (kv.contains(ATTR_KEY_VALUE_EQUAL_SIGN)) {
                String[] splits = kv.split(ATTR_KEY_VALUE_EQUAL_SIGN);
                key = splits[0];
                value = splits[1];
                if (!key.contains(ATTR_ADD_PLUS_SIGN)) {
                    throw new RuntimeException("add/alter attribute format is wrong: " + key);
                }
            } else {
                key = kv;
                value = "";
                if (!key.contains(ATTR_DELETE_MINUS_SIGN)) {
                    throw new RuntimeException("delete attribute format is wrong: " + key);
                }
            }
            if ((old = attributes.put(key, value)) == null) continue;
            throw new RuntimeException("key duplication: " + key);
        }
        return attributes;
    }

    public static String parseToString(Map<String, String> attributes) {
        if (attributes == null || attributes.size() == 0) {
            return "";
        }
        ArrayList<String> kvs = new ArrayList<String>();
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String value = entry.getValue();
            if (Strings.isNullOrEmpty(value)) {
                kvs.add(entry.getKey());
                continue;
            }
            kvs.add(entry.getKey() + ATTR_KEY_VALUE_EQUAL_SIGN + entry.getValue());
        }
        return String.join((CharSequence)ATTR_ARRAY_SEPARATOR_COMMA, kvs);
    }
}

