/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.attribute;

import com.google.common.base.Preconditions;
import org.apache.rocketmq.common.attribute.Attribute;

public class BooleanAttribute
extends Attribute {
    private final boolean defaultValue;

    public BooleanAttribute(String name, boolean changeable, boolean defaultValue) {
        super(name, changeable);
        this.defaultValue = defaultValue;
    }

    @Override
    public void verify(String value) {
        Preconditions.checkNotNull(value);
        if (!"false".equalsIgnoreCase(value) && !"true".equalsIgnoreCase(value)) {
            throw new RuntimeException("boolean attribute format is wrong.");
        }
    }

    public boolean getDefaultValue() {
        return this.defaultValue;
    }
}

