/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.netty;

import io.netty.util.internal.logging.InternalLogLevel;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;

public class NettyLogger {
    private static AtomicBoolean nettyLoggerSeted = new AtomicBoolean(false);
    private static InternalLogLevel nettyLogLevel = InternalLogLevel.ERROR;

    public static void initNettyLogger() {
        if (!nettyLoggerSeted.get()) {
            try {
                InternalLoggerFactory.setDefaultFactory(new NettyBridgeLoggerFactory());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            nettyLoggerSeted.set(true);
        }
    }

    private static class NettyBridgeLogger
    implements InternalLogger {
        private Logger logger = null;
        private static final String EXCEPTION_MESSAGE = "Unexpected exception:";

        public NettyBridgeLogger(String name) {
            this.logger = LoggerFactory.getLogger(name);
        }

        @Override
        public String name() {
            return this.logger.getName();
        }

        @Override
        public boolean isEnabled(InternalLogLevel internalLogLevel) {
            return nettyLogLevel.ordinal() <= internalLogLevel.ordinal();
        }

        @Override
        public void log(InternalLogLevel internalLogLevel, String s2) {
            if (internalLogLevel.equals((Object)InternalLogLevel.DEBUG)) {
                this.logger.debug(s2);
            }
            if (internalLogLevel.equals((Object)InternalLogLevel.TRACE)) {
                this.logger.info(s2);
            }
            if (internalLogLevel.equals((Object)InternalLogLevel.INFO)) {
                this.logger.info(s2);
            }
            if (internalLogLevel.equals((Object)InternalLogLevel.WARN)) {
                this.logger.warn(s2);
            }
            if (internalLogLevel.equals((Object)InternalLogLevel.ERROR)) {
                this.logger.error(s2);
            }
        }

        @Override
        public void log(InternalLogLevel internalLogLevel, String s2, Object o) {
            if (internalLogLevel.equals((Object)InternalLogLevel.DEBUG)) {
                this.logger.debug(s2, o);
            }
            if (internalLogLevel.equals((Object)InternalLogLevel.TRACE)) {
                this.logger.info(s2, o);
            }
            if (internalLogLevel.equals((Object)InternalLogLevel.INFO)) {
                this.logger.info(s2, o);
            }
            if (internalLogLevel.equals((Object)InternalLogLevel.WARN)) {
                this.logger.warn(s2, o);
            }
            if (internalLogLevel.equals((Object)InternalLogLevel.ERROR)) {
                this.logger.error(s2, o);
            }
        }

        @Override
        public void log(InternalLogLevel internalLogLevel, String s2, Object o, Object o1) {
            if (internalLogLevel.equals((Object)InternalLogLevel.DEBUG)) {
                this.logger.debug(s2, o, o1);
            }
            if (internalLogLevel.equals((Object)InternalLogLevel.TRACE)) {
                this.logger.info(s2, o, o1);
            }
            if (internalLogLevel.equals((Object)InternalLogLevel.INFO)) {
                this.logger.info(s2, o, o1);
            }
            if (internalLogLevel.equals((Object)InternalLogLevel.WARN)) {
                this.logger.warn(s2, o, o1);
            }
            if (internalLogLevel.equals((Object)InternalLogLevel.ERROR)) {
                this.logger.error(s2, o, o1);
            }
        }

        @Override
        public void log(InternalLogLevel internalLogLevel, String s2, Object ... objects) {
            if (internalLogLevel.equals((Object)InternalLogLevel.DEBUG)) {
                this.logger.debug(s2, objects);
            }
            if (internalLogLevel.equals((Object)InternalLogLevel.TRACE)) {
                this.logger.info(s2, objects);
            }
            if (internalLogLevel.equals((Object)InternalLogLevel.INFO)) {
                this.logger.info(s2, objects);
            }
            if (internalLogLevel.equals((Object)InternalLogLevel.WARN)) {
                this.logger.warn(s2, objects);
            }
            if (internalLogLevel.equals((Object)InternalLogLevel.ERROR)) {
                this.logger.error(s2, objects);
            }
        }

        @Override
        public void log(InternalLogLevel internalLogLevel, String s2, Throwable throwable) {
            if (internalLogLevel.equals((Object)InternalLogLevel.DEBUG)) {
                this.logger.debug(s2, throwable);
            }
            if (internalLogLevel.equals((Object)InternalLogLevel.TRACE)) {
                this.logger.info(s2, throwable);
            }
            if (internalLogLevel.equals((Object)InternalLogLevel.INFO)) {
                this.logger.info(s2, throwable);
            }
            if (internalLogLevel.equals((Object)InternalLogLevel.WARN)) {
                this.logger.warn(s2, throwable);
            }
            if (internalLogLevel.equals((Object)InternalLogLevel.ERROR)) {
                this.logger.error(s2, throwable);
            }
        }

        @Override
        public void log(InternalLogLevel internalLogLevel, Throwable throwable) {
            if (internalLogLevel.equals((Object)InternalLogLevel.DEBUG)) {
                this.logger.debug(EXCEPTION_MESSAGE, throwable);
            }
            if (internalLogLevel.equals((Object)InternalLogLevel.TRACE)) {
                this.logger.info(EXCEPTION_MESSAGE, throwable);
            }
            if (internalLogLevel.equals((Object)InternalLogLevel.INFO)) {
                this.logger.info(EXCEPTION_MESSAGE, throwable);
            }
            if (internalLogLevel.equals((Object)InternalLogLevel.WARN)) {
                this.logger.warn(EXCEPTION_MESSAGE, throwable);
            }
            if (internalLogLevel.equals((Object)InternalLogLevel.ERROR)) {
                this.logger.error(EXCEPTION_MESSAGE, throwable);
            }
        }

        @Override
        public boolean isTraceEnabled() {
            return this.isEnabled(InternalLogLevel.TRACE);
        }

        @Override
        public void trace(String var1) {
            this.logger.info(var1);
        }

        @Override
        public void trace(String var1, Object var2) {
            this.logger.info(var1, var2);
        }

        @Override
        public void trace(String var1, Object var2, Object var3) {
            this.logger.info(var1, var2, var3);
        }

        @Override
        public void trace(String var1, Object ... var2) {
            this.logger.info(var1, var2);
        }

        @Override
        public void trace(String var1, Throwable var2) {
            this.logger.info(var1, var2);
        }

        @Override
        public void trace(Throwable var1) {
            this.logger.info(EXCEPTION_MESSAGE, var1);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.isEnabled(InternalLogLevel.DEBUG);
        }

        @Override
        public void debug(String var1) {
            this.logger.debug(var1);
        }

        @Override
        public void debug(String var1, Object var2) {
            this.logger.debug(var1, var2);
        }

        @Override
        public void debug(String var1, Object var2, Object var3) {
            this.logger.debug(var1, var2, var3);
        }

        @Override
        public void debug(String var1, Object ... var2) {
            this.logger.debug(var1, var2);
        }

        @Override
        public void debug(String var1, Throwable var2) {
            this.logger.debug(var1, var2);
        }

        @Override
        public void debug(Throwable var1) {
            this.logger.debug(EXCEPTION_MESSAGE, var1);
        }

        @Override
        public boolean isInfoEnabled() {
            return this.isEnabled(InternalLogLevel.INFO);
        }

        @Override
        public void info(String var1) {
            this.logger.info(var1);
        }

        @Override
        public void info(String var1, Object var2) {
            this.logger.info(var1, var2);
        }

        @Override
        public void info(String var1, Object var2, Object var3) {
            this.logger.info(var1, var2, var3);
        }

        @Override
        public void info(String var1, Object ... var2) {
            this.logger.info(var1, var2);
        }

        @Override
        public void info(String var1, Throwable var2) {
            this.logger.info(var1, var2);
        }

        @Override
        public void info(Throwable var1) {
            this.logger.info(EXCEPTION_MESSAGE, var1);
        }

        @Override
        public boolean isWarnEnabled() {
            return this.isEnabled(InternalLogLevel.WARN);
        }

        @Override
        public void warn(String var1) {
            this.logger.warn(var1);
        }

        @Override
        public void warn(String var1, Object var2) {
            this.logger.warn(var1, var2);
        }

        @Override
        public void warn(String var1, Object ... var2) {
            this.logger.warn(var1, var2);
        }

        @Override
        public void warn(String var1, Object var2, Object var3) {
            this.logger.warn(var1, var2, var3);
        }

        @Override
        public void warn(String var1, Throwable var2) {
            this.logger.warn(var1, var2);
        }

        @Override
        public void warn(Throwable var1) {
            this.logger.warn(EXCEPTION_MESSAGE, var1);
        }

        @Override
        public boolean isErrorEnabled() {
            return this.isEnabled(InternalLogLevel.ERROR);
        }

        @Override
        public void error(String var1) {
            this.logger.error(var1);
        }

        @Override
        public void error(String var1, Object var2) {
            this.logger.error(var1, var2);
        }

        @Override
        public void error(String var1, Object var2, Object var3) {
            this.logger.error(var1, var2, var3);
        }

        @Override
        public void error(String var1, Object ... var2) {
            this.logger.error(var1, var2);
        }

        @Override
        public void error(String var1, Throwable var2) {
            this.logger.error(var1, var2);
        }

        @Override
        public void error(Throwable var1) {
            this.logger.error(EXCEPTION_MESSAGE, var1);
        }
    }

    private static class NettyBridgeLoggerFactory
    extends InternalLoggerFactory {
        private NettyBridgeLoggerFactory() {
        }

        @Override
        protected InternalLogger newInstance(String s2) {
            return new NettyBridgeLogger(s2);
        }
    }
}

