/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.component.salesforce.AuthenticationType;
import org.apache.camel.component.salesforce.NotFoundBehaviour;
import org.apache.camel.component.salesforce.SalesforceComponent;
import org.apache.camel.component.salesforce.SalesforceEndpointConfig;
import org.apache.camel.component.salesforce.SalesforceHttpClient;
import org.apache.camel.component.salesforce.SalesforceLoginConfig;
import org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportMetadata;
import org.apache.camel.component.salesforce.api.dto.bulk.ContentType;
import org.apache.camel.component.salesforce.internal.PayloadFormat;
import org.apache.camel.component.salesforce.internal.dto.NotifyForFieldsEnum;
import org.apache.camel.component.salesforce.internal.dto.NotifyForOperationsEnum;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.support.jsse.KeyStoreParameters;
import org.apache.camel.support.jsse.SSLContextParameters;

public class SalesforceComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private SalesforceEndpointConfig getOrCreateConfig(SalesforceComponent target) {
        if (target.getConfig() == null) {
            target.setConfig(new SalesforceEndpointConfig());
        }
        return target.getConfig();
    }

    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        SalesforceComponent target = (SalesforceComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "allornone": 
            case "allOrNone": {
                this.getOrCreateConfig(target).setAllOrNone(SalesforceComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "apexmethod": 
            case "apexMethod": {
                this.getOrCreateConfig(target).setApexMethod(SalesforceComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "apexqueryparams": 
            case "apexQueryParams": {
                this.getOrCreateConfig(target).setApexQueryParams(SalesforceComponentConfigurer.property(camelContext, Map.class, value));
                return true;
            }
            case "apexurl": 
            case "apexUrl": {
                this.getOrCreateConfig(target).setApexUrl(SalesforceComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "apiversion": 
            case "apiVersion": {
                this.getOrCreateConfig(target).setApiVersion(SalesforceComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "authenticationtype": 
            case "authenticationType": {
                target.setAuthenticationType(SalesforceComponentConfigurer.property(camelContext, AuthenticationType.class, value));
                return true;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled(SalesforceComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "backoffincrement": 
            case "backoffIncrement": {
                this.getOrCreateConfig(target).setBackoffIncrement(SalesforceComponentConfigurer.property(camelContext, Duration.class, value).toMillis());
                return true;
            }
            case "batchid": 
            case "batchId": {
                this.getOrCreateConfig(target).setBatchId(SalesforceComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(SalesforceComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "clientid": 
            case "clientId": {
                target.setClientId(SalesforceComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "clientsecret": 
            case "clientSecret": {
                target.setClientSecret(SalesforceComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "compositemethod": 
            case "compositeMethod": {
                this.getOrCreateConfig(target).setCompositeMethod(SalesforceComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "config": {
                target.setConfig(SalesforceComponentConfigurer.property(camelContext, SalesforceEndpointConfig.class, value));
                return true;
            }
            case "contenttype": 
            case "contentType": {
                this.getOrCreateConfig(target).setContentType(SalesforceComponentConfigurer.property(camelContext, ContentType.class, value));
                return true;
            }
            case "defaultreplayid": 
            case "defaultReplayId": {
                this.getOrCreateConfig(target).setDefaultReplayId(SalesforceComponentConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "fallbackreplayid": 
            case "fallBackReplayId": {
                this.getOrCreateConfig(target).setFallBackReplayId(SalesforceComponentConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "format": {
                this.getOrCreateConfig(target).setFormat(SalesforceComponentConfigurer.property(camelContext, PayloadFormat.class, value));
                return true;
            }
            case "httpclient": 
            case "httpClient": {
                this.getOrCreateConfig(target).setHttpClient(SalesforceComponentConfigurer.property(camelContext, SalesforceHttpClient.class, value));
                return true;
            }
            case "httpclientconnectiontimeout": 
            case "httpClientConnectionTimeout": {
                target.setHttpClientConnectionTimeout(SalesforceComponentConfigurer.property(camelContext, Long.TYPE, value));
                return true;
            }
            case "httpclientidletimeout": 
            case "httpClientIdleTimeout": {
                target.setHttpClientIdleTimeout(SalesforceComponentConfigurer.property(camelContext, Long.TYPE, value));
                return true;
            }
            case "httpclientproperties": 
            case "httpClientProperties": {
                target.setHttpClientProperties(SalesforceComponentConfigurer.property(camelContext, Map.class, value));
                return true;
            }
            case "httpmaxcontentlength": 
            case "httpMaxContentLength": {
                target.setHttpMaxContentLength(SalesforceComponentConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "httpproxyauthuri": 
            case "httpProxyAuthUri": {
                target.setHttpProxyAuthUri(SalesforceComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "httpproxyexcludedaddresses": 
            case "httpProxyExcludedAddresses": {
                target.setHttpProxyExcludedAddresses(SalesforceComponentConfigurer.property(camelContext, Set.class, value));
                return true;
            }
            case "httpproxyhost": 
            case "httpProxyHost": {
                target.setHttpProxyHost(SalesforceComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "httpproxyincludedaddresses": 
            case "httpProxyIncludedAddresses": {
                target.setHttpProxyIncludedAddresses(SalesforceComponentConfigurer.property(camelContext, Set.class, value));
                return true;
            }
            case "httpproxypassword": 
            case "httpProxyPassword": {
                target.setHttpProxyPassword(SalesforceComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "httpproxyport": 
            case "httpProxyPort": {
                target.setHttpProxyPort(SalesforceComponentConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "httpproxyrealm": 
            case "httpProxyRealm": {
                target.setHttpProxyRealm(SalesforceComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "httpproxysecure": 
            case "httpProxySecure": {
                target.setHttpProxySecure(SalesforceComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "httpproxysocks4": 
            case "httpProxySocks4": {
                target.setHttpProxySocks4(SalesforceComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "httpproxyusedigestauth": 
            case "httpProxyUseDigestAuth": {
                target.setHttpProxyUseDigestAuth(SalesforceComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "httpproxyusername": 
            case "httpProxyUsername": {
                target.setHttpProxyUsername(SalesforceComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "httprequestbuffersize": 
            case "httpRequestBufferSize": {
                target.setHttpRequestBufferSize(SalesforceComponentConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "httprequesttimeout": 
            case "httpRequestTimeout": {
                target.setHttpRequestTimeout(SalesforceComponentConfigurer.property(camelContext, Long.TYPE, value));
                return true;
            }
            case "includedetails": 
            case "includeDetails": {
                this.getOrCreateConfig(target).setIncludeDetails(SalesforceComponentConfigurer.property(camelContext, Boolean.class, value));
                return true;
            }
            case "initialreplayidmap": 
            case "initialReplayIdMap": {
                this.getOrCreateConfig(target).setInitialReplayIdMap(SalesforceComponentConfigurer.property(camelContext, Map.class, value));
                return true;
            }
            case "instanceid": 
            case "instanceId": {
                this.getOrCreateConfig(target).setInstanceId(SalesforceComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "instanceurl": 
            case "instanceUrl": {
                target.setInstanceUrl(SalesforceComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "jobid": 
            case "jobId": {
                this.getOrCreateConfig(target).setJobId(SalesforceComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "jwtaudience": 
            case "jwtAudience": {
                target.setJwtAudience(SalesforceComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "keystore": {
                target.setKeystore(SalesforceComponentConfigurer.property(camelContext, KeyStoreParameters.class, value));
                return true;
            }
            case "lazylogin": 
            case "lazyLogin": {
                target.setLazyLogin(SalesforceComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(SalesforceComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "limit": {
                this.getOrCreateConfig(target).setLimit(SalesforceComponentConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "locator": {
                this.getOrCreateConfig(target).setLocator(SalesforceComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "loginconfig": 
            case "loginConfig": {
                target.setLoginConfig(SalesforceComponentConfigurer.property(camelContext, SalesforceLoginConfig.class, value));
                return true;
            }
            case "loginurl": 
            case "loginUrl": {
                target.setLoginUrl(SalesforceComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "longpollingtransportproperties": 
            case "longPollingTransportProperties": {
                target.setLongPollingTransportProperties(SalesforceComponentConfigurer.property(camelContext, Map.class, value));
                return true;
            }
            case "maxbackoff": 
            case "maxBackoff": {
                this.getOrCreateConfig(target).setMaxBackoff(SalesforceComponentConfigurer.property(camelContext, Duration.class, value).toMillis());
                return true;
            }
            case "maxrecords": 
            case "maxRecords": {
                this.getOrCreateConfig(target).setMaxRecords(SalesforceComponentConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "notfoundbehaviour": 
            case "notFoundBehaviour": {
                this.getOrCreateConfig(target).setNotFoundBehaviour(SalesforceComponentConfigurer.property(camelContext, NotFoundBehaviour.class, value));
                return true;
            }
            case "notifyforfields": 
            case "notifyForFields": {
                this.getOrCreateConfig(target).setNotifyForFields(SalesforceComponentConfigurer.property(camelContext, NotifyForFieldsEnum.class, value));
                return true;
            }
            case "notifyforoperationcreate": 
            case "notifyForOperationCreate": {
                this.getOrCreateConfig(target).setNotifyForOperationCreate(SalesforceComponentConfigurer.property(camelContext, Boolean.class, value));
                return true;
            }
            case "notifyforoperationdelete": 
            case "notifyForOperationDelete": {
                this.getOrCreateConfig(target).setNotifyForOperationDelete(SalesforceComponentConfigurer.property(camelContext, Boolean.class, value));
                return true;
            }
            case "notifyforoperationundelete": 
            case "notifyForOperationUndelete": {
                this.getOrCreateConfig(target).setNotifyForOperationUndelete(SalesforceComponentConfigurer.property(camelContext, Boolean.class, value));
                return true;
            }
            case "notifyforoperationupdate": 
            case "notifyForOperationUpdate": {
                this.getOrCreateConfig(target).setNotifyForOperationUpdate(SalesforceComponentConfigurer.property(camelContext, Boolean.class, value));
                return true;
            }
            case "notifyforoperations": 
            case "notifyForOperations": {
                this.getOrCreateConfig(target).setNotifyForOperations(SalesforceComponentConfigurer.property(camelContext, NotifyForOperationsEnum.class, value));
                return true;
            }
            case "objectmapper": 
            case "objectMapper": {
                this.getOrCreateConfig(target).setObjectMapper(SalesforceComponentConfigurer.property(camelContext, ObjectMapper.class, value));
                return true;
            }
            case "packages": {
                target.setPackages(SalesforceComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "password": {
                target.setPassword(SalesforceComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "pkchunking": 
            case "pkChunking": {
                this.getOrCreateConfig(target).setPkChunking(SalesforceComponentConfigurer.property(camelContext, Boolean.class, value));
                return true;
            }
            case "pkchunkingchunksize": 
            case "pkChunkingChunkSize": {
                this.getOrCreateConfig(target).setPkChunkingChunkSize(SalesforceComponentConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "pkchunkingparent": 
            case "pkChunkingParent": {
                this.getOrCreateConfig(target).setPkChunkingParent(SalesforceComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "pkchunkingstartrow": 
            case "pkChunkingStartRow": {
                this.getOrCreateConfig(target).setPkChunkingStartRow(SalesforceComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "querylocator": 
            case "queryLocator": {
                this.getOrCreateConfig(target).setQueryLocator(SalesforceComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "rawhttpheaders": 
            case "rawHttpHeaders": {
                this.getOrCreateConfig(target).setRawHttpHeaders(SalesforceComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "rawmethod": 
            case "rawMethod": {
                this.getOrCreateConfig(target).setRawMethod(SalesforceComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "rawpath": 
            case "rawPath": {
                this.getOrCreateConfig(target).setRawPath(SalesforceComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "rawpayload": 
            case "rawPayload": {
                this.getOrCreateConfig(target).setRawPayload(SalesforceComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "rawqueryparameters": 
            case "rawQueryParameters": {
                this.getOrCreateConfig(target).setRawQueryParameters(SalesforceComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "refreshtoken": 
            case "refreshToken": {
                target.setRefreshToken(SalesforceComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "reportid": 
            case "reportId": {
                this.getOrCreateConfig(target).setReportId(SalesforceComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "reportmetadata": 
            case "reportMetadata": {
                this.getOrCreateConfig(target).setReportMetadata(SalesforceComponentConfigurer.property(camelContext, ReportMetadata.class, value));
                return true;
            }
            case "resultid": 
            case "resultId": {
                this.getOrCreateConfig(target).setResultId(SalesforceComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "sobjectblobfieldname": 
            case "sObjectBlobFieldName": {
                this.getOrCreateConfig(target).setSObjectBlobFieldName(SalesforceComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "sobjectclass": 
            case "sObjectClass": {
                this.getOrCreateConfig(target).setSObjectClass(SalesforceComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "sobjectfields": 
            case "sObjectFields": {
                this.getOrCreateConfig(target).setSObjectFields(SalesforceComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "sobjectid": 
            case "sObjectId": {
                this.getOrCreateConfig(target).setSObjectId(SalesforceComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "sobjectidname": 
            case "sObjectIdName": {
                this.getOrCreateConfig(target).setSObjectIdName(SalesforceComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "sobjectidvalue": 
            case "sObjectIdValue": {
                this.getOrCreateConfig(target).setSObjectIdValue(SalesforceComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "sobjectname": 
            case "sObjectName": {
                this.getOrCreateConfig(target).setSObjectName(SalesforceComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "sobjectquery": 
            case "sObjectQuery": {
                this.getOrCreateConfig(target).setSObjectQuery(SalesforceComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "sobjectsearch": 
            case "sObjectSearch": {
                this.getOrCreateConfig(target).setSObjectSearch(SalesforceComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                target.setSslContextParameters(SalesforceComponentConfigurer.property(camelContext, SSLContextParameters.class, value));
                return true;
            }
            case "streamqueryresult": 
            case "streamQueryResult": {
                this.getOrCreateConfig(target).setStreamQueryResult(SalesforceComponentConfigurer.property(camelContext, Boolean.class, value));
                return true;
            }
            case "updatetopic": 
            case "updateTopic": {
                this.getOrCreateConfig(target).setUpdateTopic(SalesforceComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "useglobalsslcontextparameters": 
            case "useGlobalSslContextParameters": {
                target.setUseGlobalSslContextParameters(SalesforceComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "username": 
            case "userName": {
                target.setUserName(SalesforceComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "workerpoolmaxsize": 
            case "workerPoolMaxSize": {
                target.setWorkerPoolMaxSize(SalesforceComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "workerpoolsize": 
            case "workerPoolSize": {
                target.setWorkerPoolSize(SalesforceComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "allornone": 
            case "allOrNone": {
                return Boolean.TYPE;
            }
            case "apexmethod": 
            case "apexMethod": {
                return String.class;
            }
            case "apexqueryparams": 
            case "apexQueryParams": {
                return Map.class;
            }
            case "apexurl": 
            case "apexUrl": {
                return String.class;
            }
            case "apiversion": 
            case "apiVersion": {
                return String.class;
            }
            case "authenticationtype": 
            case "authenticationType": {
                return AuthenticationType.class;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "backoffincrement": 
            case "backoffIncrement": {
                return Long.TYPE;
            }
            case "batchid": 
            case "batchId": {
                return String.class;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "clientid": 
            case "clientId": {
                return String.class;
            }
            case "clientsecret": 
            case "clientSecret": {
                return String.class;
            }
            case "compositemethod": 
            case "compositeMethod": {
                return String.class;
            }
            case "config": {
                return SalesforceEndpointConfig.class;
            }
            case "contenttype": 
            case "contentType": {
                return ContentType.class;
            }
            case "defaultreplayid": 
            case "defaultReplayId": {
                return Long.class;
            }
            case "fallbackreplayid": 
            case "fallBackReplayId": {
                return Long.class;
            }
            case "format": {
                return PayloadFormat.class;
            }
            case "httpclient": 
            case "httpClient": {
                return SalesforceHttpClient.class;
            }
            case "httpclientconnectiontimeout": 
            case "httpClientConnectionTimeout": {
                return Long.TYPE;
            }
            case "httpclientidletimeout": 
            case "httpClientIdleTimeout": {
                return Long.TYPE;
            }
            case "httpclientproperties": 
            case "httpClientProperties": {
                return Map.class;
            }
            case "httpmaxcontentlength": 
            case "httpMaxContentLength": {
                return Integer.class;
            }
            case "httpproxyauthuri": 
            case "httpProxyAuthUri": {
                return String.class;
            }
            case "httpproxyexcludedaddresses": 
            case "httpProxyExcludedAddresses": {
                return Set.class;
            }
            case "httpproxyhost": 
            case "httpProxyHost": {
                return String.class;
            }
            case "httpproxyincludedaddresses": 
            case "httpProxyIncludedAddresses": {
                return Set.class;
            }
            case "httpproxypassword": 
            case "httpProxyPassword": {
                return String.class;
            }
            case "httpproxyport": 
            case "httpProxyPort": {
                return Integer.class;
            }
            case "httpproxyrealm": 
            case "httpProxyRealm": {
                return String.class;
            }
            case "httpproxysecure": 
            case "httpProxySecure": {
                return Boolean.TYPE;
            }
            case "httpproxysocks4": 
            case "httpProxySocks4": {
                return Boolean.TYPE;
            }
            case "httpproxyusedigestauth": 
            case "httpProxyUseDigestAuth": {
                return Boolean.TYPE;
            }
            case "httpproxyusername": 
            case "httpProxyUsername": {
                return String.class;
            }
            case "httprequestbuffersize": 
            case "httpRequestBufferSize": {
                return Integer.class;
            }
            case "httprequesttimeout": 
            case "httpRequestTimeout": {
                return Long.TYPE;
            }
            case "includedetails": 
            case "includeDetails": {
                return Boolean.class;
            }
            case "initialreplayidmap": 
            case "initialReplayIdMap": {
                return Map.class;
            }
            case "instanceid": 
            case "instanceId": {
                return String.class;
            }
            case "instanceurl": 
            case "instanceUrl": {
                return String.class;
            }
            case "jobid": 
            case "jobId": {
                return String.class;
            }
            case "jwtaudience": 
            case "jwtAudience": {
                return String.class;
            }
            case "keystore": {
                return KeyStoreParameters.class;
            }
            case "lazylogin": 
            case "lazyLogin": {
                return Boolean.TYPE;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "limit": {
                return Integer.class;
            }
            case "locator": {
                return String.class;
            }
            case "loginconfig": 
            case "loginConfig": {
                return SalesforceLoginConfig.class;
            }
            case "loginurl": 
            case "loginUrl": {
                return String.class;
            }
            case "longpollingtransportproperties": 
            case "longPollingTransportProperties": {
                return Map.class;
            }
            case "maxbackoff": 
            case "maxBackoff": {
                return Long.TYPE;
            }
            case "maxrecords": 
            case "maxRecords": {
                return Integer.class;
            }
            case "notfoundbehaviour": 
            case "notFoundBehaviour": {
                return NotFoundBehaviour.class;
            }
            case "notifyforfields": 
            case "notifyForFields": {
                return NotifyForFieldsEnum.class;
            }
            case "notifyforoperationcreate": 
            case "notifyForOperationCreate": {
                return Boolean.class;
            }
            case "notifyforoperationdelete": 
            case "notifyForOperationDelete": {
                return Boolean.class;
            }
            case "notifyforoperationundelete": 
            case "notifyForOperationUndelete": {
                return Boolean.class;
            }
            case "notifyforoperationupdate": 
            case "notifyForOperationUpdate": {
                return Boolean.class;
            }
            case "notifyforoperations": 
            case "notifyForOperations": {
                return NotifyForOperationsEnum.class;
            }
            case "objectmapper": 
            case "objectMapper": {
                return ObjectMapper.class;
            }
            case "packages": {
                return String.class;
            }
            case "password": {
                return String.class;
            }
            case "pkchunking": 
            case "pkChunking": {
                return Boolean.class;
            }
            case "pkchunkingchunksize": 
            case "pkChunkingChunkSize": {
                return Integer.class;
            }
            case "pkchunkingparent": 
            case "pkChunkingParent": {
                return String.class;
            }
            case "pkchunkingstartrow": 
            case "pkChunkingStartRow": {
                return String.class;
            }
            case "querylocator": 
            case "queryLocator": {
                return String.class;
            }
            case "rawhttpheaders": 
            case "rawHttpHeaders": {
                return String.class;
            }
            case "rawmethod": 
            case "rawMethod": {
                return String.class;
            }
            case "rawpath": 
            case "rawPath": {
                return String.class;
            }
            case "rawpayload": 
            case "rawPayload": {
                return Boolean.TYPE;
            }
            case "rawqueryparameters": 
            case "rawQueryParameters": {
                return String.class;
            }
            case "refreshtoken": 
            case "refreshToken": {
                return String.class;
            }
            case "reportid": 
            case "reportId": {
                return String.class;
            }
            case "reportmetadata": 
            case "reportMetadata": {
                return ReportMetadata.class;
            }
            case "resultid": 
            case "resultId": {
                return String.class;
            }
            case "sobjectblobfieldname": 
            case "sObjectBlobFieldName": {
                return String.class;
            }
            case "sobjectclass": 
            case "sObjectClass": {
                return String.class;
            }
            case "sobjectfields": 
            case "sObjectFields": {
                return String.class;
            }
            case "sobjectid": 
            case "sObjectId": {
                return String.class;
            }
            case "sobjectidname": 
            case "sObjectIdName": {
                return String.class;
            }
            case "sobjectidvalue": 
            case "sObjectIdValue": {
                return String.class;
            }
            case "sobjectname": 
            case "sObjectName": {
                return String.class;
            }
            case "sobjectquery": 
            case "sObjectQuery": {
                return String.class;
            }
            case "sobjectsearch": 
            case "sObjectSearch": {
                return String.class;
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                return SSLContextParameters.class;
            }
            case "streamqueryresult": 
            case "streamQueryResult": {
                return Boolean.class;
            }
            case "updatetopic": 
            case "updateTopic": {
                return Boolean.TYPE;
            }
            case "useglobalsslcontextparameters": 
            case "useGlobalSslContextParameters": {
                return Boolean.TYPE;
            }
            case "username": 
            case "userName": {
                return String.class;
            }
            case "workerpoolmaxsize": 
            case "workerPoolMaxSize": {
                return Integer.TYPE;
            }
            case "workerpoolsize": 
            case "workerPoolSize": {
                return Integer.TYPE;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        SalesforceComponent target = (SalesforceComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "allornone": 
            case "allOrNone": {
                return this.getOrCreateConfig(target).isAllOrNone();
            }
            case "apexmethod": 
            case "apexMethod": {
                return this.getOrCreateConfig(target).getApexMethod();
            }
            case "apexqueryparams": 
            case "apexQueryParams": {
                return this.getOrCreateConfig(target).getApexQueryParams();
            }
            case "apexurl": 
            case "apexUrl": {
                return this.getOrCreateConfig(target).getApexUrl();
            }
            case "apiversion": 
            case "apiVersion": {
                return this.getOrCreateConfig(target).getApiVersion();
            }
            case "authenticationtype": 
            case "authenticationType": {
                return target.getAuthenticationType();
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "backoffincrement": 
            case "backoffIncrement": {
                return this.getOrCreateConfig(target).getBackoffIncrement();
            }
            case "batchid": 
            case "batchId": {
                return this.getOrCreateConfig(target).getBatchId();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "clientid": 
            case "clientId": {
                return target.getClientId();
            }
            case "clientsecret": 
            case "clientSecret": {
                return target.getClientSecret();
            }
            case "compositemethod": 
            case "compositeMethod": {
                return this.getOrCreateConfig(target).getCompositeMethod();
            }
            case "config": {
                return target.getConfig();
            }
            case "contenttype": 
            case "contentType": {
                return this.getOrCreateConfig(target).getContentType();
            }
            case "defaultreplayid": 
            case "defaultReplayId": {
                return this.getOrCreateConfig(target).getDefaultReplayId();
            }
            case "fallbackreplayid": 
            case "fallBackReplayId": {
                return this.getOrCreateConfig(target).getFallBackReplayId();
            }
            case "format": {
                return this.getOrCreateConfig(target).getFormat();
            }
            case "httpclient": 
            case "httpClient": {
                return this.getOrCreateConfig(target).getHttpClient();
            }
            case "httpclientconnectiontimeout": 
            case "httpClientConnectionTimeout": {
                return target.getHttpClientConnectionTimeout();
            }
            case "httpclientidletimeout": 
            case "httpClientIdleTimeout": {
                return target.getHttpClientIdleTimeout();
            }
            case "httpclientproperties": 
            case "httpClientProperties": {
                return target.getHttpClientProperties();
            }
            case "httpmaxcontentlength": 
            case "httpMaxContentLength": {
                return target.getHttpMaxContentLength();
            }
            case "httpproxyauthuri": 
            case "httpProxyAuthUri": {
                return target.getHttpProxyAuthUri();
            }
            case "httpproxyexcludedaddresses": 
            case "httpProxyExcludedAddresses": {
                return target.getHttpProxyExcludedAddresses();
            }
            case "httpproxyhost": 
            case "httpProxyHost": {
                return target.getHttpProxyHost();
            }
            case "httpproxyincludedaddresses": 
            case "httpProxyIncludedAddresses": {
                return target.getHttpProxyIncludedAddresses();
            }
            case "httpproxypassword": 
            case "httpProxyPassword": {
                return target.getHttpProxyPassword();
            }
            case "httpproxyport": 
            case "httpProxyPort": {
                return target.getHttpProxyPort();
            }
            case "httpproxyrealm": 
            case "httpProxyRealm": {
                return target.getHttpProxyRealm();
            }
            case "httpproxysecure": 
            case "httpProxySecure": {
                return target.isHttpProxySecure();
            }
            case "httpproxysocks4": 
            case "httpProxySocks4": {
                return target.isHttpProxySocks4();
            }
            case "httpproxyusedigestauth": 
            case "httpProxyUseDigestAuth": {
                return target.isHttpProxyUseDigestAuth();
            }
            case "httpproxyusername": 
            case "httpProxyUsername": {
                return target.getHttpProxyUsername();
            }
            case "httprequestbuffersize": 
            case "httpRequestBufferSize": {
                return target.getHttpRequestBufferSize();
            }
            case "httprequesttimeout": 
            case "httpRequestTimeout": {
                return target.getHttpRequestTimeout();
            }
            case "includedetails": 
            case "includeDetails": {
                return this.getOrCreateConfig(target).getIncludeDetails();
            }
            case "initialreplayidmap": 
            case "initialReplayIdMap": {
                return this.getOrCreateConfig(target).getInitialReplayIdMap();
            }
            case "instanceid": 
            case "instanceId": {
                return this.getOrCreateConfig(target).getInstanceId();
            }
            case "instanceurl": 
            case "instanceUrl": {
                return target.getInstanceUrl();
            }
            case "jobid": 
            case "jobId": {
                return this.getOrCreateConfig(target).getJobId();
            }
            case "jwtaudience": 
            case "jwtAudience": {
                return target.getJwtAudience();
            }
            case "keystore": {
                return target.getKeystore();
            }
            case "lazylogin": 
            case "lazyLogin": {
                return target.isLazyLogin();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "limit": {
                return this.getOrCreateConfig(target).getLimit();
            }
            case "locator": {
                return this.getOrCreateConfig(target).getLocator();
            }
            case "loginconfig": 
            case "loginConfig": {
                return target.getLoginConfig();
            }
            case "loginurl": 
            case "loginUrl": {
                return target.getLoginUrl();
            }
            case "longpollingtransportproperties": 
            case "longPollingTransportProperties": {
                return target.getLongPollingTransportProperties();
            }
            case "maxbackoff": 
            case "maxBackoff": {
                return this.getOrCreateConfig(target).getMaxBackoff();
            }
            case "maxrecords": 
            case "maxRecords": {
                return this.getOrCreateConfig(target).getMaxRecords();
            }
            case "notfoundbehaviour": 
            case "notFoundBehaviour": {
                return this.getOrCreateConfig(target).getNotFoundBehaviour();
            }
            case "notifyforfields": 
            case "notifyForFields": {
                return this.getOrCreateConfig(target).getNotifyForFields();
            }
            case "notifyforoperationcreate": 
            case "notifyForOperationCreate": {
                return this.getOrCreateConfig(target).getNotifyForOperationCreate();
            }
            case "notifyforoperationdelete": 
            case "notifyForOperationDelete": {
                return this.getOrCreateConfig(target).getNotifyForOperationDelete();
            }
            case "notifyforoperationundelete": 
            case "notifyForOperationUndelete": {
                return this.getOrCreateConfig(target).getNotifyForOperationUndelete();
            }
            case "notifyforoperationupdate": 
            case "notifyForOperationUpdate": {
                return this.getOrCreateConfig(target).getNotifyForOperationUpdate();
            }
            case "notifyforoperations": 
            case "notifyForOperations": {
                return this.getOrCreateConfig(target).getNotifyForOperations();
            }
            case "objectmapper": 
            case "objectMapper": {
                return this.getOrCreateConfig(target).getObjectMapper();
            }
            case "packages": {
                return target.getPackages();
            }
            case "password": {
                return target.getPassword();
            }
            case "pkchunking": 
            case "pkChunking": {
                return this.getOrCreateConfig(target).getPkChunking();
            }
            case "pkchunkingchunksize": 
            case "pkChunkingChunkSize": {
                return this.getOrCreateConfig(target).getPkChunkingChunkSize();
            }
            case "pkchunkingparent": 
            case "pkChunkingParent": {
                return this.getOrCreateConfig(target).getPkChunkingParent();
            }
            case "pkchunkingstartrow": 
            case "pkChunkingStartRow": {
                return this.getOrCreateConfig(target).getPkChunkingStartRow();
            }
            case "querylocator": 
            case "queryLocator": {
                return this.getOrCreateConfig(target).getQueryLocator();
            }
            case "rawhttpheaders": 
            case "rawHttpHeaders": {
                return this.getOrCreateConfig(target).getRawHttpHeaders();
            }
            case "rawmethod": 
            case "rawMethod": {
                return this.getOrCreateConfig(target).getRawMethod();
            }
            case "rawpath": 
            case "rawPath": {
                return this.getOrCreateConfig(target).getRawPath();
            }
            case "rawpayload": 
            case "rawPayload": {
                return this.getOrCreateConfig(target).isRawPayload();
            }
            case "rawqueryparameters": 
            case "rawQueryParameters": {
                return this.getOrCreateConfig(target).getRawQueryParameters();
            }
            case "refreshtoken": 
            case "refreshToken": {
                return target.getRefreshToken();
            }
            case "reportid": 
            case "reportId": {
                return this.getOrCreateConfig(target).getReportId();
            }
            case "reportmetadata": 
            case "reportMetadata": {
                return this.getOrCreateConfig(target).getReportMetadata();
            }
            case "resultid": 
            case "resultId": {
                return this.getOrCreateConfig(target).getResultId();
            }
            case "sobjectblobfieldname": 
            case "sObjectBlobFieldName": {
                return this.getOrCreateConfig(target).getSObjectBlobFieldName();
            }
            case "sobjectclass": 
            case "sObjectClass": {
                return this.getOrCreateConfig(target).getSObjectClass();
            }
            case "sobjectfields": 
            case "sObjectFields": {
                return this.getOrCreateConfig(target).getSObjectFields();
            }
            case "sobjectid": 
            case "sObjectId": {
                return this.getOrCreateConfig(target).getSObjectId();
            }
            case "sobjectidname": 
            case "sObjectIdName": {
                return this.getOrCreateConfig(target).getSObjectIdName();
            }
            case "sobjectidvalue": 
            case "sObjectIdValue": {
                return this.getOrCreateConfig(target).getSObjectIdValue();
            }
            case "sobjectname": 
            case "sObjectName": {
                return this.getOrCreateConfig(target).getSObjectName();
            }
            case "sobjectquery": 
            case "sObjectQuery": {
                return this.getOrCreateConfig(target).getSObjectQuery();
            }
            case "sobjectsearch": 
            case "sObjectSearch": {
                return this.getOrCreateConfig(target).getSObjectSearch();
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                return target.getSslContextParameters();
            }
            case "streamqueryresult": 
            case "streamQueryResult": {
                return this.getOrCreateConfig(target).getStreamQueryResult();
            }
            case "updatetopic": 
            case "updateTopic": {
                return this.getOrCreateConfig(target).isUpdateTopic();
            }
            case "useglobalsslcontextparameters": 
            case "useGlobalSslContextParameters": {
                return target.isUseGlobalSslContextParameters();
            }
            case "username": 
            case "userName": {
                return target.getUserName();
            }
            case "workerpoolmaxsize": 
            case "workerPoolMaxSize": {
                return target.getWorkerPoolMaxSize();
            }
            case "workerpoolsize": 
            case "workerPoolSize": {
                return target.getWorkerPoolSize();
            }
        }
        return null;
    }

    @Override
    public Object getCollectionValueType(Object target, String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "apexqueryparams": 
            case "apexQueryParams": {
                return Object.class;
            }
            case "httpclientproperties": 
            case "httpClientProperties": {
                return Object.class;
            }
            case "httpproxyexcludedaddresses": 
            case "httpProxyExcludedAddresses": {
                return String.class;
            }
            case "httpproxyincludedaddresses": 
            case "httpProxyIncludedAddresses": {
                return String.class;
            }
            case "initialreplayidmap": 
            case "initialReplayIdMap": {
                return Long.class;
            }
            case "longpollingtransportproperties": 
            case "longPollingTransportProperties": {
                return Object.class;
            }
        }
        return null;
    }
}

