/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.api;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;

public class MultiSelectPicklistDeserializer
extends StdDeserializer<Object>
implements ContextualDeserializer {
    private static final long serialVersionUID = -4568286926393043366L;
    private static final String FACTORY_METHOD = "fromValue";
    private final Class<? extends Enum<?>> enumClass;
    private final Method factoryMethod;

    public MultiSelectPicklistDeserializer() {
        super(Object.class);
        this.factoryMethod = null;
        this.enumClass = null;
    }

    public MultiSelectPicklistDeserializer(JsonParser jp, Class<? extends Enum<?>> enumClass) throws JsonMappingException {
        super(enumClass);
        this.enumClass = enumClass;
        try {
            this.factoryMethod = enumClass.getMethod(FACTORY_METHOD, String.class);
        }
        catch (NoSuchMethodException e) {
            throw new JsonMappingException((Closeable)jp, "Invalid pick-list enum class " + enumClass.getName(), (Throwable)e);
        }
    }

    @Override
    public Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        if (this.enumClass == null) {
            throw new JsonMappingException(jp, "Unable to parse unknown pick-list type");
        }
        String listValue = jp.getText();
        try {
            String[] value = listValue.split(";");
            int length = value.length;
            Object resultArray = Array.newInstance(this.enumClass, length);
            for (int i = 0; i < length; ++i) {
                Array.set(resultArray, i, this.factoryMethod.invoke(null, value[i].trim()));
            }
            return resultArray;
        }
        catch (Exception e) {
            throw new JsonParseException(jp, "Exception reading multi-select pick list value", jp.getCurrentLocation());
        }
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext context, BeanProperty property) throws JsonMappingException {
        Class<?> rawClass = property.getType().getRawClass();
        Class<?> componentType = rawClass.getComponentType();
        if (componentType == null || !componentType.isEnum()) {
            throw new JsonMappingException(context.getParser(), "Pick list Enum array expected for " + rawClass);
        }
        return new MultiSelectPicklistDeserializer(context.getParser(), componentType);
    }
}

