/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.api.utils;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.AsPropertyTypeDeserializer;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import java.io.IOException;

public class AsNestedPropertyDeserializer
extends AsPropertyTypeDeserializer {
    public AsNestedPropertyDeserializer(JavaType bt, TypeIdResolver idRes, String typePropertyName, boolean typeIdVisible, JavaType defaultImpl, JsonTypeInfo.As inclusion) {
        super(bt, idRes, typePropertyName, typeIdVisible, defaultImpl, inclusion);
    }

    public AsNestedPropertyDeserializer(AsPropertyTypeDeserializer src, BeanProperty property) {
        super(src, property);
    }

    @Override
    public TypeDeserializer forProperty(BeanProperty prop) {
        return prop == this._property ? this : new AsNestedPropertyDeserializer(this, prop);
    }

    @Override
    public Object deserializeTypedFromObject(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode originalNode;
        JsonNode node = originalNode = (JsonNode)p.readValueAsTree();
        for (String property : this._typePropertyName.split("\\.")) {
            JsonNode nestedProperty = node.get(property);
            if (nestedProperty == null) {
                ctxt.reportInputMismatch(this._property, "Nested property not found in JSON: " + this._typePropertyName, new Object[0]);
                return null;
            }
            node = nestedProperty;
        }
        JsonDeserializer<Object> deser = this._findDeserializer(ctxt, node.asText());
        TreeTraversingParser jsonParser = new TreeTraversingParser(originalNode, p.getCodec());
        if (((JsonParser)jsonParser).getCurrentToken() == null) {
            ((JsonParser)jsonParser).nextToken();
        }
        return deser.deserialize(jsonParser, ctxt);
    }
}

