/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal.processor;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.salesforce.NotFoundBehaviour;
import org.apache.camel.component.salesforce.SalesforceComponent;
import org.apache.camel.component.salesforce.SalesforceEndpoint;
import org.apache.camel.component.salesforce.SalesforceEndpointConfig;
import org.apache.camel.component.salesforce.api.NoSuchSObjectException;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.api.dto.AbstractSObjectBase;
import org.apache.camel.component.salesforce.api.dto.approval.ApprovalRequest;
import org.apache.camel.component.salesforce.api.dto.approval.ApprovalRequests;
import org.apache.camel.component.salesforce.internal.client.RestClient;
import org.apache.camel.component.salesforce.internal.processor.AbstractSalesforceProcessor;
import org.apache.camel.component.salesforce.internal.processor.JsonRestProcessor;
import org.apache.camel.support.service.ServiceHelper;

public abstract class AbstractRestProcessor
extends AbstractSalesforceProcessor {
    protected static final String RESPONSE_CLASS = AbstractRestProcessor.class.getName() + ".responseClass";
    protected static final String RESPONSE_CLASS_DEFERRED = AbstractRestProcessor.class.getName() + ".responseClassDeferred";
    protected static final String RESPONSE_CLASS_PREFIX = AbstractRestProcessor.class.getName() + ".responseClassPrefix";
    protected static final String RESPONSE_TYPE = JsonRestProcessor.class.getName() + ".responseType";
    private static final Pattern URL_TEMPLATE = Pattern.compile("\\{([^\\{\\}]+)\\}");
    protected RestClient restClient;
    private NotFoundBehaviour notFoundBehaviour;

    AbstractRestProcessor(SalesforceEndpoint endpoint, RestClient restClient, Map<String, Class<?>> classMap) {
        super(endpoint);
        this.restClient = restClient;
        this.classMap = classMap;
        SalesforceEndpointConfig configuration = endpoint.getConfiguration();
        this.notFoundBehaviour = configuration.getNotFoundBehaviour();
    }

    public AbstractRestProcessor(SalesforceEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        SalesforceEndpointConfig configuration = this.endpoint.getConfiguration();
        this.notFoundBehaviour = configuration.getNotFoundBehaviour();
        SalesforceComponent salesforceComponent = this.endpoint.getComponent();
        if (this.restClient == null) {
            this.restClient = salesforceComponent.createRestClientFor(this.endpoint);
        }
        ServiceHelper.startService((Object)this.restClient);
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopService((Object)this.restClient);
    }

    @Override
    public final boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            this.processRequest(exchange);
        }
        catch (SalesforceException e) {
            exchange.setException(e);
            callback.done(true);
            return true;
        }
        catch (RuntimeException e) {
            exchange.setException(new SalesforceException(e.getMessage(), e));
            callback.done(true);
            return true;
        }
        try {
            switch (this.operationName) {
                case GET_VERSIONS: {
                    this.processGetVersions(exchange, callback);
                    break;
                }
                case GET_RESOURCES: {
                    this.processGetResources(exchange, callback);
                    break;
                }
                case GET_GLOBAL_OBJECTS: {
                    this.processGetGlobalObjects(exchange, callback);
                    break;
                }
                case GET_BASIC_INFO: {
                    this.processGetBasicInfo(exchange, callback);
                    break;
                }
                case GET_DESCRIPTION: {
                    this.processGetDescription(exchange, callback);
                    break;
                }
                case GET_SOBJECT: {
                    this.processGetSobject(exchange, callback);
                    break;
                }
                case CREATE_SOBJECT: {
                    this.processCreateSobject(exchange, callback);
                    break;
                }
                case UPDATE_SOBJECT: {
                    this.processUpdateSobject(exchange, callback);
                    break;
                }
                case DELETE_SOBJECT: {
                    this.processDeleteSobject(exchange, callback);
                    break;
                }
                case GET_SOBJECT_WITH_ID: {
                    this.processGetSobjectWithId(exchange, callback);
                    break;
                }
                case UPSERT_SOBJECT: {
                    this.processUpsertSobject(exchange, callback);
                    break;
                }
                case DELETE_SOBJECT_WITH_ID: {
                    this.processDeleteSobjectWithId(exchange, callback);
                    break;
                }
                case GET_BLOB_FIELD: {
                    this.processGetBlobField(exchange, callback);
                    break;
                }
                case QUERY: {
                    this.processQuery(exchange, callback);
                    break;
                }
                case QUERY_MORE: {
                    this.processQueryMore(exchange, callback);
                    break;
                }
                case QUERY_ALL: {
                    this.processQueryAll(exchange, callback);
                    break;
                }
                case SEARCH: {
                    this.processSearch(exchange, callback);
                    break;
                }
                case APEX_CALL: {
                    this.processApexCall(exchange, callback);
                    break;
                }
                case RECENT: {
                    this.processRecent(exchange, callback);
                    break;
                }
                case LIMITS: {
                    this.processLimits(exchange, callback);
                    break;
                }
                case APPROVAL: {
                    this.processApproval(exchange, callback);
                    break;
                }
                case APPROVALS: {
                    this.processApprovals(exchange, callback);
                    break;
                }
                default: {
                    throw new SalesforceException("Unknown operation name: " + this.operationName.value(), null);
                }
            }
        }
        catch (SalesforceException e) {
            exchange.setException(new SalesforceException(String.format("Error processing %s: [%s] \"%s\"", this.operationName.value(), e.getStatusCode(), e.getMessage()), e));
            callback.done(true);
            return true;
        }
        catch (RuntimeException e) {
            exchange.setException(new SalesforceException(String.format("Unexpected Error processing %s: \"%s\"", this.operationName.value(), e.getMessage()), e));
            callback.done(true);
            return true;
        }
        return false;
    }

    final void processApproval(Exchange exchange, AsyncCallback callback) throws SalesforceException {
        ApprovalRequests requestsBody;
        boolean nothingInBody;
        TypeConverter converter = exchange.getContext().getTypeConverter();
        ApprovalRequest approvalRequestFromHeader = this.getParameter("approval", exchange, false, true, ApprovalRequest.class);
        boolean requestGivenInHeader = approvalRequestFromHeader != null;
        ApprovalRequest approvalHeader = Optional.ofNullable(approvalRequestFromHeader).orElse(new ApprovalRequest());
        Message incomingMessage = exchange.getIn();
        Map<String, Object> incomingHeaders = incomingMessage.getHeaders();
        boolean requestGivenInParametersInHeader = this.processApprovalHeaderValues(approvalHeader, incomingHeaders);
        boolean nothingInHeader = !requestGivenInHeader && !requestGivenInParametersInHeader;
        Object approvalBody = incomingMessage.getBody();
        boolean bodyIsIterable = approvalBody instanceof Iterable;
        boolean bodyIsIterableButEmpty = bodyIsIterable && !((Iterable)approvalBody).iterator().hasNext();
        boolean bl = nothingInBody = approvalBody == null || bodyIsIterableButEmpty;
        if (nothingInHeader && nothingInBody) {
            throw new SalesforceException("Missing approval parameter in header or ApprovalRequest or List of ApprovalRequests body", 0);
        }
        if (nothingInBody) {
            requestsBody = new ApprovalRequests(approvalHeader);
        } else if (bodyIsIterable) {
            Iterable approvalRequests = (Iterable)approvalBody;
            List<ApprovalRequest> requests = StreamSupport.stream(approvalRequests.spliterator(), false).map(value -> converter.convertTo(ApprovalRequest.class, value)).map(request -> request.applyTemplate(approvalHeader)).collect(Collectors.toList());
            requestsBody = new ApprovalRequests(requests);
        } else {
            ApprovalRequest given = converter.tryConvertTo(ApprovalRequest.class, approvalBody);
            ApprovalRequest request2 = Optional.ofNullable(given).orElse(new ApprovalRequest()).applyTemplate(approvalHeader);
            requestsBody = new ApprovalRequests(request2);
        }
        InputStream request3 = this.getRequestStream(incomingMessage, requestsBody);
        this.restClient.approval(request3, this.determineHeaders(exchange), this.processWithResponseCallback(exchange, callback));
    }

    final boolean processApprovalHeaderValues(ApprovalRequest approvalRequest, Map<String, Object> incomingHeaderValues) {
        return incomingHeaderValues.entrySet().stream().filter(kv -> ((String)kv.getKey()).startsWith("approval.")).map(kv -> {
            String property = ((String)kv.getKey()).substring(9);
            Object value = kv.getValue();
            if (value != null) {
                try {
                    this.setPropertyValue(approvalRequest, property, value);
                    return true;
                }
                catch (SalesforceException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            return false;
        }).reduce(false, (a, b) -> a != false || b != false);
    }

    private void processApprovals(Exchange exchange, AsyncCallback callback) {
        this.restClient.approvals(this.determineHeaders(exchange), this.processWithResponseCallback(exchange, callback));
    }

    private void processGetVersions(Exchange exchange, AsyncCallback callback) {
        this.restClient.getVersions(this.determineHeaders(exchange), this.processWithResponseCallback(exchange, callback));
    }

    private void processGetResources(Exchange exchange, AsyncCallback callback) {
        this.restClient.getResources(this.determineHeaders(exchange), this.processWithResponseCallback(exchange, callback));
    }

    private void processGetGlobalObjects(Exchange exchange, AsyncCallback callback) {
        this.restClient.getGlobalObjects(this.determineHeaders(exchange), this.processWithResponseCallback(exchange, callback));
    }

    private void processGetBasicInfo(Exchange exchange, AsyncCallback callback) throws SalesforceException {
        String sObjectName = this.getParameter("sObjectName", exchange, true, false);
        this.restClient.getBasicInfo(sObjectName, this.determineHeaders(exchange), this.processWithResponseCallback(exchange, callback));
    }

    private void processGetDescription(Exchange exchange, AsyncCallback callback) throws SalesforceException {
        String sObjectName = this.getParameter("sObjectName", exchange, true, false);
        this.restClient.getDescription(sObjectName, this.determineHeaders(exchange), this.processWithResponseCallback(exchange, callback));
    }

    private void processGetSobject(Exchange exchange, AsyncCallback callback) throws SalesforceException {
        String sObjectName = this.determineSObjectName(exchange);
        String sObjectId = this.determineSObjectId(exchange);
        this.setResponseClass(exchange);
        String fieldsValue = this.getParameter("sObjectFields", exchange, false, true);
        String[] fields = null;
        if (fieldsValue != null) {
            fields = fieldsValue.split(",");
        }
        this.restClient.getSObject(sObjectName, sObjectId, fields, this.determineHeaders(exchange), this.processWithResponseCallback(exchange, callback));
    }

    private void processCreateSobject(Exchange exchange, AsyncCallback callback) throws SalesforceException {
        String sObjectName = this.determineSObjectName(exchange);
        this.restClient.createSObject(sObjectName, this.getRequestStream(exchange), this.determineHeaders(exchange), this.processWithResponseCallback(exchange, callback));
    }

    private void processUpdateSobject(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String sObjectName = this.determineSObjectName(exchange);
        String sObjectId = this.determineSObjectId(exchange);
        final AbstractSObjectBase sObjectBase = exchange.getIn().getBody(AbstractSObjectBase.class);
        if (sObjectBase != null) {
            sObjectBase.clearBaseFields();
        }
        final String finalsObjectId = sObjectId;
        this.restClient.updateSObject(sObjectName, sObjectId, this.getRequestStream(exchange), this.determineHeaders(exchange), new RestClient.ResponseCallback(){

            @Override
            public void onResponse(InputStream response, Map<String, String> headers, SalesforceException exception) {
                AbstractRestProcessor.this.restoreFields(exchange, sObjectBase, finalsObjectId, null, null);
                AbstractRestProcessor.this.processResponse(exchange, response, headers, exception, callback);
            }
        });
    }

    private void processDeleteSobject(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String sObjectName = this.determineSObjectName(exchange);
        final String sObjectId = this.determineSObjectId(exchange);
        final AbstractSObjectBase sObjectBase = exchange.getIn().getBody(AbstractSObjectBase.class);
        this.restClient.deleteSObject(sObjectName, sObjectId, this.determineHeaders(exchange), new RestClient.ResponseCallback(){

            @Override
            public void onResponse(InputStream response, Map<String, String> headers, SalesforceException exception) {
                AbstractRestProcessor.this.restoreFields(exchange, sObjectBase, sObjectId, null, null);
                AbstractRestProcessor.this.processResponse(exchange, response, headers, exception, callback);
            }
        });
    }

    private void processGetSobjectWithId(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String sObjectExtIdValue;
        String sObjectName = this.determineSObjectName(exchange);
        Object oldValue = null;
        final String sObjectExtIdName = this.getParameter("sObjectIdName", exchange, false, false);
        final AbstractSObjectBase sObjectBase = exchange.getIn().getBody(AbstractSObjectBase.class);
        if (sObjectBase != null) {
            oldValue = this.getAndClearPropertyValue(sObjectBase, sObjectExtIdName);
            sObjectExtIdValue = oldValue.toString();
        } else {
            sObjectExtIdValue = this.getParameter("sObjectIdValue", exchange, true, false);
        }
        this.setResponseClass(exchange);
        final Object finalOldValue = oldValue;
        this.restClient.getSObjectWithId(sObjectName, sObjectExtIdName, sObjectExtIdValue, this.determineHeaders(exchange), new RestClient.ResponseCallback(){

            @Override
            public void onResponse(InputStream response, Map<String, String> headers, SalesforceException exception) {
                AbstractRestProcessor.this.restoreFields(exchange, sObjectBase, null, sObjectExtIdName, finalOldValue);
                AbstractRestProcessor.this.processResponse(exchange, response, headers, exception, callback);
            }
        });
    }

    private void processUpsertSobject(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String sObjectExtIdValue;
        String sObjectName = this.determineSObjectName(exchange);
        final String sObjectExtIdName = this.getParameter("sObjectIdName", exchange, false, false);
        Object oldValue = null;
        final AbstractSObjectBase sObjectBase = exchange.getIn().getBody(AbstractSObjectBase.class);
        if (sObjectBase != null) {
            oldValue = this.getAndClearPropertyValue(sObjectBase, sObjectExtIdName);
            sObjectExtIdValue = oldValue.toString();
            sObjectBase.clearBaseFields();
        } else {
            sObjectExtIdValue = this.getParameter("sObjectIdValue", exchange, false, false);
        }
        final Object finalOldValue = oldValue;
        this.restClient.upsertSObject(sObjectName, sObjectExtIdName, sObjectExtIdValue, this.determineHeaders(exchange), this.getRequestStream(exchange), new RestClient.ResponseCallback(){

            @Override
            public void onResponse(InputStream response, Map<String, String> headers, SalesforceException exception) {
                AbstractRestProcessor.this.restoreFields(exchange, sObjectBase, null, sObjectExtIdName, finalOldValue);
                AbstractRestProcessor.this.processResponse(exchange, response, headers, exception, callback);
            }
        });
    }

    private void processDeleteSobjectWithId(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String sObjectExtIdValue;
        String sObjectName = this.determineSObjectName(exchange);
        final String sObjectExtIdName = this.getParameter("sObjectIdName", exchange, false, false);
        Object oldValue = null;
        final AbstractSObjectBase sObjectBase = exchange.getIn().getBody(AbstractSObjectBase.class);
        if (sObjectBase != null) {
            oldValue = this.getAndClearPropertyValue(sObjectBase, sObjectExtIdName);
            sObjectExtIdValue = oldValue.toString();
        } else {
            sObjectExtIdValue = this.getParameter("sObjectIdValue", exchange, true, false);
        }
        final Object finalOldValue = oldValue;
        this.restClient.deleteSObjectWithId(sObjectName, sObjectExtIdName, sObjectExtIdValue, this.determineHeaders(exchange), new RestClient.ResponseCallback(){

            @Override
            public void onResponse(InputStream response, Map<String, String> headers, SalesforceException exception) {
                AbstractRestProcessor.this.processResponse(exchange, response, headers, exception, callback);
                AbstractRestProcessor.this.restoreFields(exchange, sObjectBase, null, sObjectExtIdName, finalOldValue);
            }
        });
    }

    private void processGetBlobField(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String sObjectName = this.determineSObjectName(exchange);
        String sObjectBlobFieldName = this.getParameter("sObjectBlobFieldName", exchange, false, false);
        final AbstractSObjectBase sObjectBase = exchange.getIn().getBody(AbstractSObjectBase.class);
        final String sObjectId = this.determineSObjectId(exchange);
        this.restClient.getBlobField(sObjectName, sObjectId, sObjectBlobFieldName, this.determineHeaders(exchange), new RestClient.ResponseCallback(){

            @Override
            public void onResponse(InputStream response, Map<String, String> headers, SalesforceException exception) {
                AbstractRestProcessor.this.restoreFields(exchange, sObjectBase, sObjectId, null, null);
                AbstractRestProcessor.this.processResponse(exchange, response, headers, exception, callback);
            }
        });
    }

    private void processQuery(Exchange exchange, AsyncCallback callback) throws SalesforceException {
        String sObjectQuery = this.getParameter("sObjectQuery", exchange, true, false);
        boolean streamQueryResults = this.getParameter("streamQueryResult", exchange, false, true, Boolean.class);
        this.setResponseClass(exchange);
        exchange.setProperty(RESPONSE_CLASS_PREFIX, (Object)"QueryRecords");
        if (streamQueryResults) {
            this.restClient.query(sObjectQuery, this.determineHeaders(exchange), this.processWithStreamResultCallback(exchange, callback));
        } else {
            this.restClient.query(sObjectQuery, this.determineHeaders(exchange), this.processWithResponseCallback(exchange, callback));
        }
    }

    private void processQueryMore(Exchange exchange, AsyncCallback callback) throws SalesforceException {
        String nextRecordsUrl = this.getParameter("sObjectQuery", exchange, true, false);
        this.setResponseClass(exchange);
        exchange.setProperty(RESPONSE_CLASS_PREFIX, (Object)"QueryRecords");
        this.restClient.queryMore(nextRecordsUrl, this.determineHeaders(exchange), this.processWithResponseCallback(exchange, callback));
    }

    private void processQueryAll(Exchange exchange, AsyncCallback callback) throws SalesforceException {
        String sObjectQuery = this.getParameter("sObjectQuery", exchange, true, false);
        boolean streamQueryResults = this.getParameter("streamQueryResult", exchange, false, true, Boolean.class);
        this.setResponseClass(exchange);
        exchange.setProperty(RESPONSE_CLASS_PREFIX, (Object)"QueryRecords");
        if (streamQueryResults) {
            this.restClient.queryAll(sObjectQuery, this.determineHeaders(exchange), this.processWithStreamResultCallback(exchange, callback));
        } else {
            this.restClient.queryAll(sObjectQuery, this.determineHeaders(exchange), this.processWithResponseCallback(exchange, callback));
        }
    }

    private void processSearch(Exchange exchange, AsyncCallback callback) throws SalesforceException {
        String sObjectSearch = this.getParameter("sObjectSearch", exchange, true, false);
        this.restClient.search(sObjectSearch, this.determineHeaders(exchange), this.processWithResponseCallback(exchange, callback));
    }

    private void processApexCall(Exchange exchange, AsyncCallback callback) throws SalesforceException {
        String apexUrl = this.getApexUrl(exchange);
        String apexMethod = this.getParameter("apexMethod", exchange, false, true);
        if (apexMethod == null) {
            apexMethod = "GET";
            this.log.debug("Using HTTP GET method by default for APEX REST call for {}", (Object)apexUrl);
        }
        Map<String, Object> queryParams = this.getQueryParams(exchange);
        this.setResponseClass(exchange);
        Object requestBody = exchange.getIn().getBody();
        InputStream requestDto = requestBody != null && !(requestBody instanceof Map) ? this.getRequestStream(exchange) : null;
        this.restClient.apexCall(apexMethod, apexUrl, queryParams, requestDto, this.determineHeaders(exchange), this.processWithResponseCallback(exchange, callback));
    }

    private String getApexUrl(Exchange exchange) throws SalesforceException {
        String apexUrl = this.getParameter("apexUrl", exchange, false, false);
        Matcher matcher = URL_TEMPLATE.matcher(apexUrl);
        StringBuilder result = new StringBuilder();
        int start = 0;
        while (matcher.find()) {
            result.append(apexUrl, start, matcher.start());
            start = matcher.end();
            String parameterName = matcher.group(1);
            Object value = exchange.getIn().getHeader(parameterName);
            if (value == null) {
                throw new IllegalArgumentException("Missing APEX URL template header " + parameterName);
            }
            try {
                result.append(URLEncoder.encode(String.valueOf(value), "UTF-8").replace("+", "%20"));
            }
            catch (UnsupportedEncodingException e) {
                throw new SalesforceException("Unexpected error: " + e.getMessage(), e);
            }
        }
        if (start != 0) {
            result.append(apexUrl, start, apexUrl.length());
            String resolvedUrl = result.toString();
            this.log.debug("Resolved APEX URL {} to {}", (Object)apexUrl, (Object)resolvedUrl);
            return resolvedUrl;
        }
        return apexUrl;
    }

    private void processRecent(Exchange exchange, AsyncCallback callback) throws SalesforceException {
        Integer limit = this.getParameter("limit", exchange, true, true, Integer.class);
        this.restClient.recent(limit, this.determineHeaders(exchange), this.processWithResponseCallback(exchange, callback));
    }

    private void processLimits(Exchange exchange, AsyncCallback callback) {
        this.restClient.limits(this.determineHeaders(exchange), this.processWithResponseCallback(exchange, callback));
    }

    private String determineSObjectName(Exchange exchange) throws SalesforceException {
        String sObjectName = this.getParameter("sObjectName", exchange, false, true);
        if (sObjectName == null) {
            AbstractSObjectBase sObjectBase = exchange.getIn().getBody(AbstractSObjectBase.class);
            if (sObjectBase != null) {
                sObjectName = sObjectBase.getClass().getSimpleName();
            } else {
                throw new IllegalArgumentException("Unable to determine sObject name. Body must be of AbstractSObjectBase (base class of generated DTOs) or sObjectName option must be supplied.");
            }
        }
        return sObjectName;
    }

    private String determineSObjectId(Exchange exchange) throws SalesforceException {
        AbstractSObjectBase sObjectBase = exchange.getIn().getBody(AbstractSObjectBase.class);
        String sObjectIdValue = sObjectBase != null ? sObjectBase.getId() : this.getParameter("sObjectId", exchange, true, false);
        return sObjectIdValue;
    }

    private Map<String, Object> getQueryParams(Exchange exchange) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>(this.endpoint.getConfiguration().getApexQueryParams());
        for (Map.Entry<String, Object> entry : exchange.getIn().getHeaders().entrySet()) {
            if (!entry.getKey().startsWith("apexQueryParam.")) continue;
            queryParams.put(entry.getKey().substring("apexQueryParam.".length()), entry.getValue());
        }
        Object body = exchange.getIn().getBody();
        if (body instanceof Map) {
            queryParams.putAll((Map)body);
        }
        this.log.debug("Using APEX query params {}", queryParams);
        return queryParams;
    }

    private void restoreFields(Exchange exchange, AbstractSObjectBase sObjectBase, String sObjectId, String sObjectExtIdName, Object oldValue) {
        if (sObjectBase != null) {
            if (sObjectId != null) {
                sObjectBase.setId(sObjectId);
            }
            if (sObjectExtIdName != null && oldValue != null) {
                try {
                    this.setPropertyValue(sObjectBase, sObjectExtIdName, oldValue);
                }
                catch (SalesforceException e) {
                    exchange.setException(e);
                }
            }
        }
    }

    private void setPropertyValue(Object sObjectBase, String name, Object value) throws SalesforceException {
        try {
            Method setMethod = sObjectBase.getClass().getMethod("set" + name, value.getClass());
            setMethod.invoke(sObjectBase, value);
        }
        catch (NoSuchMethodException e) {
            throw new SalesforceException(String.format("SObject %s does not have a field %s", sObjectBase.getClass().getName(), name), e);
        }
        catch (InvocationTargetException e) {
            throw new SalesforceException(String.format("Error setting value %s.%s", sObjectBase.getClass().getSimpleName(), name), e);
        }
        catch (IllegalAccessException e) {
            throw new SalesforceException(String.format("Error accessing value %s.%s", sObjectBase.getClass().getSimpleName(), name), e);
        }
    }

    private Object getAndClearPropertyValue(AbstractSObjectBase sObjectBase, String propertyName) throws SalesforceException {
        try {
            Method getMethod = sObjectBase.getClass().getMethod("get" + propertyName, new Class[0]);
            Object value = getMethod.invoke((Object)sObjectBase, new Object[0]);
            Method setMethod = sObjectBase.getClass().getMethod("set" + propertyName, getMethod.getReturnType());
            setMethod.invoke((Object)sObjectBase, new Object[]{null});
            return value;
        }
        catch (NoSuchMethodException e) {
            throw new SalesforceException(String.format("SObject %s does not have a field %s", sObjectBase.getClass().getSimpleName(), propertyName), e);
        }
        catch (InvocationTargetException e) {
            throw new SalesforceException(String.format("Error getting/setting value %s.%s", sObjectBase.getClass().getSimpleName(), propertyName), e);
        }
        catch (IllegalAccessException e) {
            throw new SalesforceException(String.format("Error accessing value %s.%s", sObjectBase.getClass().getSimpleName(), propertyName), e);
        }
    }

    protected abstract void processRequest(Exchange var1) throws SalesforceException;

    protected abstract InputStream getRequestStream(Exchange var1) throws SalesforceException;

    protected abstract InputStream getRequestStream(Message var1, Object var2) throws SalesforceException;

    protected void setResponseClass(Exchange exchange) throws SalesforceException {
        if (this.rawPayload) {
            return;
        }
        Class<?> sObjectClass = this.getSObjectClass(exchange);
        if (sObjectClass != null) {
            exchange.setProperty(RESPONSE_CLASS, sObjectClass);
        } else {
            exchange.setProperty(RESPONSE_CLASS_DEFERRED, (Object)true);
        }
    }

    final RestClient.ResponseCallback processWithResponseCallback(Exchange exchange, AsyncCallback callback) {
        return (response, headers, exception) -> this.processResponse(exchange, response, headers, exception, callback);
    }

    final RestClient.ResponseCallback processWithStreamResultCallback(Exchange exchange, AsyncCallback callback) {
        return (response, headers, exception) -> this.processStreamResultResponse(exchange, response, headers, exception, callback);
    }

    protected abstract void processResponse(Exchange var1, InputStream var2, Map<String, String> var3, SalesforceException var4, AsyncCallback var5);

    protected abstract void processStreamResultResponse(Exchange var1, InputStream var2, Map<String, String> var3, SalesforceException var4, AsyncCallback var5);

    final boolean shouldReport(SalesforceException ex) {
        return !(ex instanceof NoSuchSObjectException) || this.notFoundBehaviour != NotFoundBehaviour.NULL;
    }
}

