/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal.streaming;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelException;
import org.apache.camel.component.salesforce.SalesforceEndpointConfig;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.api.dto.CreateSObjectResult;
import org.apache.camel.component.salesforce.api.utils.JsonUtils;
import org.apache.camel.component.salesforce.internal.client.RestClient;
import org.apache.camel.component.salesforce.internal.client.SyncResponseCallback;
import org.apache.camel.component.salesforce.internal.dto.PushTopic;
import org.apache.camel.component.salesforce.internal.dto.QueryRecordsPushTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushTopicHelper {
    private static final Logger LOG = LoggerFactory.getLogger(PushTopicHelper.class);
    private static final ObjectMapper OBJECT_MAPPER = JsonUtils.createObjectMapper();
    private static final String PUSH_TOPIC_OBJECT_NAME = "PushTopic";
    private static final long API_TIMEOUT = 60L;
    private final SalesforceEndpointConfig config;
    private final String topicName;
    private final RestClient restClient;
    private final boolean preApi29;

    public PushTopicHelper(SalesforceEndpointConfig config, String topicName, RestClient restClient) {
        this.config = config;
        this.topicName = topicName;
        this.restClient = restClient;
        boolean bl = this.preApi29 = Double.valueOf(config.getApiVersion()) < 29.0;
        if (this.preApi29 && (config.getNotifyForOperationCreate() != null || config.getNotifyForOperationDelete() != null || config.getNotifyForOperationUndelete() != null || config.getNotifyForOperationUpdate() != null)) {
            throw new IllegalArgumentException("NotifyForOperationCreate, NotifyForOperationDelete, NotifyForOperationUndelete, and NotifyForOperationUpdate are only supported since API version 29.0, instead use NotifyForOperations");
        }
        if (!this.preApi29 && config.getNotifyForOperations() != null) {
            throw new IllegalArgumentException("NotifyForOperations is readonly since API version 29.0, instead use NotifyForOperationCreate, NotifyForOperationDelete, NotifyForOperationUndelete, and NotifyForOperationUpdate");
        }
    }

    public void createOrUpdateTopic() throws CamelException {
        String query = this.config.getSObjectQuery();
        SyncResponseCallback callback = new SyncResponseCallback();
        try {
            this.restClient.query("SELECT Id, Name, Query, ApiVersion, IsActive, NotifyForFields, NotifyForOperations, NotifyForOperationCreate, NotifyForOperationDelete, NotifyForOperationUndelete, NotifyForOperationUpdate, Description FROM PushTopic WHERE Name = '" + this.topicName + "'", Collections.emptyMap(), callback);
            if (!callback.await(60L, TimeUnit.SECONDS)) {
                throw new SalesforceException("API call timeout!", null);
            }
            SalesforceException callbackException = callback.getException();
            if (callbackException != null) {
                throw callbackException;
            }
            QueryRecordsPushTopic records = OBJECT_MAPPER.readValue(callback.getResponse(), QueryRecordsPushTopic.class);
            if (records.getTotalSize() == 1) {
                boolean notifyOperationsChanged;
                PushTopic topic = (PushTopic)records.getRecords().get(0);
                LOG.info("Found existing topic {}: {}", (Object)this.topicName, (Object)topic);
                if (this.preApi29) {
                    notifyOperationsChanged = PushTopicHelper.notEquals(this.config.getNotifyForOperations(), topic.getNotifyForOperations());
                } else {
                    boolean bl = notifyOperationsChanged = PushTopicHelper.notEquals(this.config.getNotifyForOperationCreate(), topic.getNotifyForOperationCreate()) || PushTopicHelper.notEquals(this.config.getNotifyForOperationDelete(), topic.getNotifyForOperationDelete()) || PushTopicHelper.notEquals(this.config.getNotifyForOperationUndelete(), topic.getNotifyForOperationUndelete()) || PushTopicHelper.notEquals(this.config.getNotifyForOperationUpdate(), topic.getNotifyForOperationUpdate());
                }
                if (!query.equals(topic.getQuery()) || PushTopicHelper.notEquals(this.config.getNotifyForFields(), topic.getNotifyForFields()) || notifyOperationsChanged) {
                    if (!this.config.isUpdateTopic()) {
                        String msg = "Query doesn't match existing Topic and updateTopic is set to false";
                        throw new CamelException(msg);
                    }
                    this.updateTopic(topic.getId());
                }
            } else {
                this.createTopic();
            }
        }
        catch (SalesforceException e) {
            throw new CamelException(String.format("Error retrieving Topic %s: %s", this.topicName, e.getMessage()), e);
        }
        catch (IOException e) {
            throw new CamelException(String.format("Un-marshaling error retrieving Topic %s: %s", this.topicName, e.getMessage()), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CamelException(String.format("Un-marshaling error retrieving Topic %s: %s", this.topicName, e.getMessage()), e);
        }
        finally {
            if (callback.getResponse() != null) {
                try {
                    callback.getResponse().close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void createTopic() throws CamelException {
        PushTopic topic = new PushTopic();
        topic.setName(this.topicName);
        topic.setApiVersion(Double.valueOf(this.config.getApiVersion()));
        topic.setQuery(this.config.getSObjectQuery());
        topic.setDescription("Topic created by Camel Salesforce component");
        topic.setNotifyForFields(this.config.getNotifyForFields());
        if (this.preApi29) {
            topic.setNotifyForOperations(this.config.getNotifyForOperations());
        } else {
            topic.setNotifyForOperationCreate(this.config.getNotifyForOperationCreate());
            topic.setNotifyForOperationDelete(this.config.getNotifyForOperationDelete());
            topic.setNotifyForOperationUndelete(this.config.getNotifyForOperationUndelete());
            topic.setNotifyForOperationUpdate(this.config.getNotifyForOperationUpdate());
        }
        LOG.info("Creating Topic {}: {}", (Object)this.topicName, (Object)topic);
        SyncResponseCallback callback = new SyncResponseCallback();
        try {
            this.restClient.createSObject(PUSH_TOPIC_OBJECT_NAME, new ByteArrayInputStream(OBJECT_MAPPER.writeValueAsBytes(topic)), Collections.emptyMap(), callback);
            if (!callback.await(60L, TimeUnit.SECONDS)) {
                throw new SalesforceException("API call timeout!", null);
            }
            SalesforceException callbackException = callback.getException();
            if (callbackException != null) {
                throw callbackException;
            }
            CreateSObjectResult result = OBJECT_MAPPER.readValue(callback.getResponse(), CreateSObjectResult.class);
            if (!result.getSuccess().booleanValue()) {
                SalesforceException salesforceException = new SalesforceException(result.getErrors(), 400);
                throw new CamelException(String.format("Error creating Topic %s: %s", this.topicName, result.getErrors()), salesforceException);
            }
        }
        catch (SalesforceException e) {
            throw new CamelException(String.format("Error creating Topic %s: %s", this.topicName, e.getMessage()), e);
        }
        catch (IOException e) {
            throw new CamelException(String.format("Un-marshaling error creating Topic %s: %s", this.topicName, e.getMessage()), e);
        }
        catch (InterruptedException e) {
            throw new CamelException(String.format("Un-marshaling error creating Topic %s: %s", this.topicName, e.getMessage()), e);
        }
        finally {
            if (callback.getResponse() != null) {
                try {
                    callback.getResponse().close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void updateTopic(String topicId) throws CamelException {
        String query = this.config.getSObjectQuery();
        LOG.info("Updating Topic {} with Query [{}]", (Object)this.topicName, (Object)query);
        SyncResponseCallback callback = new SyncResponseCallback();
        try {
            PushTopic topic = new PushTopic();
            topic.setQuery(query);
            topic.setNotifyForFields(this.config.getNotifyForFields());
            if (this.preApi29) {
                topic.setNotifyForOperations(this.config.getNotifyForOperations());
            } else {
                topic.setNotifyForOperationCreate(this.config.getNotifyForOperationCreate());
                topic.setNotifyForOperationDelete(this.config.getNotifyForOperationDelete());
                topic.setNotifyForOperationUndelete(this.config.getNotifyForOperationUndelete());
                topic.setNotifyForOperationUpdate(this.config.getNotifyForOperationUpdate());
            }
            this.restClient.updateSObject(PUSH_TOPIC_OBJECT_NAME, topicId, new ByteArrayInputStream(OBJECT_MAPPER.writeValueAsBytes(topic)), Collections.emptyMap(), callback);
            if (!callback.await(60L, TimeUnit.SECONDS)) {
                throw new SalesforceException("API call timeout!", null);
            }
            SalesforceException callbackException = callback.getException();
            if (callbackException != null) {
                throw callbackException;
            }
        }
        catch (SalesforceException e) {
            throw new CamelException(String.format("Error updating topic %s with query [%s] : %s", this.topicName, query, e.getMessage()), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CamelException(String.format("Error updating topic %s with query [%s] : %s", this.topicName, query, e.getMessage()), e);
        }
        catch (IOException e) {
            throw new CamelException(String.format("Error updating topic %s with query [%s] : %s", this.topicName, query, e.getMessage()), e);
        }
        finally {
            if (callback.getResponse() != null) {
                try {
                    callback.getResponse().close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static <T> boolean notEquals(T o1, T o2) {
        return o1 != null && !o1.equals(o2);
    }
}

