/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.jsonSchema.jakarta.validation;

import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.module.jsonSchema.jakarta.validation.ValidationConstraintResolver;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;

public class AnnotationConstraintResolver
extends ValidationConstraintResolver {
    private Integer getMaxSize(BeanProperty prop) {
        int value;
        Size ann = this.getSizeAnnotation(prop);
        if (ann != null && (value = ann.max()) != Integer.MAX_VALUE) {
            return value;
        }
        return null;
    }

    private Integer getMinSize(BeanProperty prop) {
        int value;
        Size ann = this.getSizeAnnotation(prop);
        if (ann != null && (value = ann.min()) != 0) {
            return value;
        }
        return null;
    }

    @Override
    public Integer getArrayMaxItems(BeanProperty prop) {
        return this.getMaxSize(prop);
    }

    @Override
    public Integer getArrayMinItems(BeanProperty prop) {
        return this.getMinSize(prop);
    }

    @Override
    public Double getNumberMaximum(BeanProperty prop) {
        Max maxAnnotation = prop.getAnnotation(Max.class);
        if (maxAnnotation != null) {
            return maxAnnotation.value();
        }
        DecimalMax decimalMaxAnnotation = prop.getAnnotation(DecimalMax.class);
        return decimalMaxAnnotation != null ? Double.valueOf(new BigDecimal(decimalMaxAnnotation.value()).doubleValue()) : null;
    }

    @Override
    public Double getNumberMinimum(BeanProperty prop) {
        Min minAnnotation = prop.getAnnotation(Min.class);
        if (minAnnotation != null) {
            return minAnnotation.value();
        }
        DecimalMin decimalMinAnnotation = prop.getAnnotation(DecimalMin.class);
        return decimalMinAnnotation != null ? Double.valueOf(new BigDecimal(decimalMinAnnotation.value()).doubleValue()) : null;
    }

    @Override
    public Integer getStringMaxLength(BeanProperty prop) {
        return this.getMaxSize(prop);
    }

    @Override
    public Integer getStringMinLength(BeanProperty prop) {
        return this.getMinSize(prop);
    }

    @Override
    public String getStringPattern(BeanProperty prop) {
        Pattern patternAnnotation = prop.getAnnotation(Pattern.class);
        if (patternAnnotation != null) {
            return patternAnnotation.regexp();
        }
        return null;
    }

    @Override
    public Boolean getRequired(BeanProperty prop) {
        NotNull notNull = prop.getAnnotation(NotNull.class);
        return notNull != null ? Boolean.valueOf(true) : null;
    }

    private Size getSizeAnnotation(BeanProperty prop) {
        return prop.getAnnotation(Size.class);
    }
}

