/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.eventbus.protobuf;

import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import com.salesforce.eventbus.protobuf.FetchRequestOrBuilder;
import com.salesforce.eventbus.protobuf.PubSubProto;
import com.salesforce.eventbus.protobuf.ReplayPreset;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class FetchRequest
extends GeneratedMessageV3
implements FetchRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int TOPIC_NAME_FIELD_NUMBER = 1;
    private volatile Object topicName_ = "";
    public static final int REPLAY_PRESET_FIELD_NUMBER = 2;
    private int replayPreset_ = 0;
    public static final int REPLAY_ID_FIELD_NUMBER = 3;
    private ByteString replayId_ = ByteString.EMPTY;
    public static final int NUM_REQUESTED_FIELD_NUMBER = 4;
    private int numRequested_ = 0;
    public static final int AUTH_REFRESH_FIELD_NUMBER = 5;
    private volatile Object authRefresh_ = "";
    private byte memoizedIsInitialized = (byte)-1;
    private static final FetchRequest DEFAULT_INSTANCE = new FetchRequest();
    private static final Parser<FetchRequest> PARSER = new AbstractParser<FetchRequest>(){

        @Override
        public FetchRequest parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = FetchRequest.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private FetchRequest(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private FetchRequest() {
        this.topicName_ = "";
        this.replayPreset_ = 0;
        this.replayId_ = ByteString.EMPTY;
        this.authRefresh_ = "";
    }

    @Override
    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new FetchRequest();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return PubSubProto.internal_static_eventbus_v1_FetchRequest_descriptor;
    }

    @Override
    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return PubSubProto.internal_static_eventbus_v1_FetchRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(FetchRequest.class, Builder.class);
    }

    @Override
    public String getTopicName() {
        Object ref = this.topicName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s2 = bs.toStringUtf8();
        this.topicName_ = s2;
        return s2;
    }

    @Override
    public ByteString getTopicNameBytes() {
        Object ref = this.topicName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)ref);
            this.topicName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getReplayPresetValue() {
        return this.replayPreset_;
    }

    @Override
    public ReplayPreset getReplayPreset() {
        ReplayPreset result = ReplayPreset.forNumber(this.replayPreset_);
        return result == null ? ReplayPreset.UNRECOGNIZED : result;
    }

    @Override
    public ByteString getReplayId() {
        return this.replayId_;
    }

    @Override
    public int getNumRequested() {
        return this.numRequested_;
    }

    @Override
    public String getAuthRefresh() {
        Object ref = this.authRefresh_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s2 = bs.toStringUtf8();
        this.authRefresh_ = s2;
        return s2;
    }

    @Override
    public ByteString getAuthRefreshBytes() {
        Object ref = this.authRefresh_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)ref);
            this.authRefresh_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    @Override
    public void writeTo(CodedOutputStream output) throws IOException {
        if (!GeneratedMessageV3.isStringEmpty(this.topicName_)) {
            GeneratedMessageV3.writeString(output, 1, this.topicName_);
        }
        if (this.replayPreset_ != ReplayPreset.LATEST.getNumber()) {
            output.writeEnum(2, this.replayPreset_);
        }
        if (!this.replayId_.isEmpty()) {
            output.writeBytes(3, this.replayId_);
        }
        if (this.numRequested_ != 0) {
            output.writeInt32(4, this.numRequested_);
        }
        if (!GeneratedMessageV3.isStringEmpty(this.authRefresh_)) {
            GeneratedMessageV3.writeString(output, 5, this.authRefresh_);
        }
        this.getUnknownFields().writeTo(output);
    }

    @Override
    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty(this.topicName_)) {
            size += GeneratedMessageV3.computeStringSize(1, this.topicName_);
        }
        if (this.replayPreset_ != ReplayPreset.LATEST.getNumber()) {
            size += CodedOutputStream.computeEnumSize(2, this.replayPreset_);
        }
        if (!this.replayId_.isEmpty()) {
            size += CodedOutputStream.computeBytesSize(3, this.replayId_);
        }
        if (this.numRequested_ != 0) {
            size += CodedOutputStream.computeInt32Size(4, this.numRequested_);
        }
        if (!GeneratedMessageV3.isStringEmpty(this.authRefresh_)) {
            size += GeneratedMessageV3.computeStringSize(5, this.authRefresh_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FetchRequest)) {
            return super.equals(obj);
        }
        FetchRequest other = (FetchRequest)obj;
        if (!this.getTopicName().equals(other.getTopicName())) {
            return false;
        }
        if (this.replayPreset_ != other.replayPreset_) {
            return false;
        }
        if (!this.getReplayId().equals(other.getReplayId())) {
            return false;
        }
        if (this.getNumRequested() != other.getNumRequested()) {
            return false;
        }
        if (!this.getAuthRefresh().equals(other.getAuthRefresh())) {
            return false;
        }
        return this.getUnknownFields().equals(other.getUnknownFields());
    }

    @Override
    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + FetchRequest.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getTopicName().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.replayPreset_;
        hash = 37 * hash + 3;
        hash = 53 * hash + this.getReplayId().hashCode();
        hash = 37 * hash + 4;
        hash = 53 * hash + this.getNumRequested();
        hash = 37 * hash + 5;
        hash = 53 * hash + this.getAuthRefresh().hashCode();
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static FetchRequest parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static FetchRequest parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static FetchRequest parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static FetchRequest parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static FetchRequest parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static FetchRequest parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static FetchRequest parseFrom(InputStream input) throws IOException {
        return GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static FetchRequest parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static FetchRequest parseDelimitedFrom(InputStream input) throws IOException {
        return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static FetchRequest parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }

    public static FetchRequest parseFrom(CodedInputStream input) throws IOException {
        return GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static FetchRequest parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
    }

    @Override
    public Builder newBuilderForType() {
        return FetchRequest.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(FetchRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @Override
    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @Override
    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static FetchRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<FetchRequest> parser() {
        return PARSER;
    }

    public Parser<FetchRequest> getParserForType() {
        return PARSER;
    }

    @Override
    public FetchRequest getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements FetchRequestOrBuilder {
        private int bitField0_;
        private Object topicName_ = "";
        private int replayPreset_ = 0;
        private ByteString replayId_ = ByteString.EMPTY;
        private int numRequested_;
        private Object authRefresh_ = "";

        public static final Descriptors.Descriptor getDescriptor() {
            return PubSubProto.internal_static_eventbus_v1_FetchRequest_descriptor;
        }

        @Override
        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return PubSubProto.internal_static_eventbus_v1_FetchRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(FetchRequest.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.topicName_ = "";
            this.replayPreset_ = 0;
            this.replayId_ = ByteString.EMPTY;
            this.numRequested_ = 0;
            this.authRefresh_ = "";
            return this;
        }

        @Override
        public Descriptors.Descriptor getDescriptorForType() {
            return PubSubProto.internal_static_eventbus_v1_FetchRequest_descriptor;
        }

        @Override
        public FetchRequest getDefaultInstanceForType() {
            return FetchRequest.getDefaultInstance();
        }

        @Override
        public FetchRequest build() {
            FetchRequest result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException(result);
            }
            return result;
        }

        @Override
        public FetchRequest buildPartial() {
            FetchRequest result = new FetchRequest(this);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartial0(FetchRequest result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.topicName_ = this.topicName_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.replayPreset_ = this.replayPreset_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.replayId_ = this.replayId_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.numRequested_ = this.numRequested_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.authRefresh_ = this.authRefresh_;
            }
        }

        @Override
        public Builder clone() {
            return (Builder)super.clone();
        }

        @Override
        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        @Override
        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        @Override
        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        @Override
        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        @Override
        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        @Override
        public Builder mergeFrom(Message other) {
            if (other instanceof FetchRequest) {
                return this.mergeFrom((FetchRequest)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(FetchRequest other) {
            if (other == FetchRequest.getDefaultInstance()) {
                return this;
            }
            if (!other.getTopicName().isEmpty()) {
                this.topicName_ = other.topicName_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (other.replayPreset_ != 0) {
                this.setReplayPresetValue(other.getReplayPresetValue());
            }
            if (other.getReplayId() != ByteString.EMPTY) {
                this.setReplayId(other.getReplayId());
            }
            if (other.getNumRequested() != 0) {
                this.setNumRequested(other.getNumRequested());
            }
            if (!other.getAuthRefresh().isEmpty()) {
                this.authRefresh_ = other.authRefresh_;
                this.bitField0_ |= 0x10;
                this.onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        @Override
        public final boolean isInitialized() {
            return true;
        }

        @Override
        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block13: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block13;
                        }
                        case 10: {
                            this.topicName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block13;
                        }
                        case 16: {
                            this.replayPreset_ = input.readEnum();
                            this.bitField0_ |= 2;
                            continue block13;
                        }
                        case 26: {
                            this.replayId_ = input.readBytes();
                            this.bitField0_ |= 4;
                            continue block13;
                        }
                        case 32: {
                            this.numRequested_ = input.readInt32();
                            this.bitField0_ |= 8;
                            continue block13;
                        }
                        case 42: {
                            this.authRefresh_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x10;
                            continue block13;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getTopicName() {
            Object ref = this.topicName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s2 = bs.toStringUtf8();
                this.topicName_ = s2;
                return s2;
            }
            return (String)ref;
        }

        @Override
        public ByteString getTopicNameBytes() {
            Object ref = this.topicName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)ref);
                this.topicName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setTopicName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.topicName_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearTopicName() {
            this.topicName_ = FetchRequest.getDefaultInstance().getTopicName();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setTopicNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            FetchRequest.checkByteStringIsUtf8(value);
            this.topicName_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public int getReplayPresetValue() {
            return this.replayPreset_;
        }

        public Builder setReplayPresetValue(int value) {
            this.replayPreset_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public ReplayPreset getReplayPreset() {
            ReplayPreset result = ReplayPreset.forNumber(this.replayPreset_);
            return result == null ? ReplayPreset.UNRECOGNIZED : result;
        }

        public Builder setReplayPreset(ReplayPreset value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 2;
            this.replayPreset_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearReplayPreset() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.replayPreset_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public ByteString getReplayId() {
            return this.replayId_;
        }

        public Builder setReplayId(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.replayId_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearReplayId() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.replayId_ = FetchRequest.getDefaultInstance().getReplayId();
            this.onChanged();
            return this;
        }

        @Override
        public int getNumRequested() {
            return this.numRequested_;
        }

        public Builder setNumRequested(int value) {
            this.numRequested_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearNumRequested() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.numRequested_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public String getAuthRefresh() {
            Object ref = this.authRefresh_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s2 = bs.toStringUtf8();
                this.authRefresh_ = s2;
                return s2;
            }
            return (String)ref;
        }

        @Override
        public ByteString getAuthRefreshBytes() {
            Object ref = this.authRefresh_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)ref);
                this.authRefresh_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setAuthRefresh(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.authRefresh_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearAuthRefresh() {
            this.authRefresh_ = FetchRequest.getDefaultInstance().getAuthRefresh();
            this.bitField0_ &= 0xFFFFFFEF;
            this.onChanged();
            return this;
        }

        public Builder setAuthRefreshBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            FetchRequest.checkByteStringIsUtf8(value);
            this.authRefresh_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        @Override
        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        @Override
        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

