/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.util.Map;
import java.util.Properties;
import java.util.function.Predicate;
import org.apache.camel.component.properties.LocationPropertiesSource;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesLocation;
import org.apache.camel.spi.LoadablePropertiesSource;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.OrderedProperties;

public abstract class AbstractLocationPropertiesSource
extends ServiceSupport
implements LoadablePropertiesSource,
LocationPropertiesSource {
    private final Properties properties = new OrderedProperties();
    private final PropertiesComponent propertiesComponent;
    private final PropertiesLocation location;

    protected AbstractLocationPropertiesSource(PropertiesComponent propertiesComponent, PropertiesLocation location) {
        this.propertiesComponent = propertiesComponent;
        this.location = location;
    }

    public abstract Properties loadPropertiesFromLocation(PropertiesComponent var1, PropertiesLocation var2);

    @Override
    public PropertiesLocation getLocation() {
        return this.location;
    }

    @Override
    public Properties loadProperties() {
        return this.properties;
    }

    @Override
    public Properties loadProperties(Predicate<String> filter) {
        OrderedProperties answer = new OrderedProperties();
        for (String name : this.properties.stringPropertyNames()) {
            if (!filter.test(name)) continue;
            ((Properties)answer).put(name, this.properties.get(name));
        }
        return answer;
    }

    @Override
    public void reloadProperties(String location) {
        PropertiesLocation loc;
        Properties prop;
        String resolver = ResourceHelper.getScheme(location);
        if (resolver != null) {
            location = location.substring(resolver.length());
        }
        if ((prop = this.loadPropertiesFromLocation(this.propertiesComponent, loc = new PropertiesLocation(resolver, location))) != null) {
            prop = AbstractLocationPropertiesSource.prepareLoadedProperties(prop);
            this.properties.clear();
            this.properties.putAll((Map<?, ?>)prop);
        }
    }

    @Override
    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    @Override
    protected void doInit() throws Exception {
        super.doInit();
        Properties prop = this.loadPropertiesFromLocation(this.propertiesComponent, this.location);
        if (prop != null) {
            prop = AbstractLocationPropertiesSource.prepareLoadedProperties(prop);
            this.properties.putAll((Map<?, ?>)prop);
        }
    }

    @Override
    protected void doShutdown() throws Exception {
        this.properties.clear();
    }

    protected static Properties prepareLoadedProperties(Properties properties) {
        OrderedProperties answer = new OrderedProperties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                String s2 = (String)value;
                value = AbstractLocationPropertiesSource.trimTrailingWhitespaces(s2);
            }
            ((Properties)answer).put(key, value);
        }
        return answer;
    }

    private static String trimTrailingWhitespaces(String s2) {
        int endIndex = s2.length();
        int index = s2.length() - 1;
        while (index >= 0 && s2.charAt(index) == ' ') {
            endIndex = index--;
        }
        return s2.substring(0, endIndex);
    }
}

