/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.salesforce.SalesforceComponent;
import org.apache.camel.component.salesforce.internal.client.HttpClientHolder;
import org.apache.camel.component.salesforce.internal.client.RestClient;
import org.apache.camel.support.service.ServiceHelper;

final class SalesforceClientTemplate {
    static RestClientSupplier restClientSupplier = (camelContext, parameters) -> SalesforceComponent.createRestClient(camelContext, parameters);

    private SalesforceClientTemplate() {
    }

    static <T> T invoke(CamelContext camelContext, Map<String, Object> parameters, WithClient<T> performer) throws Exception {
        RestClient client = restClientSupplier.restClientWith(camelContext, parameters);
        return SalesforceClientTemplate.invokeInternal(client, performer);
    }

    static <T> T invoke(SalesforceComponent component, Map<String, Object> parameters, WithClient<T> performer) throws Exception {
        RestClient client = component.createRestClient(parameters);
        return SalesforceClientTemplate.invokeInternal(client, performer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T invokeInternal(RestClient client, WithClient<T> performer) throws Exception {
        boolean isHttpClientHolder = client instanceof HttpClientHolder;
        if (isHttpClientHolder) {
            ((HttpClientHolder)((Object)client)).getHttpClient().start();
        }
        ServiceHelper.startService((Object)client);
        try {
            T t2 = performer.invoke(client);
            return t2;
        }
        finally {
            ServiceHelper.stopService((Object)client);
            if (isHttpClientHolder) {
                ((HttpClientHolder)((Object)client)).getHttpClient().stop();
            }
        }
    }

    @FunctionalInterface
    static interface RestClientSupplier {
        public RestClient restClientWith(CamelContext var1, Map<String, Object> var2) throws Exception;
    }

    @FunctionalInterface
    static interface WithClient<T> {
        public T invoke(RestClient var1);
    }
}

