/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.jsonSchema.jakarta.JsonSchema;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.extension.MetaDataExtension;
import org.apache.camel.component.extension.metadata.AbstractMetaDataExtension;
import org.apache.camel.component.extension.metadata.MetaDataBuilder;
import org.apache.camel.component.salesforce.SalesforceClientTemplate;
import org.apache.camel.component.salesforce.api.dto.GlobalObjects;
import org.apache.camel.component.salesforce.api.dto.SObjectDescription;
import org.apache.camel.component.salesforce.api.utils.JsonUtils;
import org.apache.camel.component.salesforce.internal.client.RestClient;

public class SalesforceMetaDataExtension
extends AbstractMetaDataExtension {
    private static final ObjectMapper MAPPER = JsonUtils.createObjectMapper();

    @Override
    public Optional<MetaDataExtension.MetaData> meta(Map<String, Object> parameters) {
        JsonSchema schema = this.schemaFor(parameters);
        MetaDataExtension.MetaData metaData = MetaDataBuilder.on(this.getCamelContext()).withAttribute("Content-Type", "application/schema+json").withAttribute("Java-Type", JsonNode.class).withPayload(schema).build();
        return Optional.ofNullable(metaData);
    }

    JsonSchema allObjectsSchema(Map<String, Object> parameters) throws Exception {
        return SalesforceClientTemplate.invoke(this.getCamelContext(), parameters, client -> SalesforceMetaDataExtension.fetchAllObjectsSchema(client));
    }

    JsonSchema schemaFor(Map<String, Object> parameters) {
        try {
            if (parameters.containsKey("sObjectName")) {
                return this.singleObjectSchema(parameters);
            }
            return this.allObjectsSchema(parameters);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
    }

    JsonSchema singleObjectSchema(Map<String, Object> parameters) throws Exception {
        return SalesforceClientTemplate.invoke(this.getCamelContext(), parameters, client -> SalesforceMetaDataExtension.fetchSingleObjectSchema(client, (String)parameters.get("sObjectName")));
    }

    static JsonSchema fetch(Consumer<RestClient.ResponseCallback> restMethod, SchemaMapper callback) {
        CompletableFuture ret = new CompletableFuture();
        restMethod.accept((response, headers, exception) -> {
            if (exception != null) {
                ret.completeExceptionally(exception);
            } else {
                try (InputStream is = response;){
                    ret.complete(callback.map(is));
                }
                catch (IOException e) {
                    ret.completeExceptionally(e);
                }
            }
        });
        try {
            return (JsonSchema)ret.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
        catch (ExecutionException e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
    }

    static JsonSchema fetchAllObjectsSchema(RestClient client) {
        return SalesforceMetaDataExtension.fetch(callback -> client.getGlobalObjects(Collections.emptyMap(), (RestClient.ResponseCallback)callback), SalesforceMetaDataExtension::mapAllObjectsSchema);
    }

    static JsonSchema fetchSingleObjectSchema(RestClient client, String objectName) {
        return SalesforceMetaDataExtension.fetch(callback -> client.getDescription(objectName, Collections.emptyMap(), (RestClient.ResponseCallback)callback), SalesforceMetaDataExtension::mapSingleObjectSchema);
    }

    static JsonSchema mapAllObjectsSchema(InputStream stream) throws IOException {
        GlobalObjects globalObjects = (GlobalObjects)MAPPER.readerFor(GlobalObjects.class).readValue(stream);
        return JsonUtils.getGlobalObjectsJsonSchemaAsSchema(globalObjects);
    }

    static JsonSchema mapSingleObjectSchema(InputStream stream) throws IOException {
        SObjectDescription description = (SObjectDescription)MAPPER.readerFor(SObjectDescription.class).readValue(stream);
        return JsonUtils.getSObjectJsonSchemaAsSchema(description, true);
    }

    @FunctionalInterface
    static interface SchemaMapper {
        public JsonSchema map(InputStream var1) throws IOException;
    }
}

