/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.api;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import org.apache.camel.component.salesforce.api.dto.AbstractSObjectBase;
import org.apache.commons.lang3.reflect.FieldUtils;

public class FieldsToNullPropertyFilter
extends SimpleBeanPropertyFilter {
    @Override
    public void serializeAsField(Object pojo, JsonGenerator jgen, SerializerProvider provider, PropertyWriter writer) throws Exception {
        AbstractSObjectBase sob = (AbstractSObjectBase)pojo;
        String fieldName = writer.getName();
        Object fieldValue = null;
        boolean failedToReadFieldValue = false;
        try {
            fieldValue = FieldUtils.readField(pojo, fieldName, true);
        }
        catch (IllegalArgumentException e) {
            failedToReadFieldValue = true;
        }
        if (sob.getFieldsToNull().contains(writer.getName()) || fieldValue != null || failedToReadFieldValue) {
            writer.serializeAsField(pojo, jgen, provider);
        } else {
            writer.serializeAsOmittedField(pojo, jgen, provider);
        }
    }
}

