/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.api.dto.composite;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.component.salesforce.api.dto.AbstractDescribedSObjectBase;
import org.apache.camel.component.salesforce.api.dto.AbstractSObjectBase;
import org.apache.camel.component.salesforce.api.dto.composite.BatchRequest;
import org.apache.camel.component.salesforce.api.utils.UrlUtils;
import org.apache.camel.component.salesforce.api.utils.Version;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

public final class SObjectBatch
implements Serializable {
    private static final String SOBJECT_TYPE_PARAM = "type";
    private static final int MAX_BATCH = 25;
    private static final long serialVersionUID = 1L;
    private final String apiPrefix;
    private final List<BatchRequest> batchRequests = new ArrayList<BatchRequest>();
    private final Version version;

    public SObjectBatch(String apiVersion) {
        String givenApiVersion = Objects.requireNonNull(apiVersion, "apiVersion");
        this.version = Version.create(apiVersion);
        this.version.requireAtLeast(34, 0);
        this.apiPrefix = "v" + givenApiVersion;
    }

    static String composeFieldsParameter(String ... fields) {
        if (fields != null && fields.length > 0) {
            return "?fields=" + Arrays.stream(fields).collect(Collectors.joining(","));
        }
        return "";
    }

    public SObjectBatch addCreate(AbstractDescribedSObjectBase data) {
        this.addBatchRequest(new BatchRequest(Method.POST, this.apiPrefix + "/sobjects/" + this.typeOf(data) + "/", data));
        return this;
    }

    public SObjectBatch addDelete(String type, String id) {
        this.addBatchRequest(new BatchRequest(Method.DELETE, this.rowBaseUrl(type, id)));
        return this;
    }

    public SObjectBatch addGeneric(Method method, String url) {
        this.addGeneric(method, url, null);
        return this;
    }

    public SObjectBatch addGeneric(Method method, String url, Object richInput) {
        this.addBatchRequest(new BatchRequest(method, this.apiPrefix + url, richInput));
        return this;
    }

    public SObjectBatch addGet(String type, String id, String ... fields) {
        String fieldsParameter = SObjectBatch.composeFieldsParameter(fields);
        this.addBatchRequest(new BatchRequest(Method.GET, this.rowBaseUrl(type, id) + fieldsParameter));
        return this;
    }

    public SObjectBatch addGetByExternalId(String type, String fieldName, String fieldValue) {
        this.addBatchRequest(new BatchRequest(Method.GET, this.rowBaseUrl(type, fieldName, fieldValue)));
        return this;
    }

    public SObjectBatch addGetRelated(String type, String id, String relation, String ... fields) {
        this.version.requireAtLeast(36, 0);
        String fieldsParameter = SObjectBatch.composeFieldsParameter(fields);
        this.addBatchRequest(new BatchRequest(Method.GET, this.rowBaseUrl(type, id) + "/" + StringHelper.notEmpty(relation, "relation") + fieldsParameter));
        return this;
    }

    public SObjectBatch addLimits() {
        this.addBatchRequest(new BatchRequest(Method.GET, this.apiPrefix + "/limits/"));
        return this;
    }

    public SObjectBatch addQuery(String query) {
        this.addBatchRequest(new BatchRequest(Method.GET, this.apiPrefix + "/query/?q=" + StringHelper.notEmpty(query, "query")));
        return this;
    }

    public SObjectBatch addQueryAll(String query) {
        this.addBatchRequest(new BatchRequest(Method.GET, this.apiPrefix + "/queryAll/?q=" + StringHelper.notEmpty(query, "query")));
        return this;
    }

    public SObjectBatch addSearch(String searchString) {
        this.addBatchRequest(new BatchRequest(Method.GET, this.apiPrefix + "/search/?q=" + StringHelper.notEmpty(searchString, "searchString")));
        return this;
    }

    public SObjectBatch addUpdate(String type, String id, AbstractSObjectBase data) {
        this.addBatchRequest(new BatchRequest(Method.PATCH, this.rowBaseUrl(type, StringHelper.notEmpty(id, "data.Id")), data));
        return this;
    }

    public SObjectBatch addUpdateByExternalId(String type, String fieldName, String fieldValue, AbstractSObjectBase data) {
        this.addBatchRequest(new BatchRequest(Method.PATCH, this.rowBaseUrl(type, fieldName, fieldValue), data));
        return this;
    }

    public SObjectBatch addUpsertByExternalId(String type, String fieldName, String fieldValue, AbstractSObjectBase data) {
        return this.addUpdateByExternalId(type, fieldName, fieldValue, data);
    }

    public List<BatchRequest> getBatchRequests() {
        return Collections.unmodifiableList(this.batchRequests);
    }

    @JsonIgnore
    public Version getVersion() {
        return this.version;
    }

    public Class[] objectTypes() {
        return (Class[])Stream.concat(Stream.of(SObjectBatch.class, BatchRequest.class), this.batchRequests.stream().map(BatchRequest::getRichInput).filter(Objects::nonNull).map(Object::getClass)).distinct().toArray(Class[]::new);
    }

    void addBatchRequest(BatchRequest batchRequest) {
        if (this.batchRequests.size() >= 25) {
            throw new IllegalArgumentException("You can add up to 25 requests in a single batch. Split your requests across multiple batches.");
        }
        this.batchRequests.add(batchRequest);
    }

    String rowBaseUrl(String type, String id) {
        return this.apiPrefix + "/sobjects/" + StringHelper.notEmpty(type, SOBJECT_TYPE_PARAM) + "/" + StringHelper.notEmpty(id, "id");
    }

    String rowBaseUrl(String type, String fieldName, String fieldValue) {
        try {
            return this.apiPrefix + "/sobjects/" + StringHelper.notEmpty(type, SOBJECT_TYPE_PARAM) + "/" + StringHelper.notEmpty(fieldName, "fieldName") + "/" + UrlUtils.encodePath(StringHelper.notEmpty(fieldValue, "fieldValue"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    String typeOf(AbstractDescribedSObjectBase data) {
        return ObjectHelper.notNull(data, "data").description().getName();
    }

    public static enum Method {
        DELETE,
        GET,
        PATCH,
        POST;

    }
}

