/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.api.utils;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;

final class LocalDateTimeSerializer
extends StdSerializer<LocalDateTime> {
    static final JsonSerializer<LocalDateTime> INSTANCE = new LocalDateTimeSerializer();
    private static final long serialVersionUID = 1L;

    private LocalDateTimeSerializer() {
        super(LocalDateTime.class);
    }

    @Override
    public void serialize(LocalDateTime value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        ZonedDateTime zonedDateTime = ZonedDateTime.of(value, ZoneId.systemDefault());
        serializers.defaultSerializeValue(zonedDateTime, gen);
    }
}

