/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.camel.component.salesforce.SalesforceEndpoint;
import org.apache.camel.component.salesforce.SalesforceHttpClient;
import org.apache.camel.component.salesforce.SalesforceLoginConfig;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.api.dto.RestError;
import org.apache.camel.component.salesforce.api.dto.bulkv2.Job;
import org.apache.camel.component.salesforce.api.dto.bulkv2.JobStateEnum;
import org.apache.camel.component.salesforce.api.dto.bulkv2.Jobs;
import org.apache.camel.component.salesforce.api.dto.bulkv2.QueryJob;
import org.apache.camel.component.salesforce.api.dto.bulkv2.QueryJobs;
import org.apache.camel.component.salesforce.api.utils.JsonUtils;
import org.apache.camel.component.salesforce.internal.SalesforceSession;
import org.apache.camel.component.salesforce.internal.client.AbstractClientBase;
import org.apache.camel.component.salesforce.internal.client.BulkApiV2Client;
import org.eclipse.jetty.client.BytesRequestContent;
import org.eclipse.jetty.client.InputStreamRequestContent;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.client.Response;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;

public class DefaultBulkApiV2Client
extends AbstractClientBase
implements BulkApiV2Client {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String BEARER_PREFIX = "Bearer ";
    private final ObjectMapper objectMapper;

    public DefaultBulkApiV2Client(String version, SalesforceSession session, SalesforceHttpClient httpClient, SalesforceLoginConfig loginConfig, SalesforceEndpoint endpoint) throws SalesforceException {
        super(version, session, httpClient, loginConfig);
        this.objectMapper = endpoint.getConfiguration().getObjectMapper() != null ? endpoint.getConfiguration().getObjectMapper() : JsonUtils.createObjectMapper();
    }

    @Override
    public void createJob(Job job, Map<String, List<String>> headers, BulkApiV2Client.JobResponseCallback callback) {
        Request request = this.getRequest(HttpMethod.POST, this.jobUrl(null), headers);
        try {
            this.marshalRequest(job, request);
        }
        catch (SalesforceException e) {
            callback.onResponse(null, Collections.emptyMap(), e);
            return;
        }
        this.doHttpRequestWithJobResponse(callback, request);
    }

    @Override
    public void getJob(String jobId, Map<String, List<String>> headers, BulkApiV2Client.JobResponseCallback callback) {
        Request request = this.getRequest(HttpMethod.GET, this.jobUrl(jobId), headers);
        this.doHttpRequestWithJobResponse(callback, request);
    }

    @Override
    public void createBatch(InputStream batchStream, String jobId, Map<String, List<String>> headers, final BulkApiV2Client.ResponseCallback callback) {
        Request request = this.getRequest(HttpMethod.PUT, this.jobUrl(jobId) + "/batches", headers);
        request.body(new InputStreamRequestContent(batchStream));
        request.headers(h2 -> h2.add(HttpHeader.CONTENT_TYPE, "text/csv"));
        this.doHttpRequest(request, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, Map<String, String> headers, SalesforceException ex) {
                callback.onResponse(headers, ex);
            }
        });
    }

    @Override
    public void changeJobState(String jobId, JobStateEnum state, Map<String, List<String>> headers, final BulkApiV2Client.JobResponseCallback callback) {
        final Request request = this.getRequest(HttpMethod.PATCH, this.jobUrl(jobId), headers);
        Job job = new Job();
        job.setId(jobId);
        job.setState(state);
        try {
            this.marshalRequest(job, request);
        }
        catch (SalesforceException e) {
            callback.onResponse(null, Collections.emptyMap(), e);
            return;
        }
        this.doHttpRequest(request, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, Map<String, String> headers, SalesforceException ex) {
                if (ex != null) {
                    callback.onResponse(null, headers, ex);
                }
                Job responseJob = null;
                try {
                    responseJob = DefaultBulkApiV2Client.this.unmarshalResponse(response, request, Job.class);
                }
                catch (SalesforceException e) {
                    ex = e;
                }
                callback.onResponse(responseJob, headers, ex);
            }
        });
    }

    @Override
    public void deleteJob(String jobId, Map<String, List<String>> headers, final BulkApiV2Client.ResponseCallback callback) {
        Request request = this.getRequest(HttpMethod.DELETE, this.jobUrl(jobId), headers);
        this.doHttpRequest(request, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, Map<String, String> headers, SalesforceException ex) {
                callback.onResponse(headers, ex);
            }
        });
    }

    @Override
    public void getSuccessfulResults(String jobId, Map<String, List<String>> headers, BulkApiV2Client.StreamResponseCallback callback) {
        Request request = this.getRequest(HttpMethod.GET, this.jobUrl(jobId) + "/successfulResults", headers);
        this.doRequestWithCsvResponse(callback, request);
    }

    @Override
    public void getFailedResults(String jobId, Map<String, List<String>> headers, BulkApiV2Client.StreamResponseCallback callback) {
        Request request = this.getRequest(HttpMethod.GET, this.jobUrl(jobId) + "/failedResults", headers);
        this.doRequestWithCsvResponse(callback, request);
    }

    @Override
    public void getUnprocessedRecords(String jobId, Map<String, List<String>> headers, BulkApiV2Client.StreamResponseCallback callback) {
        Request request = this.getRequest(HttpMethod.GET, this.jobUrl(jobId) + "/unprocessedrecords", headers);
        this.doRequestWithCsvResponse(callback, request);
    }

    @Override
    public void getAllJobs(String queryLocator, Map<String, List<String>> headers, final BulkApiV2Client.JobsResponseCallback callback) {
        Object url = this.jobUrl(null);
        if (queryLocator != null) {
            url = (String)url + "?queryLocator=" + queryLocator;
        }
        final Request request = this.getRequest(HttpMethod.GET, (String)url, headers);
        this.doHttpRequest(request, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, Map<String, String> responseHeaders, SalesforceException ex) {
                if (ex != null) {
                    callback.onResponse(null, responseHeaders, ex);
                }
                Jobs responseJobs = null;
                try {
                    responseJobs = DefaultBulkApiV2Client.this.unmarshalResponse(response, request, Jobs.class);
                }
                catch (SalesforceException e) {
                    ex = e;
                }
                callback.onResponse(responseJobs, responseHeaders, ex);
            }
        });
    }

    @Override
    public void createQueryJob(QueryJob queryJob, Map<String, List<String>> headers, BulkApiV2Client.QueryJobResponseCallback callback) {
        Request request = this.getRequest(HttpMethod.POST, this.queryJobUrl(null), headers);
        try {
            this.marshalRequest(queryJob, request);
        }
        catch (SalesforceException e) {
            callback.onResponse(null, Collections.emptyMap(), e);
            return;
        }
        this.doHttpRequestWithQueryJobResponse(callback, request);
    }

    @Override
    public void getQueryJob(String jobId, Map<String, List<String>> headers, BulkApiV2Client.QueryJobResponseCallback callback) {
        Request request = this.getRequest(HttpMethod.GET, this.queryJobUrl(jobId), headers);
        this.doHttpRequestWithQueryJobResponse(callback, request);
    }

    @Override
    public void getQueryJobResults(String jobId, String locator, Integer maxRecords, Map<String, List<String>> headers, BulkApiV2Client.StreamResponseCallback callback) {
        String query = null;
        if (locator != null) {
            query = "locator=" + locator;
        }
        if (maxRecords != null) {
            query = (String)(query != null ? query + "&" : "") + "maxRecords=" + maxRecords;
        }
        String url = this.queryJobUrl(jobId) + "/results";
        if (query != null) {
            url = url + "?" + query;
        }
        Request request = this.getRequest(HttpMethod.GET, url, headers);
        this.doRequestWithCsvResponse(callback, request);
    }

    @Override
    public void changeQueryJobState(String jobId, JobStateEnum state, Map<String, List<String>> headers, final BulkApiV2Client.QueryJobResponseCallback callback) {
        final Request request = this.getRequest(HttpMethod.PATCH, this.queryJobUrl(jobId), headers);
        QueryJob job = new QueryJob();
        job.setId(jobId);
        job.setState(state);
        try {
            this.marshalRequest(job, request);
        }
        catch (SalesforceException e) {
            callback.onResponse(null, Collections.emptyMap(), e);
            return;
        }
        this.doHttpRequest(request, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, Map<String, String> headers, SalesforceException ex) {
                if (ex != null) {
                    callback.onResponse(null, headers, ex);
                }
                QueryJob responseJob = null;
                try {
                    responseJob = DefaultBulkApiV2Client.this.unmarshalResponse(response, request, QueryJob.class);
                }
                catch (SalesforceException e) {
                    ex = e;
                }
                callback.onResponse(responseJob, headers, ex);
            }
        });
    }

    @Override
    public void deleteQueryJob(String jobId, Map<String, List<String>> headers, final BulkApiV2Client.ResponseCallback callback) {
        Request request = this.getRequest(HttpMethod.DELETE, this.queryJobUrl(jobId), headers);
        this.doHttpRequest(request, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, Map<String, String> headers, SalesforceException ex) {
                callback.onResponse(headers, ex);
            }
        });
    }

    @Override
    public void getAllQueryJobs(String queryLocator, Map<String, List<String>> headers, final BulkApiV2Client.QueryJobsResponseCallback callback) {
        Object url = this.queryJobUrl(null);
        if (queryLocator != null) {
            url = (String)url + "?queryLocator=" + queryLocator;
        }
        final Request request = this.getRequest(HttpMethod.GET, (String)url, headers);
        this.doHttpRequest(request, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, Map<String, String> responseHeaders, SalesforceException ex) {
                if (ex != null) {
                    callback.onResponse(null, responseHeaders, ex);
                }
                QueryJobs responseJobs = null;
                try {
                    responseJobs = DefaultBulkApiV2Client.this.unmarshalResponse(response, request, QueryJobs.class);
                }
                catch (SalesforceException e) {
                    ex = e;
                }
                callback.onResponse(responseJobs, responseHeaders, ex);
            }
        });
    }

    @Override
    protected void doHttpRequest(Request request, AbstractClientBase.ClientResponseCallback callback) {
        this.setAccessToken(request);
        if (!request.getHeaders().contains(HttpHeader.CONTENT_TYPE)) {
            request.headers(h2 -> h2.add(HttpHeader.CONTENT_TYPE, "application/json"));
        }
        request.headers(h2 -> h2.add(HttpHeader.ACCEPT_CHARSET, StandardCharsets.UTF_8.name()));
        request.headers(h2 -> h2.add(HttpHeader.ACCEPT, "application/json"));
        super.doHttpRequest(request, callback);
    }

    @Override
    protected SalesforceException createRestException(Response response, InputStream responseContent) {
        try {
            List<RestError> errors = this.unmarshalResponse(responseContent, response.getRequest(), new TypeReference<List<RestError>>(){});
            return new SalesforceException(errors, response.getStatus());
        }
        catch (SalesforceException e) {
            String msg = "Error un-marshaling Salesforce Error: " + e.getMessage();
            return new SalesforceException(msg, e);
        }
    }

    @Override
    protected void setAccessToken(Request request) {
        request.headers(h2 -> h2.add(AUTHORIZATION_HEADER, BEARER_PREFIX + this.accessToken));
    }

    private String jobUrl(String jobId) {
        return this.instanceUrl + "/services/data/v" + this.version + "/jobs/ingest" + (String)(jobId != null ? "/" + jobId : "");
    }

    private String queryJobUrl(String jobId) {
        return this.instanceUrl + "/services/data/v" + this.version + "/jobs/query" + (String)(jobId != null ? "/" + jobId : "");
    }

    private void doRequestWithCsvResponse(BulkApiV2Client.StreamResponseCallback callback, Request request) {
        request.accept("text/csv");
        this.doHttpRequest(request, callback::onResponse);
    }

    private void doHttpRequestWithJobResponse(final BulkApiV2Client.JobResponseCallback callback, final Request request) {
        this.doHttpRequest(request, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, Map<String, String> responseHeaders, SalesforceException ex) {
                if (ex != null) {
                    callback.onResponse(null, responseHeaders, ex);
                }
                Job responseJob = null;
                try {
                    responseJob = DefaultBulkApiV2Client.this.unmarshalResponse(response, request, Job.class);
                }
                catch (SalesforceException e) {
                    ex = e;
                }
                callback.onResponse(responseJob, responseHeaders, ex);
            }
        });
    }

    private void doHttpRequestWithQueryJobResponse(final BulkApiV2Client.QueryJobResponseCallback callback, final Request request) {
        this.doHttpRequest(request, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, Map<String, String> responseHeaders, SalesforceException ex) {
                if (ex != null) {
                    callback.onResponse(null, responseHeaders, ex);
                }
                QueryJob queryJob = null;
                try {
                    queryJob = DefaultBulkApiV2Client.this.unmarshalResponse(response, request, QueryJob.class);
                }
                catch (SalesforceException e) {
                    ex = e;
                }
                callback.onResponse(queryJob, responseHeaders, ex);
            }
        });
    }

    private void marshalRequest(Object input, Request request) throws SalesforceException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            this.objectMapper.writeValue(outputStream, input);
        }
        catch (IOException e) {
            String message = "Error marshaling request: " + e.getMessage();
            throw new SalesforceException(message, e);
        }
        request.body(new BytesRequestContent(new byte[][]{outputStream.toByteArray()}));
    }

    private <T> T unmarshalResponse(InputStream response, Request request, Class<T> resultClass) throws SalesforceException {
        T result = null;
        if (response != null) {
            try {
                result = this.objectMapper.readValue(response, resultClass);
            }
            catch (IOException e) {
                throw new SalesforceException(String.format("Error unmarshalling response for {%s:%s} : %s", request.getMethod(), request.getURI(), e.getMessage()), e);
            }
        }
        return result;
    }

    private <T> T unmarshalResponse(InputStream response, Request request, TypeReference<T> typeRef) throws SalesforceException {
        T result = null;
        if (response != null) {
            try {
                result = this.objectMapper.readValue(response, typeRef);
            }
            catch (IOException e) {
                throw new SalesforceException(String.format("Error unmarshalling response for {%s:%s} : %s", request.getMethod(), request.getURI(), e.getMessage()), e);
            }
        }
        return result;
    }
}

