/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal.client;

import io.grpc.CallCredentials;
import io.grpc.Metadata;
import java.util.concurrent.Executor;
import org.apache.camel.component.salesforce.internal.SalesforceSession;

public class TokenCredentials
extends CallCredentials {
    private final SalesforceSession session;
    public static final Metadata.Key<String> INSTANCE_URL_KEY = TokenCredentials.keyOf("instanceUrl");
    public static final Metadata.Key<String> SESSION_TOKEN_KEY = TokenCredentials.keyOf("accessToken");
    public static final Metadata.Key<String> TENANT_ID_KEY = TokenCredentials.keyOf("tenantId");

    public TokenCredentials(SalesforceSession session) {
        this.session = session;
    }

    @Override
    public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor executor, CallCredentials.MetadataApplier metadataApplier) {
        Metadata headers = new Metadata();
        headers.put(INSTANCE_URL_KEY, this.session.getInstanceUrl());
        headers.put(TENANT_ID_KEY, this.session.getOrgId());
        headers.put(SESSION_TOKEN_KEY, this.session.getAccessToken());
        metadataApplier.apply(headers);
    }

    @Override
    public void thisUsesUnstableApi() {
    }

    private static Metadata.Key<String> keyOf(String name) {
        return Metadata.Key.of(name, Metadata.ASCII_STRING_MARSHALLER);
    }
}

