/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal.processor;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelException;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.StreamCache;
import org.apache.camel.component.salesforce.SalesforceEndpoint;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.api.dto.bulk.BatchInfo;
import org.apache.camel.component.salesforce.api.dto.bulk.ContentType;
import org.apache.camel.component.salesforce.api.dto.bulk.JobInfo;
import org.apache.camel.component.salesforce.internal.client.BulkApiClient;
import org.apache.camel.component.salesforce.internal.client.DefaultBulkApiClient;
import org.apache.camel.component.salesforce.internal.processor.AbstractSalesforceProcessor;
import org.apache.camel.converter.stream.StreamCacheConverter;
import org.apache.camel.support.service.ServiceHelper;

public class BulkApiProcessor
extends AbstractSalesforceProcessor {
    private BulkApiClient bulkClient;

    public BulkApiProcessor(SalesforceEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.bulkClient = new DefaultBulkApiClient((String)this.endpointConfigMap.get("apiVersion"), this.session, this.httpClient, this.loginConfig);
        ServiceHelper.startService((Object)this.bulkClient);
    }

    @Override
    public void doStop() {
        ServiceHelper.stopService((Object)this.bulkClient);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        boolean done = false;
        try {
            switch (this.operationName) {
                case CREATE_JOB: {
                    this.processCreateJob(exchange, callback);
                    break;
                }
                case GET_JOB: {
                    this.processGetJob(exchange, callback);
                    break;
                }
                case CLOSE_JOB: {
                    this.processCloseJob(exchange, callback);
                    break;
                }
                case ABORT_JOB: {
                    this.processAbortJob(exchange, callback);
                    break;
                }
                case CREATE_BATCH: {
                    this.processCreateBatch(exchange, callback);
                    break;
                }
                case GET_BATCH: {
                    this.processGetBatch(exchange, callback);
                    break;
                }
                case GET_ALL_BATCHES: {
                    this.processGetAllBatches(exchange, callback);
                    break;
                }
                case GET_REQUEST: {
                    this.processGetRequest(exchange, callback);
                    break;
                }
                case GET_RESULTS: {
                    this.processGetResults(exchange, callback);
                    break;
                }
                case CREATE_BATCH_QUERY: {
                    this.processCreateBatchQuery(exchange, callback);
                    break;
                }
                case GET_QUERY_RESULT_IDS: {
                    this.processGetQueryResultIds(exchange, callback);
                    break;
                }
                case GET_QUERY_RESULT: {
                    this.processGetQueryResult(exchange, callback);
                    break;
                }
                default: {
                    throw new SalesforceException("Unknown operation name: " + this.operationName.value(), null);
                }
            }
        }
        catch (SalesforceException e) {
            exchange.setException(new SalesforceException(String.format("Error processing %s: [%s] \"%s\"", this.operationName.value(), e.getStatusCode(), e.getMessage()), e));
            callback.done(true);
            done = true;
        }
        catch (RuntimeException | InvalidPayloadException e) {
            exchange.setException(new SalesforceException(String.format("Unexpected Error processing %s: \"%s\"", this.operationName.value(), e.getMessage()), e));
            callback.done(true);
            done = true;
        }
        return done;
    }

    @Override
    public Map<String, List<String>> determineHeaders(Exchange exchange) {
        Map<String, List<String>> headers = super.determineHeaders(exchange);
        try {
            Boolean pkChunking = this.getParameter("pkChunking", exchange, false, true, Boolean.class);
            if (pkChunking != null && pkChunking.booleanValue()) {
                String parent;
                String startRow;
                ArrayList<Object> values = new ArrayList<Object>();
                values.add("true");
                Integer chunkSize = this.getParameter("pkChunkingChunkSize", exchange, false, true, Integer.class);
                if (chunkSize != null) {
                    values.add("chunkSize=" + chunkSize);
                }
                if ((startRow = this.getParameter("pkChunkingStartRow", exchange, false, true, String.class)) != null) {
                    values.add("startRow=" + startRow);
                }
                if ((parent = this.getParameter("pkChunkingParent", exchange, false, true, String.class)) != null) {
                    values.add("parent=" + parent);
                }
                headers.put("Sforce-Enable-PKChunking", values);
            }
        }
        catch (SalesforceException e) {
            throw new RuntimeException(e);
        }
        return headers;
    }

    private void processCreateJob(final Exchange exchange, final AsyncCallback callback) throws InvalidPayloadException {
        JobInfo jobBody = exchange.getIn().getMandatoryBody(JobInfo.class);
        this.bulkClient.createJob(jobBody, this.determineHeaders(exchange), new BulkApiClient.JobInfoResponseCallback(){

            @Override
            public void onResponse(JobInfo jobInfo, Map<String, String> headers, SalesforceException ex) {
                BulkApiProcessor.this.processResponse(exchange, jobInfo, headers, ex, callback);
            }
        });
    }

    private void processGetJob(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        JobInfo jobBody = exchange.getIn().getBody(JobInfo.class);
        String jobId = jobBody != null ? jobBody.getId() : this.getParameter("jobId", exchange, true, false);
        this.bulkClient.getJob(jobId, this.determineHeaders(exchange), new BulkApiClient.JobInfoResponseCallback(){

            @Override
            public void onResponse(JobInfo jobInfo, Map<String, String> headers, SalesforceException ex) {
                BulkApiProcessor.this.processResponse(exchange, jobInfo, headers, ex, callback);
            }
        });
    }

    private void processCloseJob(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        JobInfo jobBody = exchange.getIn().getBody(JobInfo.class);
        String jobId = jobBody != null ? jobBody.getId() : this.getParameter("jobId", exchange, true, false);
        this.bulkClient.closeJob(jobId, this.determineHeaders(exchange), new BulkApiClient.JobInfoResponseCallback(){

            @Override
            public void onResponse(JobInfo jobInfo, Map<String, String> headers, SalesforceException ex) {
                BulkApiProcessor.this.processResponse(exchange, jobInfo, headers, ex, callback);
            }
        });
    }

    private void processAbortJob(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        JobInfo jobBody = exchange.getIn().getBody(JobInfo.class);
        String jobId = jobBody != null ? jobBody.getId() : this.getParameter("jobId", exchange, true, false);
        this.bulkClient.abortJob(jobId, this.determineHeaders(exchange), new BulkApiClient.JobInfoResponseCallback(){

            @Override
            public void onResponse(JobInfo jobInfo, Map<String, String> headers, SalesforceException ex) {
                BulkApiProcessor.this.processResponse(exchange, jobInfo, headers, ex, callback);
            }
        });
    }

    private void processCreateBatch(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        InputStream request;
        ContentType contentType = ContentType.fromValue(this.getParameter("contentType", exchange, false, false));
        String jobId = this.getParameter("jobId", exchange, false, false);
        try {
            request = exchange.getIn().getMandatoryBody(InputStream.class);
        }
        catch (CamelException e) {
            String msg = "Error preparing batch request: " + e.getMessage();
            throw new SalesforceException(msg, e);
        }
        this.bulkClient.createBatch(request, jobId, contentType, this.determineHeaders(exchange), new BulkApiClient.BatchInfoResponseCallback(){

            @Override
            public void onResponse(BatchInfo batchInfo, Map<String, String> headers, SalesforceException ex) {
                BulkApiProcessor.this.processResponse(exchange, batchInfo, headers, ex, callback);
            }
        });
    }

    private void processGetBatch(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String batchId;
        String jobId;
        BatchInfo batchBody = exchange.getIn().getBody(BatchInfo.class);
        if (batchBody != null) {
            jobId = batchBody.getJobId();
            batchId = batchBody.getId();
        } else {
            jobId = this.getParameter("jobId", exchange, false, false);
            batchId = this.getParameter("batchId", exchange, true, false);
        }
        this.bulkClient.getBatch(jobId, batchId, this.determineHeaders(exchange), new BulkApiClient.BatchInfoResponseCallback(){

            @Override
            public void onResponse(BatchInfo batchInfo, Map<String, String> headers, SalesforceException ex) {
                BulkApiProcessor.this.processResponse(exchange, batchInfo, headers, ex, callback);
            }
        });
    }

    private void processGetAllBatches(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        JobInfo jobBody = exchange.getIn().getBody(JobInfo.class);
        String jobId = jobBody != null ? jobBody.getId() : this.getParameter("jobId", exchange, true, false);
        this.bulkClient.getAllBatches(jobId, this.determineHeaders(exchange), new BulkApiClient.BatchInfoListResponseCallback(){

            @Override
            public void onResponse(List<BatchInfo> batchInfoList, Map<String, String> headers, SalesforceException ex) {
                BulkApiProcessor.this.processResponse(exchange, batchInfoList, headers, ex, callback);
            }
        });
    }

    private void processGetRequest(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String batchId;
        String jobId;
        BatchInfo batchBody = exchange.getIn().getBody(BatchInfo.class);
        if (batchBody != null) {
            jobId = batchBody.getJobId();
            batchId = batchBody.getId();
        } else {
            jobId = this.getParameter("jobId", exchange, false, false);
            batchId = this.getParameter("batchId", exchange, true, false);
        }
        this.bulkClient.getRequest(jobId, batchId, this.determineHeaders(exchange), new BulkApiClient.StreamResponseCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResponse(InputStream inputStream, Map<String, String> headers, SalesforceException ex) {
                StreamCache body = null;
                if (inputStream != null) {
                    try {
                        body = StreamCacheConverter.convertToStreamCache(inputStream, exchange);
                    }
                    catch (IOException e) {
                        String msg = "Error retrieving batch request: " + e.getMessage();
                        ex = new SalesforceException(msg, e);
                    }
                    finally {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                BulkApiProcessor.this.processResponse(exchange, body, headers, ex, callback);
            }
        });
    }

    private void processGetResults(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String batchId;
        String jobId;
        BatchInfo batchBody = exchange.getIn().getBody(BatchInfo.class);
        if (batchBody != null) {
            jobId = batchBody.getJobId();
            batchId = batchBody.getId();
        } else {
            jobId = this.getParameter("jobId", exchange, false, false);
            batchId = this.getParameter("batchId", exchange, true, false);
        }
        this.bulkClient.getResults(jobId, batchId, this.determineHeaders(exchange), new BulkApiClient.StreamResponseCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResponse(InputStream inputStream, Map<String, String> headers, SalesforceException ex) {
                StreamCache body = null;
                if (inputStream != null) {
                    try {
                        body = StreamCacheConverter.convertToStreamCache(inputStream, exchange);
                    }
                    catch (IOException e) {
                        String msg = "Error retrieving batch results: " + e.getMessage();
                        ex = new SalesforceException(msg, e);
                    }
                    finally {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                BulkApiProcessor.this.processResponse(exchange, body, headers, ex, callback);
            }
        });
    }

    private void processCreateBatchQuery(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String soqlQuery;
        ContentType contentType;
        String jobId;
        JobInfo jobBody = exchange.getIn().getBody(JobInfo.class);
        if (jobBody != null) {
            jobId = jobBody.getId();
            contentType = jobBody.getContentType();
            soqlQuery = this.getParameter("sObjectQuery", exchange, false, false);
        } else {
            jobId = this.getParameter("jobId", exchange, false, false);
            contentType = ContentType.fromValue(this.getParameter("contentType", exchange, false, false));
            soqlQuery = this.getParameter("sObjectQuery", exchange, true, false);
        }
        this.bulkClient.createBatchQuery(jobId, soqlQuery, contentType, this.determineHeaders(exchange), new BulkApiClient.BatchInfoResponseCallback(){

            @Override
            public void onResponse(BatchInfo batchInfo, Map<String, String> headers, SalesforceException ex) {
                BulkApiProcessor.this.processResponse(exchange, batchInfo, headers, ex, callback);
            }
        });
    }

    private void processGetQueryResultIds(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String batchId;
        String jobId;
        BatchInfo batchBody = exchange.getIn().getBody(BatchInfo.class);
        if (batchBody != null) {
            jobId = batchBody.getJobId();
            batchId = batchBody.getId();
        } else {
            jobId = this.getParameter("jobId", exchange, false, false);
            batchId = this.getParameter("batchId", exchange, true, false);
        }
        this.bulkClient.getQueryResultIds(jobId, batchId, this.determineHeaders(exchange), new BulkApiClient.QueryResultIdsCallback(){

            @Override
            public void onResponse(List<String> ids, Map<String, String> headers, SalesforceException ex) {
                BulkApiProcessor.this.processResponse(exchange, ids, headers, ex, callback);
            }
        });
    }

    private void processGetQueryResult(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String resultId;
        String batchId;
        String jobId;
        BatchInfo batchBody = exchange.getIn().getBody(BatchInfo.class);
        if (batchBody != null) {
            jobId = batchBody.getJobId();
            batchId = batchBody.getId();
            resultId = this.getParameter("resultId", exchange, false, false);
        } else {
            jobId = this.getParameter("jobId", exchange, false, false);
            batchId = this.getParameter("batchId", exchange, false, false);
            resultId = this.getParameter("resultId", exchange, true, false);
        }
        this.bulkClient.getQueryResult(jobId, batchId, resultId, this.determineHeaders(exchange), new BulkApiClient.StreamResponseCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResponse(InputStream inputStream, Map<String, String> headers, SalesforceException ex) {
                StreamCache body = null;
                if (inputStream != null) {
                    try {
                        body = StreamCacheConverter.convertToStreamCache(inputStream, exchange);
                    }
                    catch (IOException e) {
                        String msg = "Error retrieving query result: " + e.getMessage();
                        ex = new SalesforceException(msg, e);
                    }
                    finally {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                BulkApiProcessor.this.processResponse(exchange, body, headers, ex, callback);
            }
        });
    }

    private void processResponse(Exchange exchange, Object body, Map<String, String> headers, SalesforceException ex, AsyncCallback callback) {
        Message out = exchange.getOut();
        if (ex != null) {
            exchange.setException(ex);
        } else {
            out.setBody(body);
        }
        Message inboundMessage = exchange.getIn();
        Map<String, Object> outboundHeaders = out.getHeaders();
        outboundHeaders.putAll(inboundMessage.getHeaders());
        outboundHeaders.putAll(headers);
        callback.done(false);
    }
}

