/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal.processor;

import java.io.InputStream;
import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelException;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.component.salesforce.SalesforceEndpoint;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.api.dto.bulkv2.Job;
import org.apache.camel.component.salesforce.api.dto.bulkv2.JobStateEnum;
import org.apache.camel.component.salesforce.api.dto.bulkv2.Jobs;
import org.apache.camel.component.salesforce.api.dto.bulkv2.QueryJob;
import org.apache.camel.component.salesforce.api.dto.bulkv2.QueryJobs;
import org.apache.camel.component.salesforce.internal.client.BulkApiV2Client;
import org.apache.camel.component.salesforce.internal.client.DefaultBulkApiV2Client;
import org.apache.camel.component.salesforce.internal.processor.AbstractSalesforceProcessor;
import org.apache.camel.support.service.ServiceHelper;

public class BulkApiV2Processor
extends AbstractSalesforceProcessor {
    private BulkApiV2Client bulkClient;

    public BulkApiV2Processor(SalesforceEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        boolean done = false;
        try {
            switch (this.operationName) {
                case BULK2_CREATE_JOB: {
                    this.processCreateJob(exchange, callback);
                    break;
                }
                case BULK2_GET_JOB: {
                    this.processGetJob(exchange, callback);
                    break;
                }
                case BULK2_CREATE_BATCH: {
                    this.processCreateBatch(exchange, callback);
                    break;
                }
                case BULK2_CLOSE_JOB: {
                    this.processCloseJob(exchange, callback);
                    break;
                }
                case BULK2_ABORT_JOB: {
                    this.processAbortJob(exchange, callback);
                    break;
                }
                case BULK2_DELETE_JOB: {
                    this.deleteJob(exchange, callback);
                    break;
                }
                case BULK2_GET_SUCCESSFUL_RESULTS: {
                    this.processGetSuccessfulResults(exchange, callback);
                    break;
                }
                case BULK2_GET_FAILED_RESULTS: {
                    this.processGetFailedResults(exchange, callback);
                    break;
                }
                case BULK2_GET_UNPROCESSED_RECORDS: {
                    this.processGetUnprocessedRecords(exchange, callback);
                    break;
                }
                case BULK2_GET_ALL_JOBS: {
                    this.processGetAllJobs(exchange, callback);
                    break;
                }
                case BULK2_CREATE_QUERY_JOB: {
                    this.processCreateQueryJob(exchange, callback);
                    break;
                }
                case BULK2_GET_QUERY_JOB: {
                    this.processGetQueryJob(exchange, callback);
                    break;
                }
                case BULK2_GET_QUERY_JOB_RESULTS: {
                    this.processGetQueryJobResults(exchange, callback);
                    break;
                }
                case BULK2_ABORT_QUERY_JOB: {
                    this.processAbortQueryJob(exchange, callback);
                    break;
                }
                case BULK2_DELETE_QUERY_JOB: {
                    this.processDeleteQueryJob(exchange, callback);
                    break;
                }
                case BULK2_GET_ALL_QUERY_JOBS: {
                    this.processGetAllQueryJobs(exchange, callback);
                    break;
                }
                default: {
                    throw new SalesforceException("Unknown operation name: " + this.operationName.value(), null);
                }
            }
        }
        catch (SalesforceException e) {
            exchange.setException(new SalesforceException(String.format("Error processing %s: [%s] \"%s\"", this.operationName.value(), e.getStatusCode(), e.getMessage()), e));
            callback.done(true);
            done = true;
        }
        catch (RuntimeException | InvalidPayloadException e) {
            exchange.setException(new SalesforceException(String.format("Unexpected Error processing %s: \"%s\"", this.operationName.value(), e.getMessage()), e));
            callback.done(true);
            done = true;
        }
        return done;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.bulkClient = new DefaultBulkApiV2Client((String)this.endpointConfigMap.get("apiVersion"), this.session, this.httpClient, this.loginConfig, this.endpoint);
        ServiceHelper.startService((Object)this.bulkClient);
    }

    @Override
    public void doStop() {
        ServiceHelper.stopService((Object)this.bulkClient);
    }

    private void processCreateJob(final Exchange exchange, final AsyncCallback callback) throws InvalidPayloadException {
        Job job = exchange.getIn().getMandatoryBody(Job.class);
        this.bulkClient.createJob(job, this.determineHeaders(exchange), new BulkApiV2Client.JobResponseCallback(){

            @Override
            public void onResponse(Job job, Map<String, String> headers, SalesforceException ex) {
                BulkApiV2Processor.this.processResponse(exchange, job, headers, ex, callback);
            }
        });
    }

    private void processGetJob(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        Job job = exchange.getIn().getBody(Job.class);
        String jobId = job != null ? job.getId() : this.getParameter("jobId", exchange, true, false);
        this.bulkClient.getJob(jobId, this.determineHeaders(exchange), new BulkApiV2Client.JobResponseCallback(){

            @Override
            public void onResponse(Job job, Map<String, String> headers, SalesforceException ex) {
                BulkApiV2Processor.this.processResponse(exchange, job, headers, ex, callback);
            }
        });
    }

    private void processCreateBatch(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        InputStream input;
        String jobId = this.getParameter("jobId", exchange, false, false);
        try {
            input = exchange.getIn().getMandatoryBody(InputStream.class);
        }
        catch (CamelException e) {
            String msg = "Error preparing batch request: " + e.getMessage();
            throw new SalesforceException(msg, e);
        }
        this.bulkClient.createBatch(input, jobId, this.determineHeaders(exchange), new BulkApiV2Client.ResponseCallback(){

            @Override
            public void onResponse(Map<String, String> headers, SalesforceException ex) {
                BulkApiV2Processor.this.processResponse(exchange, null, headers, ex, callback);
            }
        });
    }

    private void deleteJob(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String jobId = this.getParameter("jobId", exchange, false, false);
        this.bulkClient.deleteJob(jobId, this.determineHeaders(exchange), new BulkApiV2Client.ResponseCallback(){

            @Override
            public void onResponse(Map<String, String> headers, SalesforceException ex) {
                BulkApiV2Processor.this.processResponse(exchange, null, headers, ex, callback);
            }
        });
    }

    private void processAbortJob(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String jobId = this.getParameter("jobId", exchange, false, false);
        this.bulkClient.changeJobState(jobId, JobStateEnum.ABORTED, this.determineHeaders(exchange), new BulkApiV2Client.JobResponseCallback(){

            @Override
            public void onResponse(Job job, Map<String, String> headers, SalesforceException ex) {
                BulkApiV2Processor.this.processResponse(exchange, job, headers, ex, callback);
            }
        });
    }

    private void processCloseJob(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String jobId = this.getParameter("jobId", exchange, false, false);
        this.bulkClient.changeJobState(jobId, JobStateEnum.UPLOAD_COMPLETE, this.determineHeaders(exchange), new BulkApiV2Client.JobResponseCallback(){

            @Override
            public void onResponse(Job job, Map<String, String> headers, SalesforceException ex) {
                BulkApiV2Processor.this.processResponse(exchange, job, headers, ex, callback);
            }
        });
    }

    private void processGetAllJobs(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String queryLocator = this.getParameter("queryLocator", exchange, false, true);
        this.bulkClient.getAllJobs(queryLocator, this.determineHeaders(exchange), new BulkApiV2Client.JobsResponseCallback(){

            @Override
            public void onResponse(Jobs jobs, Map<String, String> headers, SalesforceException ex) {
                BulkApiV2Processor.this.processResponse(exchange, jobs, headers, ex, callback);
            }
        });
    }

    private void processGetSuccessfulResults(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String jobId = this.getParameter("jobId", exchange, false, false);
        this.bulkClient.getSuccessfulResults(jobId, this.determineHeaders(exchange), new BulkApiV2Client.StreamResponseCallback(){

            @Override
            public void onResponse(InputStream inputStream, Map<String, String> headers, SalesforceException ex) {
                BulkApiV2Processor.this.processResponse(exchange, inputStream, headers, ex, callback);
            }
        });
    }

    private void processGetFailedResults(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String jobId = this.getParameter("jobId", exchange, false, false);
        this.bulkClient.getFailedResults(jobId, this.determineHeaders(exchange), new BulkApiV2Client.StreamResponseCallback(){

            @Override
            public void onResponse(InputStream inputStream, Map<String, String> headers, SalesforceException ex) {
                BulkApiV2Processor.this.processResponse(exchange, inputStream, headers, ex, callback);
            }
        });
    }

    private void processGetUnprocessedRecords(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String jobId = this.getParameter("jobId", exchange, false, false);
        this.bulkClient.getUnprocessedRecords(jobId, this.determineHeaders(exchange), new BulkApiV2Client.StreamResponseCallback(){

            @Override
            public void onResponse(InputStream inputStream, Map<String, String> headers, SalesforceException ex) {
                BulkApiV2Processor.this.processResponse(exchange, inputStream, headers, ex, callback);
            }
        });
    }

    private void processCreateQueryJob(final Exchange exchange, final AsyncCallback callback) throws InvalidPayloadException {
        QueryJob job = exchange.getIn().getMandatoryBody(QueryJob.class);
        this.bulkClient.createQueryJob(job, this.determineHeaders(exchange), new BulkApiV2Client.QueryJobResponseCallback(){

            @Override
            public void onResponse(QueryJob job, Map<String, String> headers, SalesforceException ex) {
                BulkApiV2Processor.this.processResponse(exchange, job, headers, ex, callback);
            }
        });
    }

    private void processGetQueryJob(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        QueryJob job = exchange.getIn().getBody(QueryJob.class);
        String jobId = job != null ? job.getId() : this.getParameter("jobId", exchange, true, false);
        this.bulkClient.getQueryJob(jobId, this.determineHeaders(exchange), new BulkApiV2Client.QueryJobResponseCallback(){

            @Override
            public void onResponse(QueryJob job, Map<String, String> headers, SalesforceException ex) {
                BulkApiV2Processor.this.processResponse(exchange, job, headers, ex, callback);
            }
        });
    }

    private void processGetQueryJobResults(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String jobId = this.getParameter("jobId", exchange, false, false);
        String locator = this.getParameter("locator", exchange, false, true);
        Integer maxRecords = this.getParameter("maxRecords", exchange, false, true, Integer.class);
        this.bulkClient.getQueryJobResults(jobId, locator, maxRecords, this.determineHeaders(exchange), new BulkApiV2Client.StreamResponseCallback(){

            @Override
            public void onResponse(InputStream inputStream, Map<String, String> headers, SalesforceException ex) {
                BulkApiV2Processor.this.processResponse(exchange, inputStream, headers, ex, callback);
            }
        });
    }

    private void processAbortQueryJob(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String jobId = this.getParameter("jobId", exchange, false, false);
        this.bulkClient.changeQueryJobState(jobId, JobStateEnum.ABORTED, this.determineHeaders(exchange), new BulkApiV2Client.QueryJobResponseCallback(){

            @Override
            public void onResponse(QueryJob job, Map<String, String> headers, SalesforceException ex) {
                BulkApiV2Processor.this.processResponse(exchange, job, headers, ex, callback);
            }
        });
    }

    private void processDeleteQueryJob(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String jobId = this.getParameter("jobId", exchange, false, false);
        this.bulkClient.deleteQueryJob(jobId, this.determineHeaders(exchange), new BulkApiV2Client.ResponseCallback(){

            @Override
            public void onResponse(Map<String, String> headers, SalesforceException ex) {
                BulkApiV2Processor.this.processResponse(exchange, null, headers, ex, callback);
            }
        });
    }

    private void processGetAllQueryJobs(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String queryLocator = this.getParameter("queryLocator", exchange, false, true);
        this.bulkClient.getAllQueryJobs(queryLocator, this.determineHeaders(exchange), new BulkApiV2Client.QueryJobsResponseCallback(){

            @Override
            public void onResponse(QueryJobs jobs, Map<String, String> headers, SalesforceException ex) {
                BulkApiV2Processor.this.processResponse(exchange, jobs, headers, ex, callback);
            }
        });
    }

    private void processResponse(Exchange exchange, Object body, Map<String, String> headers, SalesforceException ex, AsyncCallback callback) {
        Message message = exchange.getMessage();
        if (ex != null) {
            exchange.setException(ex);
        } else {
            message.setBody(body);
        }
        message.getHeaders().putAll(headers);
        callback.done(false);
    }
}

