/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import org.apache.camel.TypeConverter;
import org.apache.camel.impl.converter.ConverterStatistics;
import org.apache.camel.spi.TypeConvertible;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TypeConverterStatistics
implements ConverterStatistics {
    private static final Logger LOG = LoggerFactory.getLogger(TypeConverterStatistics.class);
    private final LongAdder noopCounter = new LongAdder();
    private final LongAdder attemptCounter = new LongAdder();
    private final LongAdder missCounter = new LongAdder();
    private final LongAdder hitCounter = new LongAdder();
    private final LongAdder failedCounter = new LongAdder();

    TypeConverterStatistics() {
    }

    @Override
    public long getNoopCounter() {
        return this.noopCounter.longValue();
    }

    @Override
    public long getAttemptCounter() {
        return this.attemptCounter.longValue();
    }

    @Override
    public long getHitCounter() {
        return this.hitCounter.longValue();
    }

    @Override
    public long getMissCounter() {
        return this.missCounter.longValue();
    }

    @Override
    public long getFailedCounter() {
        return this.failedCounter.longValue();
    }

    @Override
    public boolean isStatisticsEnabled() {
        return true;
    }

    @Override
    public void incrementFailed() {
        this.failedCounter.increment();
    }

    @Override
    public void incrementNoop() {
        this.noopCounter.increment();
    }

    @Override
    public void incrementHit() {
        this.hitCounter.increment();
    }

    @Override
    public void incrementMiss() {
        this.missCounter.increment();
    }

    @Override
    public void incrementAttempt() {
        this.attemptCounter.increment();
    }

    @Override
    public void reset() {
        this.noopCounter.reset();
        this.attemptCounter.reset();
        this.hitCounter.reset();
        this.missCounter.reset();
        this.failedCounter.reset();
    }

    private static AtomicInteger computeCachedMisses(Map<TypeConvertible<?, ?>, TypeConverter> converters, TypeConverter missConverter) {
        AtomicInteger misses = new AtomicInteger();
        converters.forEach((k, v) -> {
            if (v == missConverter) {
                misses.incrementAndGet();
            }
        });
        return misses;
    }

    @Override
    public void logMappingStatisticsMessage(Map<TypeConvertible<?, ?>, TypeConverter> converters, TypeConverter missConverter) {
        AtomicInteger misses = TypeConverterStatistics.computeCachedMisses(converters, missConverter);
        LOG.info("TypeConverterStatistics utilization[noop={}, attempts={}, hits={}, misses={}, failures={}] mappings[total={}, misses={}]", new Object[]{this.getNoopCounter(), this.getAttemptCounter(), this.getHitCounter(), this.getMissCounter(), this.getFailedCounter(), converters.size(), misses});
    }
}

