/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiFunction;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Channel;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.StartupStep;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.model.AggregationStrategyAwareDefinition;
import org.apache.camel.model.BeanDefinition;
import org.apache.camel.model.CatchDefinition;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.CircuitBreakerDefinition;
import org.apache.camel.model.ClaimCheckDefinition;
import org.apache.camel.model.ConvertBodyDefinition;
import org.apache.camel.model.ConvertHeaderDefinition;
import org.apache.camel.model.ConvertVariableDefinition;
import org.apache.camel.model.DelayDefinition;
import org.apache.camel.model.DynamicRouterDefinition;
import org.apache.camel.model.EnrichDefinition;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.FilterDefinition;
import org.apache.camel.model.FinallyDefinition;
import org.apache.camel.model.IdempotentConsumerDefinition;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.InterceptFromDefinition;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.KameletDefinition;
import org.apache.camel.model.LoadBalanceDefinition;
import org.apache.camel.model.LogDefinition;
import org.apache.camel.model.LoopDefinition;
import org.apache.camel.model.MarshalDefinition;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.OnFallbackDefinition;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.model.OtherwiseDefinition;
import org.apache.camel.model.PausableDefinition;
import org.apache.camel.model.PipelineDefinition;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.model.PollDefinition;
import org.apache.camel.model.PollEnrichDefinition;
import org.apache.camel.model.ProcessDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RecipientListDefinition;
import org.apache.camel.model.RemoveHeaderDefinition;
import org.apache.camel.model.RemoveHeadersDefinition;
import org.apache.camel.model.RemovePropertiesDefinition;
import org.apache.camel.model.RemovePropertyDefinition;
import org.apache.camel.model.RemoveVariableDefinition;
import org.apache.camel.model.ResequenceDefinition;
import org.apache.camel.model.ResumableDefinition;
import org.apache.camel.model.RollbackDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteDefinitionHelper;
import org.apache.camel.model.RoutingSlipDefinition;
import org.apache.camel.model.SagaDefinition;
import org.apache.camel.model.SamplingDefinition;
import org.apache.camel.model.ScriptDefinition;
import org.apache.camel.model.SetBodyDefinition;
import org.apache.camel.model.SetExchangePatternDefinition;
import org.apache.camel.model.SetHeaderDefinition;
import org.apache.camel.model.SetHeadersDefinition;
import org.apache.camel.model.SetPropertyDefinition;
import org.apache.camel.model.SetVariableDefinition;
import org.apache.camel.model.SetVariablesDefinition;
import org.apache.camel.model.SortDefinition;
import org.apache.camel.model.SplitDefinition;
import org.apache.camel.model.StepDefinition;
import org.apache.camel.model.StopDefinition;
import org.apache.camel.model.ThreadsDefinition;
import org.apache.camel.model.ThrottleDefinition;
import org.apache.camel.model.ThrowExceptionDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.model.ToDynamicDefinition;
import org.apache.camel.model.TokenizerDefinition;
import org.apache.camel.model.TransactedDefinition;
import org.apache.camel.model.TransformDefinition;
import org.apache.camel.model.TryDefinition;
import org.apache.camel.model.UnmarshalDefinition;
import org.apache.camel.model.ValidateDefinition;
import org.apache.camel.model.WhenDefinition;
import org.apache.camel.model.WhenSkipSendToEndpointDefinition;
import org.apache.camel.model.WireTapDefinition;
import org.apache.camel.model.cloud.ServiceCallDefinition;
import org.apache.camel.processor.InterceptEndpointProcessor;
import org.apache.camel.processor.Pipeline;
import org.apache.camel.processor.aggregate.AggregationStrategyBeanAdapter;
import org.apache.camel.processor.aggregate.AggregationStrategyBiFunctionAdapter;
import org.apache.camel.reifier.AbstractReifier;
import org.apache.camel.reifier.AggregateReifier;
import org.apache.camel.reifier.BeanReifier;
import org.apache.camel.reifier.CatchReifier;
import org.apache.camel.reifier.ChoiceReifier;
import org.apache.camel.reifier.CircuitBreakerReifier;
import org.apache.camel.reifier.ClaimCheckReifier;
import org.apache.camel.reifier.ConvertBodyReifier;
import org.apache.camel.reifier.ConvertHeaderReifier;
import org.apache.camel.reifier.ConvertVariableReifier;
import org.apache.camel.reifier.DelayReifier;
import org.apache.camel.reifier.DisabledReifier;
import org.apache.camel.reifier.DynamicRouterReifier;
import org.apache.camel.reifier.EnrichReifier;
import org.apache.camel.reifier.FilterReifier;
import org.apache.camel.reifier.FinallyReifier;
import org.apache.camel.reifier.IdempotentConsumerReifier;
import org.apache.camel.reifier.InterceptFromReifier;
import org.apache.camel.reifier.InterceptReifier;
import org.apache.camel.reifier.InterceptSendToEndpointReifier;
import org.apache.camel.reifier.KameletReifier;
import org.apache.camel.reifier.LoadBalanceReifier;
import org.apache.camel.reifier.LogReifier;
import org.apache.camel.reifier.LoopReifier;
import org.apache.camel.reifier.MarshalReifier;
import org.apache.camel.reifier.MulticastReifier;
import org.apache.camel.reifier.OnCompletionReifier;
import org.apache.camel.reifier.OnExceptionReifier;
import org.apache.camel.reifier.OnFallbackReifier;
import org.apache.camel.reifier.OtherwiseReifier;
import org.apache.camel.reifier.PausableReifier;
import org.apache.camel.reifier.PipelineReifier;
import org.apache.camel.reifier.PolicyReifier;
import org.apache.camel.reifier.PollEnrichReifier;
import org.apache.camel.reifier.PollReifier;
import org.apache.camel.reifier.ProcessReifier;
import org.apache.camel.reifier.RecipientListReifier;
import org.apache.camel.reifier.RemoveHeaderReifier;
import org.apache.camel.reifier.RemoveHeadersReifier;
import org.apache.camel.reifier.RemovePropertiesReifier;
import org.apache.camel.reifier.RemovePropertyReifier;
import org.apache.camel.reifier.RemoveVariableReifier;
import org.apache.camel.reifier.ResequenceReifier;
import org.apache.camel.reifier.ResumableReifier;
import org.apache.camel.reifier.RollbackReifier;
import org.apache.camel.reifier.RoutingSlipReifier;
import org.apache.camel.reifier.SagaReifier;
import org.apache.camel.reifier.SamplingReifier;
import org.apache.camel.reifier.ScriptReifier;
import org.apache.camel.reifier.SendReifier;
import org.apache.camel.reifier.ServiceCallReifier;
import org.apache.camel.reifier.SetBodyReifier;
import org.apache.camel.reifier.SetExchangePatternReifier;
import org.apache.camel.reifier.SetHeaderReifier;
import org.apache.camel.reifier.SetHeadersReifier;
import org.apache.camel.reifier.SetPropertyReifier;
import org.apache.camel.reifier.SetVariableReifier;
import org.apache.camel.reifier.SetVariablesReifier;
import org.apache.camel.reifier.SortReifier;
import org.apache.camel.reifier.SplitReifier;
import org.apache.camel.reifier.StepReifier;
import org.apache.camel.reifier.StopReifier;
import org.apache.camel.reifier.ThreadsReifier;
import org.apache.camel.reifier.ThrottleReifier;
import org.apache.camel.reifier.ThrowExceptionReifier;
import org.apache.camel.reifier.ToDynamicReifier;
import org.apache.camel.reifier.TransactedReifier;
import org.apache.camel.reifier.TransformReifier;
import org.apache.camel.reifier.TryReifier;
import org.apache.camel.reifier.UnmarshalReifier;
import org.apache.camel.reifier.ValidateReifier;
import org.apache.camel.reifier.WhenReifier;
import org.apache.camel.reifier.WhenSkipSendToEndpointReifier;
import org.apache.camel.reifier.WireTapReifier;
import org.apache.camel.reifier.tokenizer.TokenizerReifier;
import org.apache.camel.spi.ErrorHandlerAware;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.NodeIdFactory;
import org.apache.camel.spi.ProcessorFactory;
import org.apache.camel.spi.ReifierStrategy;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProcessorReifier<T extends ProcessorDefinition<?>>
extends AbstractReifier {
    public static final String DISABLE_ALL_PROCESSORS = "DisableAllProcessors";
    private static final Logger LOG = LoggerFactory.getLogger(ProcessorReifier.class);
    private static final Map<Class<?>, BiFunction<Route, ProcessorDefinition<?>, ProcessorReifier<? extends ProcessorDefinition<?>>>> PROCESSORS = new HashMap(0);
    protected final T definition;

    public ProcessorReifier(Route route, T definition) {
        super(route);
        this.definition = definition;
    }

    public ProcessorReifier(CamelContext camelContext, T definition) {
        super(camelContext);
        this.definition = definition;
    }

    public static void registerReifier(Class<?> processorClass, BiFunction<Route, ProcessorDefinition<?>, ProcessorReifier<? extends ProcessorDefinition<?>>> creator) {
        if (PROCESSORS.isEmpty()) {
            ReifierStrategy.addReifierClearer(ProcessorReifier::clearReifiers);
        }
        PROCESSORS.put(processorClass, creator);
    }

    public static void clearReifiers() {
        PROCESSORS.clear();
    }

    public static ProcessorReifier<? extends ProcessorDefinition<?>> reifier(Route route, ProcessorDefinition<?> definition) {
        BiFunction<Route, ProcessorDefinition<?>, ProcessorReifier<ProcessorDefinition<?>>> reifier;
        ProcessorReifier<ProcessorDefinition<?>> answer = null;
        if (route != null && route.getCamelContext() != null) {
            Boolean disabled = CamelContextHelper.parseBoolean(route.getCamelContext(), definition.getDisabled());
            if (disabled == null) {
                disabled = "true".equalsIgnoreCase(route.getCamelContext().getGlobalOption(DISABLE_ALL_PROCESSORS));
            }
            if (disabled.booleanValue()) {
                return new DisabledReifier(route, definition);
            }
        }
        if (!PROCESSORS.isEmpty() && (reifier = PROCESSORS.get(definition.getClass())) != null) {
            answer = reifier.apply(route, definition);
        }
        if (answer == null) {
            answer = ProcessorReifier.coreReifier(route, definition);
        }
        if (answer == null) {
            throw new IllegalStateException("Unsupported definition: " + String.valueOf(definition));
        }
        return answer;
    }

    public static ProcessorReifier<? extends ProcessorDefinition<?>> coreReifier(Route route, ProcessorDefinition<?> definition) {
        if (definition instanceof AggregateDefinition) {
            return new AggregateReifier(route, definition);
        }
        if (definition instanceof BeanDefinition) {
            return new BeanReifier(route, definition);
        }
        if (definition instanceof CatchDefinition) {
            return new CatchReifier(route, definition);
        }
        if (definition instanceof ChoiceDefinition) {
            return new ChoiceReifier(route, definition);
        }
        if (definition instanceof CircuitBreakerDefinition) {
            return new CircuitBreakerReifier(route, definition);
        }
        if (definition instanceof ClaimCheckDefinition) {
            return new ClaimCheckReifier(route, definition);
        }
        if (definition instanceof ConvertBodyDefinition) {
            return new ConvertBodyReifier(route, definition);
        }
        if (definition instanceof ConvertHeaderDefinition) {
            return new ConvertHeaderReifier(route, definition);
        }
        if (definition instanceof ConvertVariableDefinition) {
            return new ConvertVariableReifier(route, definition);
        }
        if (definition instanceof DelayDefinition) {
            return new DelayReifier(route, definition);
        }
        if (definition instanceof DynamicRouterDefinition) {
            return new DynamicRouterReifier(route, definition);
        }
        if (definition instanceof EnrichDefinition) {
            return new EnrichReifier(route, definition);
        }
        if (definition instanceof FilterDefinition) {
            return new FilterReifier(route, definition);
        }
        if (definition instanceof FinallyDefinition) {
            return new FinallyReifier(route, definition);
        }
        if (definition instanceof IdempotentConsumerDefinition) {
            return new IdempotentConsumerReifier(route, definition);
        }
        if (definition instanceof InterceptFromDefinition) {
            return new InterceptFromReifier(route, definition);
        }
        if (definition instanceof InterceptDefinition) {
            return new InterceptReifier(route, definition);
        }
        if (definition instanceof InterceptSendToEndpointDefinition) {
            return new InterceptSendToEndpointReifier(route, definition);
        }
        if (definition instanceof KameletDefinition) {
            return new KameletReifier(route, definition);
        }
        if (definition instanceof LoadBalanceDefinition) {
            return new LoadBalanceReifier(route, definition);
        }
        if (definition instanceof LogDefinition) {
            return new LogReifier(route, definition);
        }
        if (definition instanceof LoopDefinition) {
            return new LoopReifier(route, definition);
        }
        if (definition instanceof MarshalDefinition) {
            return new MarshalReifier(route, definition);
        }
        if (definition instanceof MulticastDefinition) {
            return new MulticastReifier(route, definition);
        }
        if (definition instanceof OnCompletionDefinition) {
            return new OnCompletionReifier(route, definition);
        }
        if (definition instanceof OnExceptionDefinition) {
            return new OnExceptionReifier(route, definition);
        }
        if (definition instanceof OnFallbackDefinition) {
            return new OnFallbackReifier(route, definition);
        }
        if (definition instanceof OtherwiseDefinition) {
            return new OtherwiseReifier(route, definition);
        }
        if (definition instanceof PipelineDefinition) {
            return new PipelineReifier(route, definition);
        }
        if (definition instanceof PolicyDefinition) {
            return new PolicyReifier(route, definition);
        }
        if (definition instanceof PollDefinition) {
            return new PollReifier(route, definition);
        }
        if (definition instanceof PollEnrichDefinition) {
            return new PollEnrichReifier(route, definition);
        }
        if (definition instanceof ProcessDefinition) {
            return new ProcessReifier(route, definition);
        }
        if (definition instanceof RecipientListDefinition) {
            return new RecipientListReifier(route, definition);
        }
        if (definition instanceof RemoveHeaderDefinition) {
            return new RemoveHeaderReifier(route, definition);
        }
        if (definition instanceof RemoveHeadersDefinition) {
            return new RemoveHeadersReifier(route, definition);
        }
        if (definition instanceof RemovePropertyDefinition) {
            return new RemovePropertyReifier(route, definition);
        }
        if (definition instanceof RemovePropertiesDefinition) {
            return new RemovePropertiesReifier(route, definition);
        }
        if (definition instanceof RemoveVariableDefinition) {
            return new RemoveVariableReifier(route, definition);
        }
        if (definition instanceof ResequenceDefinition) {
            return new ResequenceReifier(route, definition);
        }
        if (definition instanceof RollbackDefinition) {
            return new RollbackReifier(route, definition);
        }
        if (definition instanceof RoutingSlipDefinition) {
            return new RoutingSlipReifier(route, definition);
        }
        if (definition instanceof SagaDefinition) {
            return new SagaReifier(route, definition);
        }
        if (definition instanceof SamplingDefinition) {
            return new SamplingReifier(route, definition);
        }
        if (definition instanceof ScriptDefinition) {
            return new ScriptReifier(route, definition);
        }
        if (definition instanceof ServiceCallDefinition) {
            return new ServiceCallReifier(route, definition);
        }
        if (definition instanceof SetBodyDefinition) {
            return new SetBodyReifier(route, definition);
        }
        if (definition instanceof SetExchangePatternDefinition) {
            return new SetExchangePatternReifier(route, definition);
        }
        if (definition instanceof SetHeaderDefinition) {
            return new SetHeaderReifier(route, definition);
        }
        if (definition instanceof SetHeadersDefinition) {
            return new SetHeadersReifier(route, definition);
        }
        if (definition instanceof SetPropertyDefinition) {
            return new SetPropertyReifier(route, definition);
        }
        if (definition instanceof SetVariableDefinition) {
            return new SetVariableReifier(route, definition);
        }
        if (definition instanceof SetVariablesDefinition) {
            return new SetVariablesReifier(route, definition);
        }
        if (definition instanceof SortDefinition) {
            return new SortReifier(route, definition);
        }
        if (definition instanceof SplitDefinition) {
            return new SplitReifier(route, definition);
        }
        if (definition instanceof StepDefinition) {
            return new StepReifier(route, definition);
        }
        if (definition instanceof StopDefinition) {
            return new StopReifier(route, definition);
        }
        if (definition instanceof ThreadsDefinition) {
            return new ThreadsReifier(route, definition);
        }
        if (definition instanceof ThrottleDefinition) {
            return new ThrottleReifier(route, definition);
        }
        if (definition instanceof ThrowExceptionDefinition) {
            return new ThrowExceptionReifier(route, definition);
        }
        if (definition instanceof ToDefinition) {
            return new SendReifier(route, definition);
        }
        if (definition instanceof WireTapDefinition) {
            return new WireTapReifier(route, definition);
        }
        if (definition instanceof ToDynamicDefinition) {
            return new ToDynamicReifier(route, definition);
        }
        if (definition instanceof TransactedDefinition) {
            return new TransactedReifier(route, definition);
        }
        if (definition instanceof TransformDefinition) {
            return new TransformReifier(route, definition);
        }
        if (definition instanceof TryDefinition) {
            return new TryReifier(route, definition);
        }
        if (definition instanceof UnmarshalDefinition) {
            return new UnmarshalReifier(route, definition);
        }
        if (definition instanceof ValidateDefinition) {
            return new ValidateReifier(route, definition);
        }
        if (definition instanceof WhenSkipSendToEndpointDefinition) {
            return new WhenSkipSendToEndpointReifier(route, definition);
        }
        if (definition instanceof WhenDefinition) {
            return new WhenReifier(route, definition);
        }
        if (definition instanceof ResumableDefinition) {
            return new ResumableReifier(route, definition);
        }
        if (definition instanceof PausableDefinition) {
            return new PausableReifier(route, definition);
        }
        if (definition instanceof TokenizerDefinition) {
            TokenizerDefinition td = (TokenizerDefinition)definition;
            return new TokenizerReifier<TokenizerDefinition>(route, td);
        }
        return null;
    }

    public boolean willCreateNewThreadPool(ExecutorServiceAwareDefinition<?> definition, boolean useDefault) {
        ExecutorServiceManager manager = this.camelContext.getExecutorServiceManager();
        ObjectHelper.notNull(manager, "ExecutorServiceManager", this.camelContext);
        if (definition.getExecutorServiceBean() != null) {
            return false;
        }
        if (definition.getExecutorServiceRef() != null) {
            ExecutorService answer = this.lookupByNameAndType(definition.getExecutorServiceRef(), ExecutorService.class);
            return answer == null;
        }
        return useDefault;
    }

    public ExecutorService getConfiguredExecutorService(String name, ExecutorServiceAwareDefinition<?> definition, boolean useDefault) throws IllegalArgumentException {
        ExecutorServiceManager manager = this.camelContext.getExecutorServiceManager();
        ObjectHelper.notNull(manager, "ExecutorServiceManager", this.camelContext);
        String ref = this.parseString(definition.getExecutorServiceRef());
        if (definition.getExecutorServiceBean() != null) {
            return definition.getExecutorServiceBean();
        }
        if (ref != null) {
            ExecutorService answer = this.lookupExecutorServiceRef(name, definition, ref);
            if (answer == null) {
                throw new IllegalArgumentException("ExecutorServiceRef " + definition.getExecutorServiceRef() + " not found in registry (as an ExecutorService instance) or as a thread pool profile.");
            }
            return answer;
        }
        if (useDefault) {
            return manager.newDefaultThreadPool(definition, name);
        }
        return null;
    }

    public ScheduledExecutorService getConfiguredScheduledExecutorService(String name, ExecutorServiceAwareDefinition<?> definition, boolean useDefault) throws IllegalArgumentException {
        ExecutorServiceManager manager = this.camelContext.getExecutorServiceManager();
        ObjectHelper.notNull(manager, "ExecutorServiceManager", this.camelContext);
        if (definition.getExecutorServiceBean() != null) {
            ExecutorService executorService = definition.getExecutorServiceBean();
            if (executorService instanceof ScheduledExecutorService) {
                ScheduledExecutorService scheduledExecutorService = (ScheduledExecutorService)executorService;
                return scheduledExecutorService;
            }
            throw new IllegalArgumentException("ExecutorServiceRef " + definition.getExecutorServiceRef() + " is not an ScheduledExecutorService instance");
        }
        if (definition.getExecutorServiceRef() != null) {
            ScheduledExecutorService answer = this.lookupScheduledExecutorServiceRef(name, definition, definition.getExecutorServiceRef());
            if (answer == null) {
                throw new IllegalArgumentException("ExecutorServiceRef " + definition.getExecutorServiceRef() + " not found in registry (as an ScheduledExecutorService instance) or as a thread pool profile.");
            }
            return answer;
        }
        if (useDefault) {
            return manager.newDefaultScheduledThreadPool(definition, name);
        }
        return null;
    }

    public ScheduledExecutorService lookupScheduledExecutorServiceRef(String name, Object source, String executorServiceRef) {
        ExecutorServiceManager manager = this.camelContext.getExecutorServiceManager();
        ObjectHelper.notNull(manager, "ExecutorServiceManager", this.camelContext);
        ObjectHelper.notNull(executorServiceRef, "executorServiceRef");
        ScheduledExecutorService answer = this.lookupByNameAndType(executorServiceRef, ScheduledExecutorService.class);
        if (answer == null) {
            answer = manager.newScheduledThreadPool(source, name, executorServiceRef);
        }
        return answer;
    }

    public ExecutorService lookupExecutorServiceRef(String name, Object source, String executorServiceRef) {
        ExecutorServiceManager manager = this.camelContext.getExecutorServiceManager();
        ObjectHelper.notNull(manager, "ExecutorServiceManager", this.camelContext);
        ObjectHelper.notNull(executorServiceRef, "executorServiceRef");
        ExecutorService answer = this.lookupByNameAndType(executorServiceRef, ExecutorService.class);
        if (answer == null) {
            answer = manager.newThreadPool(source, name, executorServiceRef);
        }
        return answer;
    }

    public boolean hasOutputs(List<ProcessorDefinition<?>> outputs, boolean excludeAbstract) {
        if (outputs == null || outputs.isEmpty()) {
            return false;
        }
        if (!excludeAbstract) {
            return true;
        }
        for (ProcessorDefinition<?> output : outputs) {
            if (output.isWrappingEntireOutput()) {
                return this.hasOutputs(output.getOutputs(), excludeAbstract);
            }
            if (output.isAbstract()) continue;
            return true;
        }
        return false;
    }

    public abstract Processor createProcessor() throws Exception;

    protected Processor createOutputsProcessor() throws Exception {
        List<ProcessorDefinition<?>> outputs = ((ProcessorDefinition)this.definition).getOutputs();
        return this.createOutputsProcessor(outputs);
    }

    protected Processor createChildProcessor(boolean mandatory) throws Exception {
        Processor children = null;
        ProcessorFactory processorFactory = PluginHelper.getProcessorFactory(this.camelContext);
        if (processorFactory != null) {
            children = processorFactory.createChildProcessor(this.route, (NamedNode)this.definition, mandatory);
        }
        if (children == null) {
            children = this.createOutputsProcessor();
        }
        if (children == null && mandatory) {
            throw new IllegalArgumentException("Definition has no children on " + String.valueOf(this.definition));
        }
        return children;
    }

    public void addRoutes() throws Exception {
        Channel processor = this.makeProcessor();
        if (processor == null) {
            return;
        }
        boolean endpointInterceptor = processor.getNextProcessor() instanceof InterceptEndpointProcessor;
        if (endpointInterceptor) {
            LOG.debug("Endpoint interceptor should not be added as an event driven consumer route: {}", (Object)processor);
        } else {
            LOG.trace("Adding event driven processor: {}", (Object)processor);
            this.route.getEventDrivenProcessors().add(processor);
        }
    }

    public Channel wrapProcessor(Processor processor) throws Exception {
        if (processor instanceof Channel) {
            Channel channel = (Channel)processor;
            return channel;
        }
        return this.wrapChannel(processor, null);
    }

    protected Channel wrapChannel(Processor processor, ProcessorDefinition<?> child) throws Exception {
        return this.wrapChannel(processor, child, ((ProcessorDefinition)this.definition).isInheritErrorHandler());
    }

    protected Channel wrapChannel(Processor processor, ProcessorDefinition<?> child, Boolean inheritErrorHandler) throws Exception {
        Channel channel = PluginHelper.getInternalProcessorFactory(this.camelContext).createChannel(this.camelContext);
        ArrayList<InterceptStrategy> interceptors = new ArrayList<InterceptStrategy>();
        interceptors.addAll(this.camelContext.getCamelContextExtension().getInterceptStrategies());
        interceptors.addAll(this.route.getInterceptStrategies());
        interceptors.addAll(((ProcessorDefinition)this.definition).getInterceptStrategies());
        RouteDefinitionHelper.forceAssignIds(this.camelContext, this.definition);
        if (child != null && this.definition != child) {
            child.setParent((ProcessorDefinition<?>)this.definition);
        }
        RouteDefinition route = ProcessorDefinitionHelper.getRoute(this.definition);
        boolean first = false;
        if (route != null && !route.getOutputs().isEmpty()) {
            first = route.getOutputs().get(0) == this.definition;
        }
        channel.initChannel(this.route, (NamedNode)this.definition, child, (List<InterceptStrategy>)interceptors, processor, route, first);
        boolean wrap = false;
        if (this.definition instanceof TryDefinition || this.definition instanceof CatchDefinition || this.definition instanceof FinallyDefinition) {
            LOG.trace("{} is part of doTry .. doCatch .. doFinally so no error handler is applied", this.definition);
        } else if (ProcessorDefinitionHelper.isParentOfType(TryDefinition.class, this.definition, true) || ProcessorDefinitionHelper.isParentOfType(CatchDefinition.class, this.definition, true) || ProcessorDefinitionHelper.isParentOfType(FinallyDefinition.class, this.definition, true)) {
            LOG.trace("{} is part of doTry .. doCatch .. doFinally so no error handler is applied", this.definition);
        } else if (this.definition instanceof OnExceptionDefinition || ProcessorDefinitionHelper.isParentOfType(OnExceptionDefinition.class, this.definition, true)) {
            LOG.trace("{} is part of OnException so no error handler is applied", this.definition);
        } else if (this.definition instanceof CircuitBreakerDefinition || ProcessorDefinitionHelper.isParentOfType(CircuitBreakerDefinition.class, this.definition, true)) {
            if (inheritErrorHandler != null && inheritErrorHandler.booleanValue() && child == null) {
                wrap = true;
            } else {
                LOG.trace("{} is part of CircuitBreaker so no error handler is applied", this.definition);
            }
        } else {
            T t2 = this.definition;
            if (t2 instanceof MulticastDefinition) {
                MulticastDefinition def = (MulticastDefinition)t2;
                boolean isShareUnitOfWork = this.parseBoolean(def.getShareUnitOfWork(), false);
                if (isShareUnitOfWork && child == null) {
                    wrap = true;
                } else {
                    LOG.trace("{} is part of multicast which have special error handling so no error handler is applied", this.definition);
                }
            } else {
                wrap = true;
            }
        }
        if (wrap) {
            this.wrapChannelInErrorHandler(channel, inheritErrorHandler);
        }
        channel.postInitChannel();
        LOG.trace("{} wrapped in Channel: {}", this.definition, (Object)channel);
        return channel;
    }

    private void wrapChannelInErrorHandler(Channel channel, Boolean inheritErrorHandler) throws Exception {
        if (inheritErrorHandler == null || inheritErrorHandler.booleanValue()) {
            LOG.trace("{} is configured to inheritErrorHandler", this.definition);
            Processor output = channel.getOutput();
            Processor errorHandler = this.wrapInErrorHandler(output);
            channel.setErrorHandler(errorHandler);
        } else {
            LOG.debug("{} is configured to not inheritErrorHandler.", this.definition);
        }
    }

    protected Processor wrapInErrorHandler(Processor output) throws Exception {
        ErrorHandlerFactory builder = this.route.getErrorHandlerFactory();
        Processor errorHandler = ((ModelCamelContext)this.camelContext).getModelReifierFactory().createErrorHandler(this.route, builder, output);
        if (output instanceof ErrorHandlerAware) {
            ErrorHandlerAware errorHandlerAware = (ErrorHandlerAware)((Object)output);
            errorHandlerAware.setErrorHandler(errorHandler);
        }
        return errorHandler;
    }

    protected Processor createCompositeProcessor(List<Processor> list) throws Exception {
        return Pipeline.newInstance(this.camelContext, list);
    }

    protected Processor createOutputsProcessor(Collection<ProcessorDefinition<?>> outputs) throws Exception {
        return this.createOutputsProcessor(outputs, true);
    }

    protected Processor createOutputsProcessor(Collection<ProcessorDefinition<?>> outputs, boolean optimize) throws Exception {
        ArrayList<Processor> list = new ArrayList<Processor>();
        for (ProcessorDefinition<?> output : outputs) {
            ProcessorReifier.reifier(this.route, output).preCreateProcessor();
            Processor processor = this.createProcessor(output);
            if (processor instanceof IdAware) {
                IdAware idAware = (IdAware)((Object)processor);
                String id = this.getId(output);
                idAware.setId(id);
            }
            if (processor instanceof RouteIdAware) {
                RouteIdAware routeIdAware = (RouteIdAware)((Object)processor);
                routeIdAware.setRouteId(this.route.getRouteId());
            }
            if (output instanceof Channel && processor == null) continue;
            Channel channel = this.wrapChannel(processor, output);
            list.add(channel);
        }
        Processor processor = null;
        if (!list.isEmpty()) {
            processor = optimize && list.size() == 1 ? (Processor)list.get(0) : this.createCompositeProcessor(list);
        }
        return processor;
    }

    protected Processor createProcessor(ProcessorDefinition<?> output) throws Exception {
        String outputId = output.idOrCreate(this.camelContext.getCamelContextExtension().getContextPlugin(NodeIdFactory.class));
        StartupStep step = this.camelContext.getCamelContextExtension().getStartupStepRecorder().beginStep(ProcessorReifier.class, outputId, "Create processor");
        Processor processor = null;
        ProcessorFactory processorFactory = PluginHelper.getProcessorFactory(this.camelContext);
        if (processorFactory != null) {
            processor = processorFactory.createProcessor(this.route, output);
        }
        if (processor == null) {
            processor = ProcessorReifier.reifier(this.route, output).createProcessor();
        }
        this.camelContext.getCamelContextExtension().getStartupStepRecorder().endStep(step);
        return processor;
    }

    protected Channel makeProcessor() throws Exception {
        Processor processor = null;
        this.preCreateProcessor();
        ProcessorFactory processorFactory = PluginHelper.getProcessorFactory(this.camelContext);
        if (processorFactory != null) {
            processor = processorFactory.createProcessor(this.route, (NamedNode)this.definition);
        }
        if (processor == null) {
            processor = this.createProcessor();
        }
        if (processor instanceof IdAware) {
            IdAware idAware = (IdAware)((Object)processor);
            String id = this.getId((OptionalIdentifiedDefinition<?>)this.definition);
            idAware.setId(id);
        }
        if (processor instanceof RouteIdAware) {
            RouteIdAware routeIdAware = (RouteIdAware)((Object)processor);
            routeIdAware.setRouteId(this.route.getRouteId());
        }
        if (processor == null) {
            return null;
        }
        return this.wrapProcessor(processor);
    }

    protected void preCreateProcessor() {
        ((ProcessorDefinition)this.definition).preCreateProcessor();
    }

    public void configureChild(ProcessorDefinition<?> output) {
    }

    protected String getId(OptionalIdentifiedDefinition<?> def) {
        String id = def.idOrCreate(this.camelContext.getCamelContextExtension().getContextPlugin(NodeIdFactory.class));
        id = this.parseString(id);
        return id;
    }

    public AggregationStrategy getConfiguredAggregationStrategy(AggregationStrategyAwareDefinition<?> definition) {
        AggregationStrategy strategy = definition.getAggregationStrategyBean();
        if (strategy == null && definition.getAggregationStrategyRef() != null) {
            Object aggStrategy = this.lookupByName(definition.getAggregationStrategyRef());
            if (aggStrategy instanceof AggregationStrategy) {
                AggregationStrategy aggregationStrategy;
                strategy = aggregationStrategy = (AggregationStrategy)aggStrategy;
            } else if (aggStrategy instanceof BiFunction) {
                BiFunction biFunction = (BiFunction)aggStrategy;
                AggregationStrategyBiFunctionAdapter adapter = new AggregationStrategyBiFunctionAdapter(biFunction);
                if (definition.getAggregationStrategyMethodAllowNull() != null) {
                    adapter.setAllowNullNewExchange(this.parseBoolean(definition.getAggregationStrategyMethodAllowNull(), false));
                    adapter.setAllowNullOldExchange(this.parseBoolean(definition.getAggregationStrategyMethodAllowNull(), false));
                }
                strategy = adapter;
            } else if (aggStrategy != null) {
                AggregationStrategyBeanAdapter adapter = new AggregationStrategyBeanAdapter(aggStrategy, definition.getAggregationStrategyMethodName());
                if (definition.getAggregationStrategyMethodAllowNull() != null) {
                    adapter.setAllowNullNewExchange(this.parseBoolean(definition.getAggregationStrategyMethodAllowNull(), false));
                    adapter.setAllowNullOldExchange(this.parseBoolean(definition.getAggregationStrategyMethodAllowNull(), false));
                }
                strategy = adapter;
            } else {
                throw new IllegalArgumentException("Cannot find AggregationStrategy in Registry with name: " + definition.getAggregationStrategyRef());
            }
        }
        CamelContextAware.trySetCamelContext(strategy, this.camelContext);
        return strategy;
    }
}

