/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.common;

import java.io.Reader;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import org.cometd.bayeux.Message;
import org.cometd.common.JSONContext;
import org.eclipse.jetty.util.ajax.AsyncJSON;
import org.eclipse.jetty.util.ajax.JSON;

public abstract class JettyJSONContext<M extends Message.Mutable> {
    private final FieldJSON _jsonParser = new FieldJSON();
    private final FieldJSON _messageParser = new MessageJSON();
    private final FieldJSON _messagesParser = new MessagesJSON();
    private final AsyncJSON.Factory _jsonFactory = new AsyncJSONFactory();

    protected JettyJSONContext() {
    }

    public JSON getJSON() {
        return this._jsonParser;
    }

    public AsyncJSON.Factory getAsyncJSONFactory() {
        return this._jsonFactory;
    }

    protected abstract M newMessage();

    public List<M> parse(String json) throws ParseException {
        try {
            Object object = this._messagesParser.parse(new JSON.StringSource(json));
            return this.adapt(object);
        }
        catch (Exception x) {
            throw (ParseException)new ParseException(json, -1).initCause(x);
        }
    }

    public JSONContext.AsyncParser newAsyncParser() {
        AsyncJSON asyncJSON = this.getAsyncJSONFactory().newAsyncJSON();
        return new AsyncJSONParser(asyncJSON);
    }

    private List<M> adapt(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof List) {
            List list = (List)object;
            return list;
        }
        if (object.getClass().isArray()) {
            return List.of((Message.Mutable[])object);
        }
        return List.of((Message.Mutable)object);
    }

    public String generate(M message) {
        return this._messageParser.toJSON(message);
    }

    public JSONContext.Parser getParser() {
        return new JSONParser();
    }

    public JSONContext.Generator getGenerator() {
        return new JSONGenerator();
    }

    public void putConvertor(String className, JSON.Convertor convertor) {
        this.getJSON().addConvertorFor(className, convertor);
        this.getAsyncJSONFactory().putConvertor(className, convertor);
    }

    private class FieldJSON
    extends JSON {
        private FieldJSON() {
        }

        @Override
        protected JSON.Convertor getConvertor(Class<?> forClass) {
            return super.getConvertor(forClass);
        }

        @Override
        public void addConvertor(Class<?> klass, JSON.Convertor convertor) {
            this.addConvertorFor(klass.getName(), convertor);
        }

        @Override
        public void addConvertorFor(String name, JSON.Convertor convertor) {
            super.addConvertorFor(name, convertor);
            JettyJSONContext.this.getAsyncJSONFactory().putConvertor(name, convertor);
        }
    }

    private class MessageJSON
    extends FieldJSON {
        private MessageJSON() {
        }

        @Override
        protected Map<String, Object> newMap() {
            return JettyJSONContext.this.newMessage();
        }

        @Override
        protected JSON contextFor(String field) {
            return JettyJSONContext.this.getJSON();
        }

        @Override
        protected JSON.Convertor getConvertor(Class<?> forClass) {
            return JettyJSONContext.this._jsonParser.getConvertor(forClass);
        }
    }

    private class MessagesJSON
    extends FieldJSON {
        public MessagesJSON() {
            this.setArrayConverter(list -> list);
        }

        @Override
        protected Map<String, Object> newMap() {
            return JettyJSONContext.this.newMessage();
        }

        @Override
        protected JSON contextFor(String field) {
            return JettyJSONContext.this.getJSON();
        }

        @Override
        protected JSON contextForArray() {
            return JettyJSONContext.this._messageParser;
        }

        @Override
        protected JSON.Convertor getConvertor(Class<?> forClass) {
            return JettyJSONContext.this._messageParser.getConvertor(forClass);
        }
    }

    protected class AsyncJSONFactory
    extends AsyncJSON.Factory {
        public AsyncJSONFactory() {
            this.cache("1.0");
            this.cache("advice");
            this.cache("callback-polling");
            this.cache("channel");
            this.cache("clientId");
            this.cache("data");
            this.cache("error");
            this.cache("ext");
            this.cache("id");
            this.cache("interval");
            this.cache("long-polling");
            this.cache("/meta/connect");
            this.cache("/meta/disconnect");
            this.cache("/meta/handshake");
            this.cache("/meta/subscribe");
            this.cache("/meta/unsubscribe");
            this.cache("minimumVersion");
            this.cache("none");
            this.cache("reconnect");
            this.cache("retry");
            this.cache("subscription");
            this.cache("successful");
            this.cache("timeout");
            this.cache("supportedConnectionTypes");
            this.cache("version");
            this.cache("websocket");
        }

        @Override
        public AsyncJSON newAsyncJSON() {
            return new AsyncJSON(this){

                @Override
                protected Map<String, Object> newObject(AsyncJSON.Context context) {
                    if (context.depth() <= 1) {
                        return JettyJSONContext.this.newMessage();
                    }
                    return super.newObject(context);
                }
            };
        }
    }

    protected static class AsyncJSONParser
    implements JSONContext.AsyncParser {
        private final AsyncJSON asyncJSON;

        public AsyncJSONParser(AsyncJSON asyncJSON) {
            this.asyncJSON = asyncJSON;
        }

        @Override
        public void parse(ByteBuffer buffer) {
            this.asyncJSON.parse(buffer);
        }

        @Override
        public <R> R complete() {
            return this.asyncJSON.complete();
        }
    }

    private class JSONParser
    implements JSONContext.Parser {
        private JSONParser() {
        }

        @Override
        public <R> R parse(Reader reader, Class<R> type) {
            return (R)JettyJSONContext.this.getJSON().parse(new JSON.ReaderSource(reader));
        }
    }

    protected class JSONGenerator
    implements JSONContext.Generator {
        protected JSONGenerator() {
        }

        @Override
        public String generate(Object object) {
            return JettyJSONContext.this.getJSON().toJSON(object);
        }
    }
}

